/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime;

import com.collaxa.xml.XPathUtils;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import oracle.bpm.bpmn.engine.runtime.BindingsUtils;
import oracle.bpm.bpmn.engine.runtime.ExecutionBindings;
import oracle.bpm.bpmn.engine.runtime.ExecutionException;
import oracle.bpm.bpmn.engine.runtime.RuntimeEngine;
import oracle.bpm.bpmn.engine.runtime.ScriptEngineProvider;
import oracle.bpm.bpmn.engine.runtime.ScriptExecutionContext;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.ScriptTask;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;

final class XPathEngineProvider
extends ScriptEngineProvider
implements RuntimeEngine {
    static final String LANGUAGE_ID = "XPath";

    XPathEngineProvider() {
    }

    @Override
    public boolean execute(ConditionalFlow flow, ScriptExecutionContext scriptExecutionContext) throws ExecutionException {
        assert (XPathEngineProvider.supports(flow.getExpressionLanguage()));
        XPath xPath = this.createXPath(scriptExecutionContext);
        try {
            return (Boolean)xPath.evaluate(flow.getCondition().getExpressionValue(), null, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public void execute(ScriptTask task, ExecutionBindings inArgs, ExecutionBindings outArgs, ScriptExecutionContext scriptExecutionContext) {
        assert (XPathEngineProvider.supports(task.getLanguage()));
        throw new UnsupportedOperationException("XPath ScriptTasks are not supported. " + task);
    }

    @Override
    public ExecutionBindings execute(DataAssociationSet inArgMap, ScriptExecutionContext scriptExecutionContext) throws ExecutionException {
        ExecutionBindings result = BindingsUtils.createSimple();
        this.executeMap(inArgMap, result, scriptExecutionContext);
        return result;
    }

    @Override
    public void execute(DataAssociationSet outArgMap, ExecutionBindings args, ScriptExecutionContext scriptExecutionContext) throws ExecutionException {
        ExecutionBindings doBindings = scriptExecutionContext.getDataObjectBindings();
        XPath xPath = XPathUtils.getXPath((NamespaceContext)((NamespaceContext)scriptExecutionContext.getEnvironment().get("namespaceContext")));
        xPath.setXPathVariableResolver((XPathVariableResolver)scriptExecutionContext.getEnvironment().get("variableResolver"));
        this.executeMap(outArgMap, doBindings, scriptExecutionContext);
    }

    @Override
    @Nullable
    RuntimeEngine findEngine(String language) {
        return XPathEngineProvider.supports(language) ? this : null;
    }

    private static boolean supports(String language) {
        return LANGUAGE_ID.equals(language);
    }

    private static XPathVariableResolver buildResolver(final ExecutionBindings ... bindings) {
        return new XPathVariableResolver(){

            @Override
            public Object resolveVariable(QName variableName) {
                String variable = variableName.getLocalPart();
                for (ExecutionBindings binding : bindings) {
                    if (!binding.contains(variable)) continue;
                    return binding.get(variable);
                }
                return null;
            }
        };
    }

    private XPath createXPath(ScriptExecutionContext context) {
        XPath xPath = XPathUtils.getXPath((NamespaceContext)((NamespaceContext)context.getEnvironment().get("namespaceContext")));
        xPath.setXPathFunctionResolver((XPathFunctionResolver)context.getEnvironment().get("functionResolver"));
        xPath.setXPathVariableResolver((XPathVariableResolver)context.getEnvironment().get("variableResolver"));
        return xPath;
    }

    private void executeMap(DataAssociationSet inArgMap, ExecutionBindings result, ScriptExecutionContext context) throws ExecutionException {
        XPath xPath = this.createXPath(context);
        for (DataAssociation association : inArgMap.getDataAssociations()) {
            Node node;
            String source = association.getSource().getText();
            try {
                node = (Node)xPath.evaluate(source, null, XPathConstants.NODE);
            }
            catch (XPathExpressionException e) {
                throw new ExecutionException(e);
            }
            String target = association.getTarget().getText();
            result.put(target, node);
        }
    }
}

