/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.bpm.bpmn.engine.runtime.ExecutionBindings;
import oracle.bpm.bpmn.engine.runtime.ExecutionException;
import oracle.bpm.bpmn.engine.runtime.RuntimeEngine;
import oracle.bpm.bpmn.engine.runtime.ScriptEngineProviderFactory;
import oracle.bpm.bpmn.engine.runtime.ScriptExecutionContext;
import oracle.bpm.bpmn.engine.runtime.UnsupportedLanguageException;
import oracle.bpm.extension.Extension;
import oracle.bpm.extensionpoint.metadata.ScriptEngineProviderMetadata;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.ScriptTask;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import org.jetbrains.annotations.NotNull;

public class RuntimeService
implements RuntimeEngine {
    private final Map<String, RuntimeEngine> engines = new HashMap<String, RuntimeEngine>();
    private static final Iterable<Extension<ScriptEngineProviderMetadata>> ENGINE_EXTENSIONS = Platform.getExtensionService().getExtensionsByPoint(ScriptEngineProviderMetadata.class);

    @Override
    public boolean execute(ConditionalFlow flow, ScriptExecutionContext scriptExecutionContext) throws ExecutionException {
        return this.retrieveEngine(flow.getExpressionLanguage()).execute(flow, null);
    }

    @Override
    public ExecutionBindings execute(DataAssociationSet inArgMap, ScriptExecutionContext scriptExecutionContext) throws ExecutionException {
        return this.retrieveEngine("Fuego").execute(inArgMap, scriptExecutionContext);
    }

    @Override
    public void execute(DataAssociationSet outArgMap, ExecutionBindings args, ScriptExecutionContext scriptExecutionContext) throws ExecutionException {
        this.retrieveEngine("Fuego").execute(outArgMap, args, scriptExecutionContext);
    }

    @Override
    public void execute(ScriptTask task, ExecutionBindings inArgs, ExecutionBindings outArgs, ScriptExecutionContext scriptExecutionContext) throws ExecutionException {
        this.retrieveEngine(task.getLanguage()).execute(task, inArgs, outArgs, scriptExecutionContext);
    }

    @NotNull
    private RuntimeEngine retrieveEngine(String language) throws ExecutionException {
        Map<String, RuntimeEngine> engines = this.engines;
        RuntimeEngine result = engines.get(language);
        if (result != null) {
            return result;
        }
        result = this.loadEngineExtension(language);
        engines.put(language, result);
        return result;
    }

    @NotNull
    private RuntimeEngine loadEngineExtension(String language) throws ExecutionException {
        for (Extension<ScriptEngineProviderMetadata> extension : ENGINE_EXTENSIONS) {
            ScriptEngineProviderFactory factory;
            String languagePattern = ((ScriptEngineProviderMetadata)extension.getMetadata()).languagePattern();
            if (!Pattern.matches(languagePattern, language)) continue;
            try {
                factory = (ScriptEngineProviderFactory)extension.instantiateAs(ScriptEngineProviderFactory.class);
            }
            catch (InstantiationException e) {
                throw new ExecutionException(e);
            }
            RuntimeEngine engine = factory.buildEngineProvider().findEngine(language);
            if (engine == null) continue;
            return engine;
        }
        throw new UnsupportedLanguageException(language);
    }
}

