/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime;

import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import oracle.bpm.bpmn.engine.runtime.BindingsUtils;
import oracle.bpm.bpmn.engine.runtime.ExecutionBindings;
import oracle.bpm.bpmn.engine.runtime.ExecutionException;
import oracle.bpm.bpmn.engine.runtime.RuntimeEngine;
import oracle.bpm.bpmn.engine.runtime.ScriptEngineProvider;
import oracle.bpm.bpmn.engine.runtime.ScriptExecutionContext;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.ScriptTask;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import org.jetbrains.annotations.Nullable;

final class JdkScriptingProvider
extends ScriptEngineProvider {
    private final ScriptEngineManager engineManager = new ScriptEngineManager();

    JdkScriptingProvider() {
    }

    @Override
    @Nullable
    RuntimeEngine findEngine(String language) {
        ScriptEngine engine = this.engineManager.getEngineByName(language);
        if (engine == null) {
            return null;
        }
        return new Engine(engine, language);
    }

    private static class Engine
    implements RuntimeEngine {
        private final ScriptEngine engine;
        private final String language;

        Engine(ScriptEngine engine, String language) {
            this.engine = engine;
            this.language = language;
        }

        @Override
        public boolean execute(ConditionalFlow flow, ScriptExecutionContext scriptExecutionContext) throws ExecutionException {
            assert (this.language.equals(flow.getExpressionLanguage()));
            String script = flow.getCondition().getExpressionValue();
            return (Boolean)this.execute(script, this.makeDOBindings(scriptExecutionContext));
        }

        @Override
        public void execute(ScriptTask task, ExecutionBindings inArgs, ExecutionBindings outArgs, ScriptExecutionContext scriptExecutionContext) throws ExecutionException {
            String[] outKeys;
            assert (this.language.equals(task.getLanguage()));
            String script = task.getScript();
            SimpleBindings bindings = new SimpleBindings();
            for (String key : outKeys = outArgs.keys()) {
                bindings.put(key, (Object)null);
            }
            for (String key : inArgs.keys()) {
                bindings.put(key, inArgs.get(key));
            }
            this.execute(script, bindings);
            for (String key : outKeys) {
                outArgs.put(key, bindings.get(key));
            }
        }

        @Override
        public ExecutionBindings execute(DataAssociationSet inArgMap, ScriptExecutionContext scriptExecutionContext) throws ExecutionException {
            ExecutionBindings result = BindingsUtils.createSimple();
            for (DataAssociation association : inArgMap.getDataAssociations()) {
                Object value = this.execute(association.getSource().getText(), this.makeDOBindings(scriptExecutionContext));
                result.put(association.getTarget().getText(), value);
            }
            return result;
        }

        @Override
        public void execute(DataAssociationSet outArgMap, ExecutionBindings args, ScriptExecutionContext scriptExecutionContext) throws ExecutionException {
            Sequence associations = outArgMap.getDataAssociations();
            for (DataAssociation association : associations) {
                Object value = this.execute(association.getSource().getText(), this.makeDOBindings(scriptExecutionContext));
                scriptExecutionContext.getDataObjectBindings().put(association.getTarget().getText(), value);
            }
        }

        private Object execute(String script, Bindings bindings) throws ExecutionException {
            try {
                return this.engine.eval(script, bindings);
            }
            catch (ScriptException e) {
                throw new ExecutionException(e);
            }
        }

        private Bindings makeDOBindings(ScriptExecutionContext scriptExecutionContext) {
            return new SimpleBindings(BindingsUtils.asMap(scriptExecutionContext.getDataObjectBindings()));
        }

        private Bindings makeBindings(ExecutionBindings args, ScriptExecutionContext scriptExecutionContext) {
            Bindings bindings = this.makeDOBindings(scriptExecutionContext);
            bindings.putAll((Map<? extends String, ? extends Object>)BindingsUtils.asMap(args));
            return bindings;
        }
    }
}

