/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.catalog.AccessType;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.DataDeclarationType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.DataObject;
import org.jetbrains.annotations.NotNull;

public class DataDeclarationBpmnDecorator
implements DataDeclaration {
    private BpmnStructureType bpmnStructureType;
    private DataDeclaration delegate;
    private boolean initialized;
    private boolean nativeStructure;
    private URI resourceLocation;
    private LocationType resourceLocationType;
    private QName structure;

    public DataDeclarationBpmnDecorator(DataDeclaration delegate) {
        this.delegate = delegate;
        this.initialize();
    }

    public URI getResourceLocation() {
        return this.resourceLocation;
    }

    public LocationType getResourceLocationType() {
        return this.resourceLocationType;
    }

    public BpmnStructureType getStructureType() {
        return this.bpmnStructureType;
    }

    public QName getStructure() {
        return this.structure;
    }

    public String getName() {
        return this.delegate.getName();
    }

    public int getPosition() {
        return this.delegate.getPosition();
    }

    public String getNativeName() {
        return this.getName();
    }

    public CatalogType getType() {
        return this.delegate.getType();
    }

    public boolean isPredefinedDeclaration() {
        return false;
    }

    public boolean isIn() {
        return this.delegate.isIn();
    }

    public boolean isOut() {
        return this.delegate.isOut();
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isShadowed(DataDeclarationContainer context) {
        return this.delegate.isShadowed(context);
    }

    public void setName(String name) {
        this.delegate.setName(name);
    }

    public void setType(CatalogType type) {
        this.delegate.setType(type);
    }

    public DataDeclarationContainer getDeclarationContainer() {
        return this.delegate.getDeclarationContainer();
    }

    public Sequence<DataDeclaration> getDeclarations() {
        return this.delegate.getDeclarations();
    }

    public DataDeclaration findDeclaration(String name) {
        return this.delegate.findDeclaration(name);
    }

    public boolean isMutableDeclarationContainer() {
        return this.delegate.isMutableDeclarationContainer();
    }

    public Sequence<DataDeclaration> findDeclarationPath(String path) {
        return this.delegate.findDeclarationPath(path);
    }

    public DataDeclaration createDeclaration(String name, CatalogType type) throws ProjectException {
        return this.delegate.createDeclaration(name, type);
    }

    public DataDeclaration createDeclaration(String name, CatalogType type, AccessType accessType) throws ProjectException {
        return this.delegate.createDeclaration(name, type, accessType);
    }

    public void addDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        this.delegate.addDeclaration(dataDeclaration);
    }

    public void removeDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        this.delegate.removeDeclaration(dataDeclaration);
    }

    public void clearDeclarations() throws ProjectException {
        this.delegate.clearDeclarations();
    }

    public DataDeclarationType getDeclarationType() {
        return this.delegate.getDeclarationType();
    }

    public Sequence<DataDeclaration> getLocalDeclarations() {
        return this.delegate.getLocalDeclarations();
    }

    public DataDeclarationContainer getParentScope() {
        return this.delegate.getParentScope();
    }

    public DataDeclaration findLocalDeclaration(String name) {
        return this.delegate.findLocalDeclaration(name);
    }

    public String getId() {
        return this.delegate.getId();
    }

    public ProjectObjectType getProjectObjectType() {
        return this.delegate.getProjectObjectType();
    }

    public Project getProject() {
        return this.delegate.getProject();
    }

    public Path getPath() {
        return this.delegate.getPath();
    }

    public boolean isReadOnly() {
        return this.delegate.isReadOnly();
    }

    public ProjectObject getParentObject() {
        return this.delegate.getParentObject();
    }

    public boolean isDescendantOf(ProjectObject projectObject) {
        return this.delegate.isDescendantOf(projectObject);
    }

    public void replace(ProjectObject newObject) throws ProjectException {
        this.delegate.replace(newObject);
    }

    public Class getRawClass() {
        return this.delegate.getRawClass();
    }

    public boolean is(Class<? extends ProjectObject> clazz) {
        return this.delegate.is(clazz);
    }

    public boolean isActive() {
        return this.delegate.isActive();
    }

    public boolean isDefault() {
        return this.delegate.isDefault();
    }

    public void visit(ProjectVisitor visitor) throws ProjectException {
        this.delegate.visit(visitor);
    }

    public boolean isDeletable() {
        return this.delegate.isDeletable();
    }

    public ResourceObject findResourceObject() {
        return this.delegate.findResourceObject();
    }

    public void setId(String id) {
        this.delegate.setId(id);
    }

    public void setDeletable(boolean value) {
        this.delegate.setDeletable(value);
    }

    public void setReadOnly(boolean value) {
        this.delegate.setReadOnly(value);
    }

    public void setDefault(boolean isDefault) {
        this.delegate.setDefault(isDefault);
    }

    public void delete() throws ProjectException {
        this.delegate.delete();
    }

    public boolean isNativeStructure() {
        return this.nativeStructure;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    DataDeclaration getDelegate() {
        return this.delegate;
    }

    private static QName getPrimitiveTypeQName(@NotNull SchemaObject schemaObject) {
        return new QName(schemaObject.getNamespace(), schemaObject.getName());
    }

    private static QName getBusinessObjectTypeQName(@NotNull SchemaObject schemaObject) {
        return new QName(schemaObject.getNamespace(), schemaObject.getName());
    }

    private static QName getBusinessObjectElementQName(@NotNull SchemaObject schemaObject) {
        return new QName(schemaObject.getNamespace(), schemaObject.getName());
    }

    private static URI getBusinessObjectResourceLocation(@NotNull SchemaObject schemaObject) {
        URI uri = null;
        String resourceLocation = schemaObject.getLocation();
        if (resourceLocation != null) {
            if (resourceLocation.startsWith("/") && resourceLocation.length() > 1) {
                resourceLocation = resourceLocation.substring(1);
            }
            try {
                uri = new URI(resourceLocation);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return uri;
    }

    private static LocationType getBusinessObjectResourceLocationType(@NotNull SchemaObject schemaObject) {
        return schemaObject.isFromWsdl() ? LocationType.WSDL : LocationType.XSD;
    }

    private void initialize() {
        if (this.getDelegate() instanceof DataObject) {
            DataObject dataObject = (DataObject)this.getDelegate();
            this.initialized = dataObject.isInitialize();
        } else {
            this.initialized = false;
        }
        TypeDescription typeDescription = this.getDelegate().getType().getDelegate();
        SchemaObject schemaObject = typeDescription.asSchemaObject();
        if (schemaObject.isBpmObjectNamespace()) {
            this.bpmnStructureType = BpmnStructureType.ELEMENT_STRUCTURE;
            this.structure = DataDeclarationBpmnDecorator.getBusinessObjectTypeQName(schemaObject);
        } else if (schemaObject.isElement()) {
            this.bpmnStructureType = BpmnStructureType.ELEMENT_STRUCTURE;
            this.structure = DataDeclarationBpmnDecorator.getBusinessObjectElementQName(schemaObject);
        } else if (schemaObject.isType()) {
            this.bpmnStructureType = BpmnStructureType.TYPE_STRUCTURE;
            this.structure = DataDeclarationBpmnDecorator.getBusinessObjectTypeQName(schemaObject);
        } else {
            throw new IllegalArgumentException("Unrecognized schemaObject type " + schemaObject.getXmlElementType() + " in schemaObject " + schemaObject);
        }
        this.resourceLocation = DataDeclarationBpmnDecorator.getBusinessObjectResourceLocation(schemaObject);
        this.resourceLocationType = DataDeclarationBpmnDecorator.getBusinessObjectResourceLocationType(schemaObject);
    }

    public static enum LocationType {
        WSDL,
        XSD;

    }

    static enum BpmnStructureType {
        ELEMENT_STRUCTURE,
        TYPE_STRUCTURE;

    }
}

