/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.types.bpel.CXTypeVariable;
import com.collaxa.cube.xml.xsd.SchemaToXML;
import com.collaxa.cube.xml.xsd.XPathQueryInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.runtime.DataDeclarationBpmnDecorator;
import oracle.bpm.bpmn.engine.runtime.DataElementVariable;
import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.fabric.common.wsdl.SchemaManager;
import oracle.fabric.common.xml.xpath.functions.xpath20.Xpath20;
import oracle.xml.parser.v2.XMLElement;
import org.collaxa.thirdparty.jaxen.NamespaceContext;

public class CXTypeDataElementVariable
extends DataElementVariable<CXTypeVariable> {
    private CXTypeVariable cxTypeVariable;
    private static final String XMLSCHEMA_URI = "http://www.w3.org/2001/XMLSchema";
    private static final QName BOOLEAN_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "boolean");
    private static final QName DATETIME_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "dateTime");
    private static final QName DATE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "date");
    private static final QName TIME_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "time");
    private static final QName UNSIGNEDBYTE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "unsignedByte");
    private static final QName UNSIGNEDSHORT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "unsignedShort");
    private static final QName UNSIGNEDINT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "unsignedInt");
    private static final QName UNSIGNEDLONG_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "unsignedLong");
    private static final QName BYTE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "byte");
    private static final QName INT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "int");
    private static final QName LONG_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "long");
    private static final QName INTEGER_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "integer");
    private static final QName SHORT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "short");
    private static final QName POSITIVEINTEGER_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "positiveInteger");
    private static final QName FLOAT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "float");
    private static final QName DOUBLE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "double");
    private static final QName DECIMAL_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "decimal");
    private static final QName STRING_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "string");
    private static final QName DURATION_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "duration");
    private static final Map<QName, String> INITIALVALUES_MAP = new HashMap<QName, String>();

    public CXTypeDataElementVariable(DataDeclaration dataDeclaration, CXTypeVariable cxTypeVariable) {
        super(dataDeclaration);
        this.cxTypeVariable = cxTypeVariable;
    }

    @Override
    public boolean isNativeStructure() {
        return this.getStructure().getType().getNamespaceURI().equals(XMLSCHEMA_URI);
    }

    @Override
    public Object getValue() {
        return this.cxTypeVariable.getValue();
    }

    @Override
    public CXTypeVariable getStructure() {
        return this.cxTypeVariable;
    }

    @Override
    public void initValue(NamespaceContext namespaceContext, SchemaManager schemaManager) throws CubeException {
        String defaultValue;
        QName rootQName = new QName(null, this.getStructure().getName());
        QName typeQName = this.getStructure().getType();
        XMLElement value = SchemaToXML.generateXMLElementForType((String)this.getStructure().getName(), (int)-1, (QName)rootQName, (QName)typeQName, null, (boolean)false, (NamespaceContext)namespaceContext, (SchemaManager)schemaManager);
        if (this.isNativeStructure() && (defaultValue = this.getDefaultValue()) != null) {
            value.setTextContent(defaultValue);
        }
        this.setValue(value);
    }

    @Override
    public void initValue(NamespaceContext namespaceContext, SchemaManager schemaManager, List<XPathQueryInfo> pXpathExpr) throws CubeException {
        QName rootQName = new QName(null, this.getStructure().getName());
        QName typeQName = this.getStructure().getType();
        this.setValue(SchemaToXML.generateXMLElementForType((String)this.getStructure().getName(), (int)-1, (QName)rootQName, (QName)typeQName, pXpathExpr, (boolean)true, (NamespaceContext)namespaceContext, (SchemaManager)schemaManager));
    }

    @Override
    public boolean isUndefined() {
        return this.getStructure().getValue() == null;
    }

    @Override
    public void setValue(Object value) {
        this.cxTypeVariable.setValue(value);
    }

    private boolean isBusinessVariableCounter() {
        DataDeclaration dataDeclarationDelegate;
        boolean result = false;
        if (this.getDataDeclaration() instanceof DataDeclarationBpmnDecorator && (dataDeclarationDelegate = ((DataDeclarationBpmnDecorator)this.getDataDeclaration()).getDelegate()) instanceof ProjectDataObject) {
            result = ((ProjectDataObject)dataDeclarationDelegate).getBusinessVariableType().equals((Object)BusinessVariableType.COUNTER);
        }
        return result;
    }

    private String getDefaultValue() {
        QName type = this.getStructure().getType();
        String defaultValue = this.isBusinessVariableCounter() ? String.valueOf(1) : (DATETIME_QNAME.equals(type) ? Xpath20.currentDateTime() : (DATE_QNAME.equals(type) ? Xpath20.currentDate() : (TIME_QNAME.equals(type) ? Xpath20.currentTime() : INITIALVALUES_MAP.get(type))));
        return defaultValue;
    }

    static {
        INITIALVALUES_MAP.put(BOOLEAN_QNAME, String.valueOf(false));
        INITIALVALUES_MAP.put(UNSIGNEDBYTE_QNAME, String.valueOf(0));
        INITIALVALUES_MAP.put(UNSIGNEDSHORT_QNAME, String.valueOf(0));
        INITIALVALUES_MAP.put(UNSIGNEDINT_QNAME, String.valueOf(0));
        INITIALVALUES_MAP.put(UNSIGNEDLONG_QNAME, String.valueOf(0));
        INITIALVALUES_MAP.put(BYTE_QNAME, String.valueOf(0));
        INITIALVALUES_MAP.put(INT_QNAME, String.valueOf(0));
        INITIALVALUES_MAP.put(LONG_QNAME, String.valueOf(0));
        INITIALVALUES_MAP.put(INTEGER_QNAME, String.valueOf(0));
        INITIALVALUES_MAP.put(SHORT_QNAME, String.valueOf(0));
        INITIALVALUES_MAP.put(POSITIVEINTEGER_QNAME, String.valueOf(0));
        INITIALVALUES_MAP.put(FLOAT_QNAME, String.valueOf(0.0));
        INITIALVALUES_MAP.put(DOUBLE_QNAME, String.valueOf(0.0));
        INITIALVALUES_MAP.put(DECIMAL_QNAME, String.valueOf(0.0));
        INITIALVALUES_MAP.put(STRING_QNAME, "");
        INITIALVALUES_MAP.put(DURATION_QNAME, "PT0S");
    }
}

