/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.bpm.bpmn.engine.runtime.ExecutionBindings;
import oracle.bpm.collections.iterator.AbstractIterator;
import oracle.bpm.util.ArrayIterator;
import oracle.bpm.util.ArrayUtils;

public final class BindingsUtils {
    private BindingsUtils() {
    }

    public static ExecutionBindings asExecutionBindings(Map<String, Object> map) {
        return map instanceof BindingsMap ? ((BindingsMap)map).getBindings() : new MapBindings(map);
    }

    public static ExecutionBindings createSimple() {
        return new MapBindings(new HashMap<String, Object>());
    }

    public static Map<String, Object> asMap(ExecutionBindings bindings) {
        return bindings instanceof MapBindings ? ((MapBindings)bindings).getMap() : new BindingsMap(bindings);
    }

    private static class MapBindings
    implements ExecutionBindings {
        private final Map<String, Object> map;

        MapBindings(Map<String, Object> map) {
            this.map = map;
        }

        public Map<String, Object> getMap() {
            return this.map;
        }

        @Override
        public Object get(String key) {
            return this.map.get(key);
        }

        @Override
        public boolean contains(String key) {
            return this.map.containsKey(key);
        }

        @Override
        public void put(String key, Object value) {
            this.map.put(key, value);
        }

        @Override
        public String[] keys() {
            return this.map.keySet().toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        }
    }

    private static class BindingsMap
    extends AbstractMap<String, Object> {
        private final ExecutionBindings bindings;

        BindingsMap(ExecutionBindings bindings) {
            this.bindings = bindings;
        }

        public ExecutionBindings getBindings() {
            return this.bindings;
        }

        @Override
        public Object get(Object key) {
            return this.containsKey(key) ? this.bindings.get((String)key) : null;
        }

        @Override
        public Object put(String key, Object value) {
            Object oldValue = this.get(key);
            this.bindings.put(key, value);
            return oldValue;
        }

        @Override
        public boolean containsKey(Object key) {
            return key instanceof String && this.bindings.contains((String)key);
        }

        @Override
        public Set<String> keySet() {
            final String[] keys = this.bindings.keys();
            return new AbstractSet<String>(){

                @Override
                public Iterator<String> iterator() {
                    return ArrayIterator.create((Object)keys);
                }

                @Override
                public int size() {
                    return keys.length;
                }
            };
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return new AbstractSet<Map.Entry<String, Object>>(){

                @Override
                public Iterator<Map.Entry<String, Object>> iterator() {
                    final String[] keys = BindingsMap.this.bindings.keys();
                    return new AbstractIterator<Map.Entry<String, Object>>(){
                        private int position;

                        protected boolean advance() {
                            if (this.position >= keys.length) {
                                return false;
                            }
                            final String key = keys[this.position++];
                            this.next = new Map.Entry<String, Object>(){

                                @Override
                                public String getKey() {
                                    return key;
                                }

                                @Override
                                public Object getValue() {
                                    return BindingsMap.this.bindings.get(key);
                                }

                                @Override
                                public Object setValue(Object value) {
                                    return BindingsMap.this.put(key, value);
                                }
                            };
                            return true;
                        }
                    };
                }

                @Override
                public int size() {
                    return BindingsMap.this.bindings.keys().length;
                }
            };
        }
    }
}

