/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.runtime;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.lang.compiler.bpel.BPELDefs;
import com.collaxa.cube.xml.dom.DOMException;
import com.collaxa.cube.xml.dom.DOMUtil;
import com.oracle.bpel.client.BPELFault;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNNamespaceContext;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionDataElementContextType;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionExecutionContext;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionMetadata;
import oracle.bpm.bpmn.engine.runtime.DataElementVariable;
import oracle.bpm.bpmn.engine.runtime.xpath.BPMNJaxenXPathUtil;
import oracle.bpm.bpmn.engine.runtime.xpath.BPMNXPathUtil;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.FlowNode;
import org.w3c.dom.Node;

public class BPMNExpression {
    private BPMNExpressionMetadata bpmnExpressionMetadata;
    private Map<String, DataElementVariable> dataElementVariables;
    private Properties directives;
    private Map<String, DataElementVariable> externalDataElementVariables;
    private FlowNode node;
    public static String DIRECTIVE_ONDEMANDINIT = "DIRECTIVE_ONDEMANDINIT";

    private BPMNExpression(BPMNExpressionMetadata bpmnExpressionMetadata, Map<String, DataElementVariable> dataElementVariables, FlowNode node) {
        this(bpmnExpressionMetadata, dataElementVariables, null, node);
    }

    private BPMNExpression(BPMNExpressionMetadata bpmnExpressionMetadata, Map<String, DataElementVariable> dataElementVariables, Map<String, DataElementVariable> externalDataElementVariables, FlowNode node) {
        this.bpmnExpressionMetadata = bpmnExpressionMetadata;
        this.dataElementVariables = dataElementVariables;
        this.externalDataElementVariables = externalDataElementVariables;
        this.directives = new Properties();
        this.directives.setProperty(DIRECTIVE_ONDEMANDINIT, Boolean.FALSE.toString());
        this.node = node;
    }

    public static BPMNExpression createBPMNExpression(FlowNode flowNode, BPMNExpressionMetadata bpmnExpressionMetadata, IScope scope) throws CubeException {
        if (!BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT.equals((Object)bpmnExpressionMetadata.getDataContextType())) {
            throw new IllegalArgumentException("Only dataObject contexts can create from scope.");
        }
        HashMap<String, DataElementVariable> dataElementVariables = new HashMap<String, DataElementVariable>();
        Sequence<String> dataElementRefs = bpmnExpressionMetadata.getDataElements();
        HashMap<String, DataElementVariable> externalDataElementVariables = new HashMap<String, DataElementVariable>();
        Sequence<String> externalDataElementRefs = bpmnExpressionMetadata.getExternalDataElements();
        if (dataElementRefs != null) {
            BPMNExpression.fillDataElementVariablesFromDataObjectRefs(flowNode, scope, dataElementVariables, dataElementRefs);
        } else {
            Sequence<DataObject> dataObjects = DataHandlingUtils.getDataObjectsInScope(flowNode);
            for (DataObject dataObject : dataObjects) {
                Object cubeVariable = scope.getObject(dataObject.getName());
                if (cubeVariable == null) continue;
                DataElementVariable dataElementVariable = DataElementVariable.create((DataDeclaration)dataObject, cubeVariable);
                dataElementVariables.put(dataObject.getName(), dataElementVariable);
            }
        }
        if (externalDataElementRefs != null) {
            BPMNExpression.fillDataElementVariablesFromDataObjectRefs(flowNode, scope, externalDataElementVariables, externalDataElementRefs);
        }
        return BPMNExpression.createBPMNExpression(bpmnExpressionMetadata, dataElementVariables, externalDataElementVariables, flowNode);
    }

    public static void fillDataElementVariablesFromDataObjectRefs(FlowNode flowNode, IScope scope, HashMap<String, DataElementVariable> dataElementVariables, Sequence<String> dataElementRefs) throws CubeException {
        if (dataElementRefs != null) {
            for (String dataElementRef : dataElementRefs) {
                Object cubeVariable;
                DataObject dataObject = DataHandlingUtils.getDataObject(flowNode, dataElementRef);
                if (dataObject == null || (cubeVariable = scope.getObject(dataObject.getName())) == null) continue;
                DataElementVariable dataElementVariable = DataElementVariable.create((DataDeclaration)dataObject, cubeVariable);
                dataElementVariables.put(dataElementRef, dataElementVariable);
            }
        }
    }

    public static BPMNExpression createBPMNExpression(BPMNExpressionMetadata bpmnExpressionMetadata, Map<String, DataElementVariable> dataElementVariables, FlowNode node) {
        return new BPMNExpression(bpmnExpressionMetadata, dataElementVariables, node);
    }

    public static BPMNExpression createBPMNExpression(BPMNExpressionMetadata bpmnExpressionMetadata, Map<String, DataElementVariable> dataElementVariables, Map<String, DataElementVariable> externalDataElementVariables, FlowNode flowNode) {
        return new BPMNExpression(bpmnExpressionMetadata, dataElementVariables, externalDataElementVariables, flowNode);
    }

    public void setOnDemandInit() {
        this.directives.setProperty(DIRECTIVE_ONDEMANDINIT, Boolean.TRUE.toString());
    }

    public Map<String, DataElementVariable> getExternalDataElementVariables() {
        return this.externalDataElementVariables;
    }

    public BPMNExpressionMetadata getBpmnExpressionMetadata() {
        return this.bpmnExpressionMetadata;
    }

    public Map<String, DataElementVariable> getDataElementVariables() {
        return this.dataElementVariables;
    }

    public Object evaluateObject(IScope sc, ICubeContext ctx) throws CubeException {
        return this.evaluate(sc, ctx, BPMNExpressionResultType.OBJECT);
    }

    public Node evaluateNode(IScope sc, ICubeContext ctx) throws CubeException {
        return (Node)this.evaluate(sc, ctx, BPMNExpressionResultType.NODE);
    }

    public Node evaluateSingleNode(IScope sc, ICubeContext ctx) throws CubeException {
        return (Node)this.evaluate(sc, ctx, BPMNExpressionResultType.SINGLENODE);
    }

    public String evaluateString(IScope sc, ICubeContext ctx) throws CubeException {
        return (String)this.evaluate(sc, ctx, BPMNExpressionResultType.STRING);
    }

    public Number evaluateNumber(IScope sc, ICubeContext ctx) throws CubeException {
        return (Number)this.evaluate(sc, ctx, BPMNExpressionResultType.NUMBER);
    }

    public Boolean evaluateBoolean(IScope sc, ICubeContext ctx) throws CubeException {
        return (Boolean)this.evaluate(sc, ctx, BPMNExpressionResultType.BOOLEAN);
    }

    public Properties getDirectives() {
        return this.directives;
    }

    private Object evaluate(IScope sc, ICubeContext ctx, BPMNExpressionResultType bpmnExpressionResultType) throws CubeException {
        BPMNExpressionExecutionContext bpmnExpressionExecutionContext = new BPMNExpressionExecutionContext(this.getBpmnExpressionMetadata(), this.getDataElementVariables(), this.getExternalDataElementVariables(), this.directives, this.node);
        Object result = Boolean.valueOf(this.directives.getProperty(DIRECTIVE_ONDEMANDINIT)) != false ? this.evaluateXPathOnDemandInit(bpmnExpressionExecutionContext, sc, ctx, bpmnExpressionResultType) : this.evaluateXPath(bpmnExpressionExecutionContext, sc, ctx, bpmnExpressionResultType);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object evaluateXPath(BPMNExpressionExecutionContext bpmnExpressionExecutionContext, IScope sc, ICubeContext ctx, BPMNExpressionResultType bpmnExpressionResultType) throws CubeException {
        try {
            boolean expectSingleNode = true;
            BPMNNamespaceContext fromElementNamespaceContext = new BPMNNamespaceContext(this.getBpmnExpressionMetadata().getMetadataContextElement());
            ctx.addToEnvironment("__namespace-ctx", (Object)fromElementNamespaceContext);
            XPath xpath = BPMNXPathUtil.createXPath(bpmnExpressionExecutionContext, fromElementNamespaceContext, ctx, sc);
            QName returnType = BPMNXPathUtil.mapBPMNExpressionResultType(bpmnExpressionResultType);
            Object fromValue = BPMNXPathUtil.evaluate(this.getBpmnExpressionMetadata().getExpression(), xpath, ctx, returnType, CubeContextHelper.getCubeProcess((ICubeContext)ctx).getScaComponent());
            fromValue = BPMNXPathUtil.checkExpressionValue(fromValue, this.getBpmnExpressionMetadata().getExpression(), expectSingleNode, -1);
            int size = DOMUtil.getListSize((Object)fromValue);
            if (expectSingleNode) {
                if (size > 1) {
                    DOMException ex = new DOMException(9223, new Object[]{this.getBpmnExpressionMetadata().getExpression(), -1});
                    throw new BPELFault(BPELDefs.QN_SELECTION_FAILURE, ex.getMessage());
                }
                if (size == 1) {
                    fromValue = DOMUtil.getFirstItem((Object)fromValue);
                }
            }
            if (fromValue == null) {
                DOMException ex = new DOMException(9204, new Object[]{-1});
                throw new BPELFault(BPELDefs.QN_SELECTION_FAILURE, ex.getMessage());
            }
            Object object = fromValue;
            return object;
        }
        finally {
            ctx.removeFromEnvironment("__extra-xpath");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object evaluateXPathOnDemandInit(BPMNExpressionExecutionContext bpmnExpressionExecutionContext, IScope sc, ICubeContext ctx, BPMNExpressionResultType bpmnExpressionResultType) throws CubeException {
        try {
            BPMNNamespaceContext toElementNamespaceContext = new BPMNNamespaceContext(bpmnExpressionExecutionContext.getExpressionData().getMetadataContextElement());
            ctx.addToEnvironment("__namespace-ctx", (Object)toElementNamespaceContext);
            String toExpression = bpmnExpressionExecutionContext.getExpressionData().getExpression();
            Object toValue = BPMNJaxenXPathUtil.evaluate(toExpression, bpmnExpressionExecutionContext, toElementNamespaceContext, ctx, sc);
            toValue = BPMNXPathUtil.checkExpressionValue(toValue, toExpression, false, -1);
            if (toValue == null) {
                DOMException ex = new DOMException(9205, new Object[]{toExpression, -1});
                throw new BPELFault(BPELDefs.QN_SELECTION_FAILURE, ex.getMessage());
            }
            if (DOMUtil.isList((Object)toValue)) {
                DOMException ex = new DOMException(9223, new Object[]{toExpression, -1});
                throw new BPELFault(BPELDefs.QN_SELECTION_FAILURE, ex.getMessage());
            }
            Object object = toValue;
            return object;
        }
        finally {
            ctx.removeFromEnvironment("__namespace-ctx");
        }
    }

    public static enum BPMNExpressionResultType {
        NODE,
        SINGLENODE,
        NUMBER,
        BOOLEAN,
        STRING,
        OBJECT;

    }
}

