/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMRuntimeLogger;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLNodeList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XSLMapper {
    public static Node transform(Node sourceNode, Map paramsMap, Transformer transformer, DocumentBuilder db) throws Exception {
        BPMRuntimeLogger.log(Level.FINE, XSLMapper.class.toString(), "transform", "Begin Transformation");
        transformer.clearParameters();
        if (paramsMap != null) {
            for (String key : paramsMap.keySet()) {
                Node node = (Node)paramsMap.get(key);
                Document dummyDoc = db.newDocument();
                dummyDoc.appendChild(dummyDoc.importNode(node, true));
                XMLNodeList nodeList = new XMLNodeList();
                nodeList.addNode((Node)dummyDoc);
                transformer.setParameter(key, nodeList);
            }
        }
        DOMResult result = new DOMResult();
        Document sourceDoc = db.newDocument();
        sourceDoc.appendChild(sourceDoc.importNode(sourceNode, true));
        DOMSource domSource = new DOMSource(sourceDoc);
        transformer.transform(domSource, result);
        BPMRuntimeLogger.log(Level.FINE, XSLMapper.class.toString(), "transform", "End Transformation");
        XMLNode node = (XMLNode)result.getNode();
        return node;
    }

    public static Transformer getTransformer(InputStream in) throws Exception {
        StreamSource sourceXsl = new StreamSource(in);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(sourceXsl);
        boolean isSupported = false;
        isSupported = transformerFactory.getFeature("http://javax.xml.transform.dom.DOMSource/feature");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        return transformer;
    }

    public static DocumentBuilder getDocumentBuilder() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        return dbf.newDocumentBuilder();
    }

    public static void test() throws Exception {
        String inputFile = "/scratch/dthakkar/test/transform/Project1/test/xml/collection1.xml";
        String xsltFile = "/scratch/dthakkar/test/transform/Project1/test/xsl/collection1.xsl";
        StreamSource sourceXsl = new StreamSource(new FileInputStream(xsltFile));
        DocumentBuilderFactory docBuildFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = docBuildFactory.newDocumentBuilder();
        Document document = parser.parse(new File(inputFile));
        DOMSource source = new DOMSource(document);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(sourceXsl);
        DOMResult result = new DOMResult();
        transformer.transform(source, result);
        Node node = result.getNode();
        StringWriter stringWriter = new StringWriter();
        ((XMLNode)node).print((Writer)stringWriter);
        String nodeValue = stringWriter.toString();
        System.out.println(nodeValue);
    }
}

