/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.util;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.types.bpel.CXMessageVariable;
import com.collaxa.cube.engine.types.bpel.CXPart;
import com.collaxa.cube.xml.dom.DOMUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.microkernel.MDServiceActivity;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.fabric.common.wsdl.WSDLManager;
import oracle.xml.parser.v2.XMLElement;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceInteractionUtils {
    public static WSDLManager getWSDLManager(ICubeContext ctx) {
        return CubeContextHelper.getScaComponent((ICubeContext)ctx).getComposite().getWSDLManager();
    }

    public static String obtainReferenceName(BusinessRuleTask task) {
        BusinessRule businessRule = task.getBusinessRule();
        CatalogMember function = task.getFunction();
        String referenceName = businessRule.getText() + "." + function.getName() + ".reference";
        return referenceName;
    }

    public static Map<String, Object> unwrapArguments(@NotNull DataAssociationSet dataAssociationSet, @NotNull CXMessageVariable cxMessageVariable) throws CubeException {
        CXPart part;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!cxMessageVariable.getParts().isEmpty() && (part = (CXPart)cxMessageVariable.getParts().get(0)) != null) {
            XMLElement payloadElement = (XMLElement)cxMessageVariable.get((Object)part.getName());
            Sequence dataDeclarationSequence = dataAssociationSet.getArguments();
            int index = 0;
            for (DataDeclaration dataDeclaration : dataDeclarationSequence) {
                NodeList childNodes = payloadElement.getChildNodes();
                while (index < childNodes.getLength() && !(childNodes.item(index) instanceof XMLElement)) {
                    ++index;
                }
                if (index >= childNodes.getLength()) break;
                XMLElement element = (XMLElement)childNodes.item(index);
                ServiceInteractionUtils.checkWrappedArgument(dataDeclaration, element);
                result.put(dataDeclaration.getNativeName(), element);
                ++index;
            }
        }
        return result;
    }

    public static void wrapArguments(@NotNull DataAssociationSet dataAssociationSet, @NotNull CXMessageVariable cxMessageVariable, @NotNull Map<String, Object> payload, QName wrapperQName) throws CubeException {
        if (!cxMessageVariable.getParts().isEmpty()) {
            CXPart part = (CXPart)cxMessageVariable.getParts().get(0);
            Element wrapperElement = DOMUtil.createRootElement((String)wrapperQName.getLocalPart(), (String)wrapperQName.getNamespaceURI());
            Sequence dataDeclarationSequence = dataAssociationSet.getArguments();
            for (DataDeclaration dataDeclaration : dataDeclarationSequence) {
                XMLElement xmlElement = (XMLElement)payload.get(dataDeclaration.getNativeName());
                xmlElement = (XMLElement)wrapperElement.getOwnerDocument().adoptNode((Node)xmlElement);
                wrapperElement.appendChild((Node)xmlElement);
            }
            cxMessageVariable.put((Object)part.getName(), (Object)wrapperElement);
        }
    }

    public static boolean isWrappedArguments(MDServiceActivity mdServiceActivity, CXMessageVariable cxMessageVariable) {
        CXPart cxPart;
        boolean result = false;
        if (ServiceInteractionUtils.allowsWrappedArguments(mdServiceActivity) && cxMessageVariable.getParts().size() == 1 && (cxPart = (CXPart)cxMessageVariable.getParts().get(0)) != null) {
            result = cxMessageVariable.getMessageType().equals(cxPart.getElement());
        }
        return result;
    }

    public static CXMessageVariable buildMessageVariable(String variableName, QName messageType, IScope sc, ICubeContext ctx) {
        Message message;
        CXMessageVariable cxMessageVariable = new CXMessageVariable();
        cxMessageVariable.setName(variableName);
        cxMessageVariable.setMessageType(messageType);
        ArrayList<CXPart> cxParts = new ArrayList<CXPart>();
        WSDLManager wsdlManager = ServiceInteractionUtils.getWSDLManager(ctx);
        if (wsdlManager != null && (message = wsdlManager.lookupMessage(messageType)) != null) {
            Map parts = message.getParts();
            for (Object partObject : parts.values()) {
                Part part = (Part)partObject;
                CXPart cxPart = new CXPart();
                cxPart.setName(part.getName());
                if (part.getTypeName() != null) {
                    cxPart.setType(part.getTypeName());
                } else if (part.getElementName() != null) {
                    cxPart.setElement(part.getElementName());
                }
                cxParts.add(cxPart);
            }
        }
        cxMessageVariable.setParts(cxParts);
        return cxMessageVariable;
    }

    private static void checkWrappedArgument(@NotNull DataDeclaration dataDeclaration, @NotNull XMLElement element) throws CubeException {
        SchemaObject schemaObject = dataDeclaration.getType().getDelegate().asSchemaObject();
        if (schemaObject.isType()) {
            if (!element.getLocalName().equals(dataDeclaration.getNativeName())) {
                throw new CubeException(75005, new Object[]{dataDeclaration.getNativeName(), element.getLocalName()});
            }
        } else if (!element.getLocalName().equals(schemaObject.getName())) {
            throw new CubeException(75005, new Object[]{schemaObject.getName(), element.getLocalName()});
        }
    }

    private static boolean allowsWrappedArguments(MDServiceActivity mdServiceActivity) {
        return mdServiceActivity.isAllowsWrappedArguments();
    }
}

