/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.util;

import java.net.URL;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public class SchemaUtils {
    private static int MAXIMUM_TREE_DEPTH = 3;

    public static XMLSchema buildSchemaFromUrl(URL url) throws Exception {
        XSDBuilder builder = new XSDBuilder();
        return builder.build(url);
    }

    public static XMLElement generateXMLForXSDType(XMLSchema schema, XMLDocument document, String namespace, String argName, String complexTypeNS, String complexTypeName) throws Exception {
        XMLSchemaNode schemaNodes = schema.getSchemaByTargetNS(complexTypeNS);
        XSDNode[] allComplexTypes = schemaNodes.getComplexTypeSet();
        XMLElement complexElement = (XMLElement)document.createElementNS(namespace, argName);
        for (int j = 0; j < allComplexTypes.length; ++j) {
            XSDComplexType cmplxType = (XSDComplexType)allComplexTypes[j];
            if (cmplxType.getName() == null || !cmplxType.getName().equals(complexTypeName)) continue;
            return SchemaUtils.generateXMLForXSDNode(schema, complexElement, cmplxType.getChildElements(), 0);
        }
        return complexElement;
    }

    public static XMLElement generateXMLForXSDElement(XMLSchema schema, XMLDocument document, String namespace, String argName) throws Exception {
        XSDElement xsdElement = schema.getElement(namespace, argName);
        XSDNode[] nodes = null;
        if (xsdElement != null) {
            nodes = xsdElement.getChildElements();
        }
        XMLElement rootElement = (XMLElement)document.createElementNS(namespace, argName);
        return SchemaUtils.generateXMLForXSDNode(schema, rootElement, nodes, 0);
    }

    private static XMLElement generateXMLForXSDNode(XMLSchema schema, XMLElement rootElement, XSDNode[] childNodes, int treeDepth) throws Exception {
        if (treeDepth < 0 || treeDepth > MAXIMUM_TREE_DEPTH) {
            return null;
        }
        if (treeDepth == MAXIMUM_TREE_DEPTH) {
            return rootElement;
        }
        if (childNodes != null) {
            block0: for (int i = 0; i < childNodes.length; ++i) {
                XSDNode node = childNodes[i];
                if (!node.isNodeType(3)) continue;
                XSDElement xsdElem = (XSDElement)node;
                String nodeName = xsdElem.getName();
                String nodeNS = xsdElem.getTargetNS();
                if (nodeName != null) {
                    if (xsdElem.getMinOccurs() == 0 && xsdElem.getMaxOccurs() == 0x7FFFFFF8) continue;
                    if (xsdElem.getType() instanceof XSDSimpleType) {
                        rootElement.appendChild((Node)rootElement.getDocument().createElementNS(nodeNS, nodeName));
                        continue;
                    }
                    if (!(xsdElem.getType() instanceof XSDComplexType)) continue;
                    XSDComplexType complexType = (XSDComplexType)xsdElem.getType();
                    String complexNodeName = complexType.getName();
                    String complexNodeNS = complexType.getTargetNS();
                    XMLSchemaNode schemaNodes = schema.getSchemaByTargetNS(complexNodeNS);
                    XSDNode[] allComplexTypes = schemaNodes.getComplexTypeSet();
                    for (int j = 0; j < allComplexTypes.length; ++j) {
                        XSDComplexType cmplxType = (XSDComplexType)allComplexTypes[j];
                        if (cmplxType.getName() == null || !cmplxType.getName().equals(complexNodeName)) continue;
                        XMLElement complexElement = (XMLElement)rootElement.getDocument().createElementNS(nodeNS, nodeName);
                        rootElement.appendChild((Node)SchemaUtils.generateXMLForXSDNode(schema, complexElement, cmplxType.getChildElements(), treeDepth + 1));
                        continue block0;
                    }
                    continue;
                }
                String refName = xsdElem.getRefLocalname();
                String refNamespace = xsdElem.getRefNamespace();
                if (refName == null) continue;
                XSDElement xsdElement = schema.getElement(refNamespace, refName);
                XMLElement xmlElement = (XMLElement)rootElement.getDocument().createElementNS(refNamespace, refName);
                rootElement.appendChild((Node)SchemaUtils.generateXMLForXSDNode(schema, xmlElement, xsdElement.getChildElements(), treeDepth + 1));
            }
        }
        return rootElement;
    }
}

