/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.util;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.CubeEngineLogger;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.ext.bpel.common.BPELWMPHelper;
import com.collaxa.cube.engine.types.bpel.CXElementVariable;
import com.collaxa.cube.engine.types.bpel.CXTypeVariable;
import com.collaxa.cube.xml.dom.DOMUtil;
import com.collaxa.cube.xml.xpath.XPathException;
import com.collaxa.cube.xml.xsd.SchemaToXML;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.model.blocks.BPMNProcessBlock;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNNamespaceContext;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMRuntimeLogger;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingMsg;
import oracle.bpm.bpmn.engine.model.runtime.util.XSLMapper;
import oracle.bpm.bpmn.engine.runtime.BPMNExpression;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionDataElementContextType;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionLanguage;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionMetadata;
import oracle.bpm.bpmn.engine.runtime.CXTypeDataElementVariable;
import oracle.bpm.bpmn.engine.runtime.DataDeclarationBpmnDecorator;
import oracle.bpm.bpmn.engine.runtime.DataElementVariable;
import oracle.bpm.bpmn.engine.runtime.InstanceAttributeType;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.processes.DataElementScope;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItem;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.processes.dataassociations.DataTransformation;
import oracle.fabric.common.wsdl.SchemaManager;
import oracle.fabric.common.wsdl.XSDException;
import oracle.fabric.common.xml.util.XMLSchemaTypeManager;
import oracle.fabric.composite.model.ComponentModel;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.v2.XMLElement;
import org.collaxa.thirdparty.jaxen.NamespaceContext;
import org.collaxa.thirdparty.jaxen.SimpleNamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataHandlingUtils {
    public static void declareDataObjects(IScope sc, ICubeContext ctx, DataElementScope dataElementScope) throws CubeException {
        for (DataObject dataObject : dataElementScope.getDataObjects()) {
            if (DataHandlingUtils.declareAndSet((DataDeclaration)dataObject, sc, ctx)) continue;
            BPMRuntimeLogger.log(Level.SEVERE, BPMNProcessBlock.class.toString(), "__initScope", "Failed to declare dataObject " + dataObject.getName() + " in scope " + sc.getScopeId() + " with type " + dataObject.getType().getText());
        }
    }

    public static boolean declareAndSet(DataDeclaration dataDeclaration, IScope sc, ICubeContext ctx) throws CubeException {
        DataDeclarationBpmnDecorator dataDeclarationBpmnDecorator = new DataDeclarationBpmnDecorator(dataDeclaration);
        DataElementVariable dataElementVariable = DataElementVariable.create(dataDeclarationBpmnDecorator);
        if (dataDeclarationBpmnDecorator.isInitialized()) {
            HashMap<String, URI> map = new HashMap<String, URI>();
            dataElementVariable.initValue(new BPMNNamespaceContext(map), DataHandlingUtils.getSchemaManager(ctx));
        }
        sc.declareAndSet(dataElementVariable.getDataDeclaration().getName(), dataElementVariable.getStructure());
        return true;
    }

    public static void declareAndSetInstanceAttribute(InstanceAttributeType instanceAttributeType, String flowElementName, String instanceAttributeName, IScope scope, ICubeContext ctx, Object value) throws CubeException {
        scope.declareAndSet(InstanceAttributeType.getVariableName(instanceAttributeType, flowElementName, instanceAttributeName), value);
    }

    public static <T> T getInstanceAttributeValue(InstanceAttributeType instanceAttributeType, String flowElementName, String instanceAttributeName, IScope scope, ICubeContext ctx) throws CubeException {
        return (T)scope.getObject(InstanceAttributeType.getVariableName(instanceAttributeType, flowElementName, instanceAttributeName));
    }

    public static <T> void setInstanceAttributeValue(InstanceAttributeType instanceAttributeType, String flowElementName, String instanceAttributeName, IScope scope, ICubeContext ctx, T value) throws CubeException {
        scope.set(InstanceAttributeType.getVariableName(instanceAttributeType, flowElementName, instanceAttributeName), value);
    }

    public static boolean containsInstanceAttributeValue(InstanceAttributeType instanceAttributeType, String flowElementName, String instanceAttributeName, IScope scope, ICubeContext ctx) throws CubeException {
        return scope.contains(InstanceAttributeType.getVariableName(instanceAttributeType, flowElementName, instanceAttributeName));
    }

    public static Object getVariableValue(String variableName, IScope scope) throws CubeException {
        return DataHandlingUtils.getVariableValue(scope.getObject(variableName));
    }

    public static Object getVariableValue(Object variable) {
        Object result;
        if (variable instanceof CXTypeVariable) {
            result = ((CXTypeVariable)variable).getValue();
        } else if (variable instanceof CXElementVariable) {
            result = ((CXElementVariable)variable).getValue();
        } else {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public static void setVariableValue(String variableName, IScope scope, Object value) throws CubeException {
        DataHandlingUtils.setVariableValue(scope.getObject(variableName), value);
    }

    public static void setVariableValue(Object variable, Object value) {
        if (variable instanceof CXTypeVariable) {
            ((CXTypeVariable)variable).setValue((Object)DOMUtil.getTextValue((Node)((Node)value)));
        } else if (variable instanceof CXElementVariable) {
            ((CXElementVariable)variable).setValue((Element)value);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static XMLElement generateXMLElement(QName typeQName, QName rootQName, ICubeContext ctx) throws CubeException {
        SchemaManager schemaManager = DataHandlingUtils.getSchemaManager(ctx);
        XMLElement result = SchemaToXML.generateXMLElementForType(null, (int)-1, (QName)rootQName, (QName)typeQName, null, (boolean)false, (NamespaceContext)new SimpleNamespaceContext(), (SchemaManager)schemaManager);
        return result;
    }

    public static SchemaManager getSchemaManager(ICubeContext ctx) {
        return CubeContextHelper.getScaComponent((ICubeContext)ctx).getComposite().getWSDLManager().getSchemaManager();
    }

    public static Map<String, Object> processInputDataForServiceActivities(FlowNode flowNode, Map<String, String> partNamesMap, DataAssociationSet inputDataAssociationSet, IScope sc, ICubeContext ctx, IWorkItem workItem, QName messageType) throws CubeException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, DataElementVariable> data = DataHandlingUtils.processInputData(flowNode, inputDataAssociationSet, sc, ctx, workItem);
        Sequence dataDeclarationSequence = inputDataAssociationSet.getArguments();
        for (DataDeclaration dataDeclaration : dataDeclarationSequence) {
            Object value;
            String partName = partNamesMap.get(dataDeclaration.getName());
            DataElementVariable dataElementVariable = data.get(dataDeclaration.getName());
            if (dataElementVariable.getValue() == null) {
                dataElementVariable.initValue(new BPMNNamespaceContext(Collections.<String, URI>emptyMap()), DataHandlingUtils.getSchemaManager(ctx));
            }
            if ((value = dataElementVariable.getValue()) instanceof XMLElement && dataElementVariable instanceof CXTypeDataElementVariable) {
                XMLElement xmlElement = (XMLElement)value;
                xmlElement.setTagName("", partName);
            }
            result.put(partName, value);
        }
        return result;
    }

    public static Map<String, DataElementVariable> processInputData(FlowNode flowNode, DataAssociationSet inputDataAssociationSet, IScope sc, ICubeContext ctx, IWorkItem workItem) throws CubeException {
        return DataHandlingUtils.processInputData(flowNode, inputDataAssociationSet, sc, ctx, workItem, new HashMap<String, Object>());
    }

    public static Map<String, DataElementVariable> processInputData(FlowNode flowNode, DataAssociationSet inputDataAssociationSet, IScope sc, ICubeContext ctx, IWorkItem workItem, Map<String, Object> initialValues) throws CubeException {
        Sequence dataTransformations;
        DataHandlingLogger.debug(workItem, flowNode, (Object)"Start processing inputDataAssociationSet...");
        Map<String, DataElementVariable> dataInputVariables = DataHandlingUtils.createDataElementVariables(inputDataAssociationSet, initialValues, ctx);
        Sequence dataAssociations = inputDataAssociationSet.getDataAssociations();
        if (dataAssociations != null && !dataAssociations.isEmpty()) {
            HashMap schemaComponents = new HashMap();
            for (DataAssociation dataAssociation : dataAssociations) {
                if (DataHandlingLogger.isDebugPriority()) {
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Start processing dataAssociation " + DataHandlingMsg.INFO_DATAASSOCIATION(dataAssociation).getString()));
                }
                DataAssociationItem sourceDataAssociationItem = dataAssociation.getSource();
                BPMNExpressionMetadata sourceBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)sourceDataAssociationItem.getRefs(), sourceDataAssociationItem.getExpression().getExpressionValue(), BPMNExpressionLanguage.XPATH, sourceDataAssociationItem.getExpression().getNamespaces());
                BPMNExpression sourceBPMNExpression = BPMNExpression.createBPMNExpression(flowNode, sourceBpmnExpressionMetadata, sc);
                DataAssociationItem targetDataAssociationItem = dataAssociation.getTarget();
                BPMNExpressionMetadata targetBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAINPUTS_CONTEXT, (Sequence<String>)targetDataAssociationItem.getRefs(), targetDataAssociationItem.getExpression().getExpressionValue(), BPMNExpressionLanguage.XPATH, targetDataAssociationItem.getExpression().getNamespaces());
                BPMNExpression targetBPMNExpression = BPMNExpression.createBPMNExpression(targetBpmnExpressionMetadata, dataInputVariables, flowNode);
                targetBPMNExpression.setOnDemandInit();
                targetBPMNExpression.getDirectives().put("variable-schema-components", schemaComponents);
                if (DataHandlingLogger.isDebugPriority()) {
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Source BPMN expression=" + DataHandlingMsg.INFO_BPMNEXPRESSION(sourceBPMNExpression).getString()));
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Source DataElements=" + DataHandlingMsg.dumpDataElements(sourceBPMNExpression.getDataElementVariables())));
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Target BPMN expression=" + DataHandlingMsg.INFO_BPMNEXPRESSION(targetBPMNExpression).getString()));
                }
                DataHandlingUtils.performCopy(sc, ctx, workItem, sourceBPMNExpression, targetBPMNExpression);
                if (!DataHandlingLogger.isDebugPriority()) continue;
                DataHandlingLogger.debug(workItem, flowNode, (Object)("Target DataElements=" + DataHandlingMsg.dumpDataElements(targetBPMNExpression.getDataElementVariables())));
            }
        }
        if ((dataTransformations = inputDataAssociationSet.getDataTransformations()) != null) {
            for (DataTransformation dataTransformation : dataTransformations) {
                BPMNExpressionMetadata sourceBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)dataTransformation.getSourceRefs(), dataTransformation.getTransformationName(), BPMNExpressionLanguage.XPATH, null);
                BPMNExpression sourceBPMNExpression = BPMNExpression.createBPMNExpression(flowNode, sourceBpmnExpressionMetadata, sc);
                ArrayList<String> targetRefs = new ArrayList<String>();
                targetRefs.add(dataTransformation.getTargetRef());
                BPMNExpressionMetadata targetBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAINPUTS_CONTEXT, (Sequence<String>)CollectionUtils.asSequence(targetRefs), null, BPMNExpressionLanguage.XPATH, null);
                BPMNExpression targetBPMNExpression = BPMNExpression.createBPMNExpression(targetBpmnExpressionMetadata, dataInputVariables, flowNode);
                DataHandlingUtils.performTransformation(flowNode, sc, ctx, workItem, sourceBPMNExpression, targetBPMNExpression, dataTransformation);
            }
        }
        DataHandlingLogger.debug(workItem, flowNode, (Object)"Finished processing inputDataAssociationSet.");
        return dataInputVariables;
    }

    public static void processOutputDataForServiceActivities(FlowNode flowNode, Map<String, String> partNamesMap, DataAssociationSet outputDataAssociationSet, IScope sc, ICubeContext ctx, Map<String, Object> payload, IWorkItem workItem, boolean inbound) throws CubeException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        Sequence dataDeclarationSequence = outputDataAssociationSet.getArguments();
        for (DataDeclaration dataDeclaration : dataDeclarationSequence) {
            String partName = partNamesMap.get(dataDeclaration.getName());
            data.put(dataDeclaration.getName(), payload.get(partName));
        }
        DataHandlingUtils.processOutputData(flowNode, outputDataAssociationSet, sc, ctx, data, workItem);
    }

    public static void processOutputData(FlowNode flowNode, DataAssociationSet outputDataAssociationSet, IScope sc, ICubeContext ctx, Map<String, Object> data, IWorkItem workItem) throws CubeException {
        Sequence dataTransformations;
        DataHandlingLogger.debug(workItem, flowNode, (Object)"Start processing outputDataAssociationSet...");
        Map<String, DataElementVariable> dataOutputVariables = DataHandlingUtils.createDataElementVariables(outputDataAssociationSet, data, ctx);
        Sequence outputDataAssociations = outputDataAssociationSet.getDataAssociations();
        if (outputDataAssociations != null && !outputDataAssociations.isEmpty()) {
            HashMap schemaComponents = new HashMap();
            for (DataAssociation dataAssociation : outputDataAssociations) {
                if (DataHandlingLogger.isDebugPriority()) {
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Start processing dataAssociation " + DataHandlingMsg.INFO_DATAASSOCIATION(dataAssociation).getString()));
                }
                DataAssociationItem sourceDataAssociationItem = dataAssociation.getSource();
                BPMNExpressionMetadata sourceBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOUTPUTS_CONTEXT, (Sequence<String>)sourceDataAssociationItem.getRefs(), BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)sourceDataAssociationItem.getOtherRefs(), sourceDataAssociationItem.getExpression().getExpressionValue(), BPMNExpressionLanguage.XPATH, sourceDataAssociationItem.getExpression().getNamespaces());
                Sequence dataObjectRefs = sourceDataAssociationItem.getOtherRefs();
                HashMap<String, DataElementVariable> dataObjectVariables = new HashMap<String, DataElementVariable>();
                BPMNExpression.fillDataElementVariablesFromDataObjectRefs(flowNode, sc, dataObjectVariables, (Sequence<String>)dataObjectRefs);
                BPMNExpression sourceBPMNExpression = BPMNExpression.createBPMNExpression(sourceBpmnExpressionMetadata, dataOutputVariables, dataObjectVariables, flowNode);
                DataAssociationItem targetDataAssociationItem = dataAssociation.getTarget();
                BPMNExpressionMetadata targetBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)targetDataAssociationItem.getRefs(), BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)sourceDataAssociationItem.getOtherRefs(), targetDataAssociationItem.getExpression().getExpressionValue(), BPMNExpressionLanguage.XPATH, targetDataAssociationItem.getExpression().getNamespaces());
                BPMNExpression targetBPMNExpression = BPMNExpression.createBPMNExpression(flowNode, targetBpmnExpressionMetadata, sc);
                targetBPMNExpression.setOnDemandInit();
                targetBPMNExpression.getDirectives().put("variable-schema-components", schemaComponents);
                if (DataHandlingLogger.isDebugPriority()) {
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Source BPMN expression=" + DataHandlingMsg.INFO_BPMNEXPRESSION(sourceBPMNExpression).getString()));
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Source DataElements=" + DataHandlingMsg.dumpDataElements(sourceBPMNExpression.getDataElementVariables())));
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Source External DataElements=" + DataHandlingMsg.dumpDataElements(sourceBPMNExpression.getExternalDataElementVariables())));
                    DataHandlingLogger.debug(workItem, flowNode, (Object)("Target BPMN expression=" + DataHandlingMsg.INFO_BPMNEXPRESSION(targetBPMNExpression).getString()));
                }
                DataHandlingUtils.performCopy(sc, ctx, workItem, sourceBPMNExpression, targetBPMNExpression);
                if (!DataHandlingLogger.isDebugPriority()) continue;
                DataHandlingLogger.debug(workItem, flowNode, (Object)("Target DataElements=" + DataHandlingMsg.dumpDataElements(targetBPMNExpression.getDataElementVariables())));
            }
        }
        if ((dataTransformations = outputDataAssociationSet.getDataTransformations()) != null) {
            for (DataTransformation dataTransformation : dataTransformations) {
                BPMNExpressionMetadata sourceBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)dataTransformation.getSourceRefs(), dataTransformation.getTransformationName(), BPMNExpressionLanguage.XPATH, null);
                BPMNExpression sourceBPMNExpression = BPMNExpression.createBPMNExpression(flowNode, sourceBpmnExpressionMetadata, sc);
                if (!dataOutputVariables.isEmpty()) {
                    sourceBPMNExpression = BPMNExpression.createBPMNExpression(sourceBpmnExpressionMetadata, dataOutputVariables, sourceBPMNExpression.getDataElementVariables(), flowNode);
                }
                ArrayList<String> targetRefs = new ArrayList<String>();
                targetRefs.add(dataTransformation.getTargetRef());
                BPMNExpressionMetadata targetBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)CollectionUtils.asSequence(targetRefs), null, BPMNExpressionLanguage.XPATH, null);
                BPMNExpression targetBPMNExpression = BPMNExpression.createBPMNExpression(flowNode, targetBpmnExpressionMetadata, sc);
                DataHandlingUtils.performTransformation(flowNode, sc, ctx, workItem, sourceBPMNExpression, targetBPMNExpression, dataTransformation);
            }
        }
    }

    public static DataObject getDataObject(FlowNode flowNode, String dataObjectId) {
        DataObject dataObject = null;
        for (Subprocess currentSubprocess = flowNode.getSubprocess(); currentSubprocess != null && (dataObject = currentSubprocess.findDataObject(dataObjectId)) == null; currentSubprocess = currentSubprocess.getSubprocess()) {
        }
        if (dataObject == null) {
            dataObject = flowNode.getProcess().findDataObject(dataObjectId);
        }
        if (dataObject == null) {
            dataObject = flowNode.getProcess().getProject().findDataObject(dataObjectId);
        }
        return dataObject;
    }

    public static Sequence<DataObject> getDataObjectsInScope(FlowNode flowNode) {
        HashMap<String, DataObject> dataObjectsScope = new HashMap<String, DataObject>();
        for (Subprocess currentSubprocess = flowNode.getSubprocess(); currentSubprocess != null; currentSubprocess = currentSubprocess.getSubprocess()) {
            DataHandlingUtils.addDataObjectsInContext((DataElementScope)currentSubprocess, dataObjectsScope);
        }
        DataHandlingUtils.addDataObjectsInContext((DataElementScope)flowNode.getProcess(), dataObjectsScope);
        DataHandlingUtils.addDataObjectsInContext((DataElementScope)flowNode.getProject().getProjectModel(), dataObjectsScope);
        return CollectionUtils.asSequence(dataObjectsScope.values());
    }

    public static void addDataObjectsInContext(DataElementScope dataElementScope, Map<String, DataObject> dataObjectsInContext) {
        Sequence dataObjects = dataElementScope.getDataObjects();
        for (DataObject dataObject : dataObjects) {
            if (dataObjectsInContext.containsKey(dataObject.getName())) continue;
            dataObjectsInContext.put(dataObject.getName(), dataObject);
        }
    }

    public static void handleIoSpecificationImports(DataAssociationSet dataAssociationSet, BPMNCubeMapBuilderContext context) throws CubeException {
        Sequence dataDeclarationSequence = dataAssociationSet.getArguments();
        if (dataDeclarationSequence != null) {
            for (DataDeclaration dataDeclaration : dataDeclarationSequence) {
                try {
                    DataHandlingUtils.handleImport(dataDeclaration, context);
                }
                catch (Exception e) {
                    throw new CubeException((Throwable)e);
                }
            }
        }
    }

    public static void handleImport(DataDeclaration dataDeclaration, BPMNCubeMapBuilderContext context) throws Exception {
        URI resourceLocation;
        DataDeclarationBpmnDecorator dataDeclarationBpmnDecorator;
        ComponentModel componentModel = context.getComponentModel();
        if (componentModel != null && !(dataDeclarationBpmnDecorator = new DataDeclarationBpmnDecorator(dataDeclaration)).isNativeStructure() && (resourceLocation = dataDeclarationBpmnDecorator.getResourceLocation()) != null) {
            String resolvedLocation = componentModel.getComposite().getMetadataManager().resolve(resourceLocation.toString());
            DataDeclarationBpmnDecorator.LocationType resourceLocationType = dataDeclarationBpmnDecorator.getResourceLocationType();
            if (resourceLocationType == DataDeclarationBpmnDecorator.LocationType.WSDL) {
                componentModel.getComposite().getWSDLManager().loadWSDL(resolvedLocation);
            } else if (resourceLocationType == DataDeclarationBpmnDecorator.LocationType.XSD) {
                componentModel.getComposite().getSchemaManager().addXSDLoc(resolvedLocation);
            }
        }
    }

    public static Object evalSourceValue(BPMNExpression sourceBPMNExpression, boolean expectSingleNode, IScope sc, ICubeContext ctx, IWorkItem workItem) throws CubeException {
        return sourceBPMNExpression.evaluateSingleNode(sc, ctx);
    }

    public static Object copyObjHelper(Object sourceValue, Object toValue, ICubeContext ctx) throws CubeException {
        Object value;
        Attr oldXsiTypeAttr = null;
        if (toValue instanceof Element) {
            oldXsiTypeAttr = ((Element)toValue).getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        }
        if ((value = DOMUtil.copyObjHelper((Object)sourceValue, (Object)toValue, (boolean)false, (ICubeContext)ctx)) instanceof Element) {
            Element element = (Element)value;
            element.removeAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (oldXsiTypeAttr != null) {
                element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type", oldXsiTypeAttr.getTextContent());
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performTransformation(FlowNode flowNode, IScope sc, ICubeContext ctx, IWorkItem workItem, BPMNExpression sourceBPMNExpression, BPMNExpression targetBPMNExpression, DataTransformation dataTransformation) throws CubeException {
        Map<String, DataElementVariable> dataElementVariableMap = sourceBPMNExpression.getDataElementVariables();
        Iterator<Map.Entry<String, DataElementVariable>> it = dataElementVariableMap.entrySet().iterator();
        Object var = null;
        HashMap<String, Node> paramMap = null;
        Iterator sourceNamesIt = dataTransformation.getSourceRefs().iterator();
        String primarySource = "";
        if (sourceNamesIt.hasNext()) {
            primarySource = (String)sourceNamesIt.next();
        }
        if (primarySource == null || primarySource.equals("")) {
            throw new CubeException((Throwable)new IllegalArgumentException("Transformation source not specified"));
        }
        Node sourceNode = null;
        String varName = "";
        while (it.hasNext()) {
            Map.Entry<String, DataElementVariable> pairs = it.next();
            varName = pairs.getKey();
            Node paramNode = (Node)pairs.getValue().getValue();
            if (paramMap == null) {
                paramMap = new HashMap<String, Node>();
            }
            if (!varName.equals(primarySource)) {
                BPMRuntimeLogger.log(Level.FINEST, DataHandlingUtils.class.toString(), "performTransformation", "Found transformation parameter: " + varName);
                paramMap.put(varName, paramNode);
                continue;
            }
            BPMRuntimeLogger.log(Level.FINEST, DataHandlingUtils.class.toString(), "performTransformation", "Found transformation source: " + varName);
            sourceNode = paramNode;
        }
        String targetDataElement = (String)targetBPMNExpression.getBpmnExpressionMetadata().getDataElements().iterator().next();
        targetBPMNExpression.getBpmnExpressionMetadata().setExpression(targetDataElement);
        DataElementVariable targetDataElementVariable = targetBPMNExpression.getDataElementVariables().get(targetDataElement);
        if (targetDataElementVariable.isUndefined()) {
            targetDataElementVariable.initValue(new BPMNNamespaceContext(targetBPMNExpression.getBpmnExpressionMetadata().getMetadataContextElement()), DataHandlingUtils.getSchemaManager(ctx));
        }
        Node resultNode = (Node)targetDataElementVariable.getValue();
        try {
            Transformer transformer = dataTransformation.getTransformer();
            DocumentBuilder db = dataTransformation.getDocumentBuilder();
            if (transformer == null) {
                transformer = DataHandlingUtils.getTransformer(ctx, dataTransformation);
                dataTransformation.setTransformer(transformer);
            }
            if (db == null) {
                db = XSLMapper.getDocumentBuilder();
                dataTransformation.setDocumentBuilder(db);
            }
            Node transformedNode = null;
            Transformer transformer2 = transformer;
            synchronized (transformer2) {
                transformedNode = XSLMapper.transform(sourceNode, paramMap, transformer, db);
            }
            Document targetDocument = resultNode.getOwnerDocument();
            transformedNode = targetDocument.importNode(((Document)transformedNode).getDocumentElement(), true);
            targetDocument.replaceChild(transformedNode, resultNode);
            targetDataElementVariable.setValue(targetDocument.getDocumentElement());
        }
        catch (Exception ex) {
            if (ex instanceof CubeException) {
                throw (CubeException)((Object)ex);
            }
            Object[] args = new String[]{"xsl/" + dataTransformation.getTransformationName() + ".xsl", primarySource};
            throw new CubeException(75003, args, (Throwable)ex);
        }
    }

    private static Transformer getTransformer(ICubeContext ctx, DataTransformation dataTransformation) throws Exception {
        String filename = "xsl/" + dataTransformation.getTransformationName() + ".xsl";
        InputStream in = null;
        ComponentModel componentModel = CubeContextHelper.getScaComponent((ICubeContext)ctx);
        in = componentModel.getComposite().getMetadataManager().getDocumentAsInputStream(filename);
        return XSLMapper.getTransformer(in);
    }

    private static Map<String, DataElementVariable> createDataElementVariables(DataAssociationSet dataAssociationSet, Map<String, Object> initialValues, ICubeContext cubeContext) {
        HashMap<String, DataElementVariable> dataElementVariables = new HashMap<String, DataElementVariable>();
        Sequence dataDeclarationSequence = dataAssociationSet.getArguments();
        for (DataDeclaration dataDeclaration : dataDeclarationSequence) {
            DataElementVariable dataElementVariable = DataElementVariable.create(dataDeclaration);
            Object value = initialValues.get(dataDeclaration.getName());
            if (value != null) {
                dataElementVariable.setValue(value);
            }
            dataElementVariables.put(dataDeclaration.getName(), dataElementVariable);
        }
        return dataElementVariables;
    }

    private static void performCopy(IScope sc, ICubeContext ctx, IWorkItem workItem, BPMNExpression sourceBPMNExpression, BPMNExpression targetBPMNExpression) throws CubeException {
        Object sourceValue = sourceBPMNExpression.evaluateObject(sc, ctx);
        sourceValue = BPMNWMPHelper.attemptSafeConversionDoubleToLong(sourceValue);
        String targetDataElement = (String)targetBPMNExpression.getBpmnExpressionMetadata().getDataElements().iterator().next();
        DataElementVariable targetDataElementVariable = targetBPMNExpression.getDataElementVariables().get(targetDataElement);
        if (targetDataElementVariable.isUndefined()) {
            targetDataElementVariable.initValue(new BPMNNamespaceContext(targetBPMNExpression.getBpmnExpressionMetadata().getMetadataContextElement()), DataHandlingUtils.getSchemaManager(ctx));
        }
        if (targetDataElementVariable.isNativeStructure()) {
            if (sourceValue instanceof Element) {
                sourceValue = DOMUtil.getTextValue((Node)((Element)sourceValue));
            } else if (sourceValue instanceof Attr) {
                sourceValue = ((Attr)sourceValue).getNodeValue();
            }
            if (sourceValue != null) {
                Object value;
                DataHandlingLogger.debug(workItem, "performCopy", (Object)"Assigning...");
                try {
                    value = BPMNWMPHelper.adjustFromDataValue(sourceValue, (CXTypeVariable)targetDataElementVariable.getStructure());
                }
                catch (Exception e) {
                    throw new XPathException(77003, new Object[]{sourceValue, targetDataElementVariable.getDataDeclaration().getName(), ((CXTypeDataElementVariable)targetDataElementVariable).getStructure().getType()});
                }
                Element element = (Element)targetDataElementVariable.getValue();
                String data = String.valueOf(value);
                element.setTextContent(data);
                if (DataHandlingLogger.isDebugPriority()) {
                    DataHandlingLogger.debug(workItem, "performCopy", (Object)("Value= " + DataHandlingMsg.dumpDataElementValue(data)));
                }
            }
        } else {
            Object variableValue = targetDataElementVariable.getValue();
            BPMNWMPHelper.patchSchemaComponentsForCubeDOMNavigator(variableValue, targetBPMNExpression, ctx);
            Object toValue = targetBPMNExpression.evaluateObject(sc, ctx);
            if (toValue instanceof Node) {
                boolean replace;
                boolean bl = replace = variableValue == toValue;
                if (DataHandlingLogger.isDebugPriority()) {
                    DataHandlingLogger.debug(workItem, "performCopy", (Object)"Copying...");
                    DataHandlingLogger.debug(workItem, "performCopy", (Object)("Source value= " + DataHandlingMsg.dumpDataElementValue(sourceValue)));
                    DataHandlingLogger.debug(workItem, "performCopy", (Object)("Target value= " + DataHandlingMsg.dumpDataElementValue(toValue)));
                }
                Object value = DOMUtil.copyObjHelper((Object)sourceValue, (Object)toValue, (boolean)false, (ICubeContext)ctx);
                if (DataHandlingLogger.isDebugPriority()) {
                    DataHandlingLogger.debug(workItem, "performCopy", (Object)("Result Value= " + DataHandlingMsg.dumpDataElementValue(value)));
                }
                if (replace) {
                    targetDataElementVariable.setValue(value);
                }
            }
        }
    }

    static class BPMNWMPHelper
    extends BPELWMPHelper {
        BPMNWMPHelper() {
        }

        public static Object adjustFromValue(Object fromValue, CXTypeVariable toTypeVar) {
            Object value = fromValue;
            XMLSchemaTypeManager typeMgr = XMLSchemaTypeManager.getInstance();
            if (typeMgr.isSchemaType(toTypeVar.getType())) {
                if (typeMgr.isByte(toTypeVar.getType().getLocalPart())) {
                    value = new Byte(BPMNWMPHelper.convertFromValueToDouble(fromValue).byteValue());
                } else if (typeMgr.isShort(toTypeVar.getType().getLocalPart())) {
                    value = new Short(BPMNWMPHelper.convertFromValueToDouble(fromValue).shortValue());
                } else if (BPMNWMPHelper.isJavaIntegerType(toTypeVar.getType().getLocalPart())) {
                    value = new Integer(BPMNWMPHelper.convertFromValueToDouble(fromValue).intValue());
                } else if (BPMNWMPHelper.isJavaLongType(toTypeVar.getType().getLocalPart())) {
                    value = new Long(BPMNWMPHelper.convertFromValueToDouble(fromValue).longValue());
                } else if (typeMgr.isFloat(toTypeVar.getType().getLocalPart())) {
                    value = new Float(BPMNWMPHelper.convertFromValueToDouble(fromValue).floatValue());
                } else if (typeMgr.isString(toTypeVar.getType().getLocalPart())) {
                    value = value instanceof XMLElement ? ((XMLElement)value).getTextContent() : String.valueOf(fromValue);
                }
            }
            return value;
        }

        public static Object convertFromValueToLong(Object fromValue) {
            if (fromValue instanceof Double && (Double)fromValue == (double)((Double)fromValue).longValue()) {
                return ((Double)fromValue).longValue();
            }
            return fromValue;
        }

        static Object adjustFromDataValue(Object fromValue, CXTypeVariable toTypeVar) {
            return BPMNWMPHelper.adjustFromValue(fromValue, toTypeVar);
        }

        static void patchSchemaComponentsForCubeDOMNavigator(Object value, BPMNExpression bpmnExpression, ICubeContext iCubeContext) {
            XMLElement xmlElement;
            Attr xsiTypeAttr;
            if (value instanceof XMLElement && (xsiTypeAttr = (xmlElement = (XMLElement)value).getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type")) != null) {
                SchemaManager schemaManager = DataHandlingUtils.getSchemaManager(iCubeContext);
                QName typeQName = BPMNWMPHelper.getXsiType(xmlElement);
                try {
                    XSDNode xsdNode = schemaManager.lookupXSDTypeDefinition(typeQName);
                    Map schemaComponents = (Map)bpmnExpression.getDirectives().get("variable-schema-components");
                    schemaComponents.put(new QName(xmlElement.getNamespaceURI(), xmlElement.getLocalName()), xsdNode);
                }
                catch (XSDException e) {
                    CubeEngineLogger.debug((Object)((Object)e));
                }
            }
        }

        static QName getXsiType(XMLElement xmlElement) {
            QName typeQName = null;
            Attr attr = xmlElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (attr != null) {
                String xsiTypeValue = attr.getValue();
                int index = xsiTypeValue.indexOf(58);
                String prefix = index > 0 ? xsiTypeValue.substring(0, index) : "";
                String namespace = xmlElement.resolveNamespacePrefix(prefix);
                String type = xsiTypeValue.substring(index + 1);
                typeQName = new QName(namespace, type, prefix);
            }
            return typeQName;
        }

        static Object attemptSafeConversionDoubleToLong(Object fromValue) {
            return BPMNWMPHelper.convertFromValueToLong(fromValue);
        }

        private static Double convertFromValueToDouble(Object fromValue) {
            Double result = fromValue instanceof Double ? (Double)fromValue : (fromValue instanceof String ? Double.valueOf(Double.parseDouble((String)fromValue)) : (fromValue instanceof XMLElement ? Double.valueOf(Double.parseDouble(((XMLElement)fromValue).getTextContent())) : Double.valueOf(Double.parseDouble(String.valueOf(fromValue)))));
            return result;
        }

        private static boolean isJavaIntegerType(String typeLocalPart) {
            XMLSchemaTypeManager typeMgr = XMLSchemaTypeManager.getInstance();
            return typeMgr.isInt(typeLocalPart) || typeMgr.isUnsignedShort(typeLocalPart) || typeMgr.isUnsignedByte(typeLocalPart);
        }

        private static boolean isJavaLongType(String typeLocalPart) {
            XMLSchemaTypeManager typeMgr = XMLSchemaTypeManager.getInstance();
            return typeMgr.isLong(typeLocalPart) || typeMgr.isInteger(typeLocalPart) || typeMgr.isUnsignedInt(typeLocalPart) || typeMgr.isNonPositiveInteger(typeLocalPart) || typeMgr.isNegativeInteger(typeLocalPart) || typeMgr.isNonNegativeInteger(typeLocalPart) || typeMgr.isPositiveInteger(typeLocalPart);
        }
    }

    public static class DataHandlingLogger
    extends BPELExecutionLogger {
        public static void debug(IWorkItem workItem, FlowNode flowNode, Object message) {
            DataHandlingLogger.debug(workItem, flowNode, message, null);
        }

        public static void debug(IWorkItem workItem, FlowNode flowNode, Object message, Throwable throwable) {
            DataHandlingLogger.debug(workItem, flowNode, null, message, throwable);
        }

        public static void debug(IWorkItem workItem, String method, Object message) {
            DataHandlingLogger.debug(workItem, null, method, message, null);
        }

        public static void debug(IWorkItem workItem, String method, Object message, Throwable throwable) {
            DataHandlingLogger.debug(workItem, null, method, message, throwable);
        }

        private static void debug(IWorkItem workItem, FlowNode flowNode, String method, Object message, Throwable throwable) {
            DataHandlingLogger.debug((String)DataHandlingMsg.INFO_BPMNSUBJECT(workItem).getString(), (String)(flowNode != null ? DataHandlingMsg.INFO_BPMNMETHOD(flowNode).getString() : method), (Object)message, (Throwable)throwable);
        }

        private static boolean isDebugPriority() {
            return BPELExecutionLogger.isDebugPriority((Logger)DataHandlingLogger.getLogger());
        }
    }
}

