/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.util;

import com.collaxa.cube.engine.core.ICubeInstance;
import com.collaxa.cube.engine.core.ICubeProcess;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.xml.dom.DOMUtil;
import java.util.Map;
import java.util.Set;
import oracle.bpm.bpmn.engine.model.runtime.util.BpmnEngineMsg;
import oracle.bpm.bpmn.engine.runtime.BPMNExpression;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionMetadata;
import oracle.bpm.bpmn.engine.runtime.DataElementVariable;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.resources.Msg;
import org.w3c.dom.Node;

public class DataHandlingMsg {
    public static Msg INFO_BPMNEXPRESSION(BPMNExpression bpmnExpression) {
        BPMNExpressionMetadata metadata = bpmnExpression.getBpmnExpressionMetadata();
        return BpmnEngineMsg.INFO_BPMNEXPRESSION(metadata.getExpression(), metadata.getMetadataContextElement());
    }

    public static Msg INFO_BPMNMETHOD(FlowNode flowNode) {
        return BpmnEngineMsg.INFO_BPMNMETHOD(flowNode.getName(), flowNode.getBpmnType().getLabel().getString());
    }

    public static Msg INFO_BPMNSUBJECT(ICubeProcess iCubeProcess, ICubeInstance iCubeInstance) {
        return iCubeInstance == null ? BpmnEngineMsg.INFO_BPMNSUBJECT_PROCESS(iCubeProcess.getProcessDN()) : BpmnEngineMsg.INFO_BPMNSUBJECT_PROCESSINSTANCE(iCubeProcess.getProcessDN(), iCubeInstance.getId());
    }

    public static Msg INFO_BPMNSUBJECT(ICubeProcess iCubeProcess) {
        return DataHandlingMsg.INFO_BPMNSUBJECT(iCubeProcess, null);
    }

    public static Msg INFO_BPMNSUBJECT(IWorkItem iWorkItem) {
        return DataHandlingMsg.INFO_BPMNSUBJECT(iWorkItem.getCubeInstance().getProcessClass(), iWorkItem.getCubeInstance());
    }

    public static String dumpDataElementValue(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        DataHandlingMsg.dumpDataElementValue(stringBuilder, object);
        return stringBuilder.toString();
    }

    public static String dumpDataElementValue(StringBuilder stringBuilder, Object object) {
        if (object instanceof Node) {
            stringBuilder.append('\n');
            stringBuilder.append(DOMUtil.toXML((Node)((Node)object)));
        } else {
            stringBuilder.append(object);
        }
        return stringBuilder.toString();
    }

    public static String dumpDataElement(StringBuilder stringBuilder, String name, DataElementVariable dataElementVariable) {
        stringBuilder.append('\n');
        stringBuilder.append(name).append('=');
        Object value = dataElementVariable.getValue();
        stringBuilder.append(DataHandlingMsg.dumpDataElementValue(value));
        return stringBuilder.toString();
    }

    public static String dumpDataElements(Map<String, DataElementVariable> map) {
        StringBuilder stringBuilder = new StringBuilder();
        if (map != null) {
            Set<Map.Entry<String, DataElementVariable>> entries = map.entrySet();
            for (Map.Entry<String, DataElementVariable> entry : entries) {
                DataHandlingMsg.dumpDataElement(stringBuilder, entry.getKey(), entry.getValue());
            }
        }
        return stringBuilder.toString();
    }

    public static Msg INFO_DATAASSOCIATION(DataAssociation dataAssociation) {
        return BpmnEngineMsg.INFO_BPMNDATAASSOCIATION(dataAssociation.getSource().getExpression().getExpressionValue(), dataAssociation.getTarget().getExpression().getExpressionValue());
    }
}

