/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.util;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.EngineException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.audit.IAuditTrail;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeInstance;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.util.ThreadCountManager;
import com.collaxa.cube.lang.compiler.bpel.BPELDefs;
import com.oracle.bpel.client.BPELFault;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.runtimeconfig.model.PayloadMappingType;
import oracle.bpel.services.workflow.task.impl.TaskUtil;
import oracle.bpel.services.workflow.task.impl.WorkflowUtil;
import oracle.bpel.services.workflow.task.model.ScaType;
import oracle.bpel.services.workflow.task.model.SystemMessageAttributesType;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpm.bpmn.engine.instancemanagement.ejb.IInternalInstanceManagementServiceLocal;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.SequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNPayloadMappingCache;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.runtime.DeploymentDescriptorUtil;
import oracle.bpm.bpmn.engine.runtime.features.SequenceFlowToEndActivityFearure;
import oracle.bpm.bpmn.engine.service.BPMNInstanceObserver;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.services.activityguide.IBpmAGMetadataService;
import oracle.bpm.services.activityguide.model.metadata.IActivityGuide;
import oracle.bpm.services.common.BPMServiceLocator;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancemanagement.model.IIdentityType;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.bpm.services.instancemanagement.model.IProcessSystemAttributes;
import oracle.bpm.services.instancemanagement.model.impl.IdentityType;
import oracle.bpm.services.instancemanagement.model.impl.ProcessFlexAttributes;
import oracle.bpm.services.instancemanagement.model.impl.ProcessInstance;
import oracle.bpm.services.organization.model.ApplicationContextTypeEnum;
import oracle.bpm.services.organization.model.ApplicationRoleType;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.fabric.CubeFabricUtil;
import oracle.fabric.common.BusinessFaultException;
import oracle.fabric.common.FabricInvocationException;
import oracle.fabric.common.PolicyEnforcementException;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.PropertyModel;
import oracle.soa.management.ComponentDN;
import oracle.soa.management.config.bpmn.BPMNConfig;
import oracle.tip.pc.services.identity.config.BPMConfigException;
import oracle.tip.pc.services.identity.config.ISConfiguration;
import oracle.xml.jaxb.JaxbDatatypeConverter;
import org.w3c.dom.Element;

public class BPMNUtility {
    private static final String BPM_RPOCESS_INSTANCES_CONTEXT_KEY = "bpminstancescontextkey";
    private static final String BPM_PROCESS_OWNER_ROLE_SUFFIX = "SYS.PROCESS.OWNER.ROLE";

    public static void insertInstance2Track(BPMNCubeElement node, IWorkItem item, ICubeContext context, boolean close) throws Exception {
        boolean isEndEvent;
        ComponentModel component;
        if (BPMNUtility.isInstanceTrackingNotRequired(node.getFlowElement())) {
            return;
        }
        boolean isAGInstance = BPMNUtility.isAGRootProcess(item.getComponentDN());
        if (!isAGInstance && BPMNUtility.isProcessTrackingDisabled(component = CubeContextHelper.getScaComponent((ICubeContext)context))) {
            return;
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)"Start of inserting bpmn instance");
        IScope scope = item.getScope();
        HashMap map = item.getNodeActivationContext();
        int thread = BPMNTokenMetadataUtils.getThreadFromTokenMetadata(map);
        int parentThread = BPMNTokenMetadataUtils.getParentThreadFromTokenMetadata(map);
        boolean bl = isEndEvent = node.getFlowElement().getBpmnType() == BpmnType.END_EVENT;
        if (isEndEvent) {
            int currentThreadNumber = ThreadCountManager.getThreadCount((IScope)scope);
            if (currentThreadNumber > 1) {
                if (thread == 0) {
                    close = false;
                }
            } else {
                thread = 0;
                parentThread = -1;
            }
        }
        IProcessInstance instance = BPMNUtility.getProcessInstance(node, item, scope, context, thread, parentThread, isAGInstance);
        if (close) {
            instance.getSystemAttributes().setState("COMPLETED");
        } else {
            instance.getSystemAttributes().setState("OPEN");
        }
        BPMNUtility.addProcessInstanceInContext(instance, context, isEndEvent);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)"End of inserting bpmn instance");
    }

    public static void persistProcessInstances(ICubeContext ctx) throws Exception {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"persistProcessInstances", (String)"Start of persisting instances");
        List<IProcessInstance> instances = BPMNUtility.getProcessInstances(ctx);
        IInternalInstanceManagementServiceLocal local = BPMNUtility.getInternalManagementservice(ctx);
        IBPMContext bpmcontext = (IBPMContext)BPMNUtility.getInternalWorkflowContext();
        int size = instances.size();
        for (int i = 0; i < size; ++i) {
            IProcessInstance instance = instances.get(i);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"persistProcessInstances", (String)("Persisting instance id = " + instance.getSystemAttributes().getProcessInstanceId()));
            local.insertUpdateInstance(bpmcontext, instance);
        }
        instances = null;
        ctx.removeFromEnvironment(BPM_RPOCESS_INSTANCES_CONTEXT_KEY);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"persistProcessInstances", (String)"Start of persisting instances");
    }

    public static Object[] getObjects(ICubeInstance instance, FlowNode node) {
        String processName = instance.getComponentName();
        String revision = instance.getCompositeRevision();
        String labelName = node.getDefaultLabel();
        Object[] obj = new Object[]{processName, revision, labelName};
        return obj;
    }

    public static String getLabel(FlowNode node) {
        return node.getDefaultLabel() + "[" + node.getId() + "]";
    }

    public static boolean isSequenceFlowGoesToEnd(SequenceFlowInfo flow, FlowNode node) {
        String flowId = flow.getId();
        SequenceFlowToEndActivityFearure feature = (SequenceFlowToEndActivityFearure)node.getFeature(SequenceFlowToEndActivityFearure.class);
        if (feature != null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"isSequenceFlowGoesToEnd", (String)("Check sequence flow with id " + flowId + " of node " + BPMNUtility.getLabel(node) + " goes to end "));
            List infos = feature.getValue();
            for (SequenceFlowToEndActivityFearure.EndActivityFlowInfo info : infos) {
                if (!info.getSequenceFlow().getId().equals(flowId)) continue;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"isSequenceFlowGoesToEnd", (String)("Sequence flow id  " + flowId + " of node " + BPMNUtility.getLabel(node) + " goes to end "));
                return true;
            }
        }
        return false;
    }

    public static IInternalInstanceManagementServiceLocal getInternalManagementservice(ICubeContext ctx) throws Exception {
        IInternalInstanceManagementServiceLocal local = (IInternalInstanceManagementServiceLocal)ctx.getFromEnvironment("internalManagementService");
        if (local == null) {
            InitialContext jContext = new InitialContext();
            local = (IInternalInstanceManagementServiceLocal)jContext.lookup("java:comp/env/oracle/bpm/engine/InternalInstanceManagementService");
            ctx.addToEnvironment("internalManagementService", (Object)local);
        }
        return local;
    }

    public static void persistAuditData(ICubeContext ctx) throws Exception {
        ICubeInstanceImpl cubeInstance = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        IAuditTrail auditTrail = cubeInstance.getAuditTrail();
        BPMNUtility.getInternalManagementservice(ctx).persistAuditData(auditTrail);
    }

    public static void throwBPELFault(Exception exc, String className, String methodName) throws CubeException {
        if (exc instanceof BusinessFaultException) {
            BusinessFaultException e = (BusinessFaultException)exc;
            BPELExecutionLogger.debug((String)className, (String)methodName, (Object)"got BusinessFaultException", (Throwable)e);
            BPELFault fault = new BPELFault(QName.valueOf(e.getFaultName()), (Throwable)e);
            if (e.getFaultMessage() != null) {
                fault.setParts(e.getFaultMessage().getPayload());
                fault.setMessageType(e.getFaultMessage().getMessageType());
            }
            throw fault;
        }
        if (exc instanceof FabricInvocationException) {
            FabricInvocationException fie = (FabricInvocationException)exc;
            if (fie.getCause() == null) {
                BPELExecutionLogger.debug((String)className, (String)methodName, (Object)"got FabricInvocationException", (Throwable)fie);
            } else {
                BPELExecutionLogger.debug((String)"UserTaskWMP", (String)methodName, (Object)"got FabricInvocationException", (Throwable)fie);
            }
            if (FabricInvocationException.RetryType.ROLLBACK_ONLY == fie.getRetryType()) {
                throw new EngineException(2180);
            }
            if (FabricInvocationException.RetryType.GLOBAL_RETRY == fie.getRetryType()) {
                throw new EngineException(2198);
            }
            BPELFault fault = FabricInvocationException.RetryType.NO_RETRY == fie.getRetryType() ? new BPELFault(BPELDefs.QN_BINDING_FAULT) : new BPELFault(BPELDefs.QN_REMOTE_FAULT);
            String summary = fie.getSummary() == null ? String.valueOf(fie) : fie.getSummary();
            String detail = fie.getDetail() == null ? CubeFabricUtil.getRootCause((Throwable)fie).getMessage() : fie.getDetail();
            fault.setPart("code", (Object)fie.getCode());
            fault.setPart("summary", (Object)summary);
            fault.setPart("detail", (Object)detail);
            throw fault;
        }
        if (exc instanceof PolicyEnforcementException) {
            PolicyEnforcementException pe = (PolicyEnforcementException)exc;
            BPELExecutionLogger.error((String)className, (String)methodName, (Object)"got PolicyEnforcementException", (Throwable)pe);
            BPELFault fault = new BPELFault(BPELDefs.QN_OWSM_POLICY_FAULT, (Throwable)pe);
            fault.setMessageType(BPELDefs.QN_BPELX_OWSM_POLICY_FAULT_MESSAGE);
            fault.setPart("code", (Object)pe.getErrorCode());
            fault.setPart("summary", (Object)pe.getMessage());
            fault.setPart("detail", (Object)pe.getDetail());
            throw fault;
        }
        if (exc instanceof BPELFault) {
            BPELFault f = (BPELFault)exc;
            BPELExecutionLogger.debug((String)className, (String)methodName, (Object)"got BPELFault", (Throwable)f);
            throw f;
        }
        if (exc instanceof RuntimeException) {
            RuntimeException re = (RuntimeException)exc;
            BPELExecutionLogger.debug((String)className, (String)methodName, (Object)"got RuntimeException", (Throwable)re);
            if (re.getCause() instanceof BusinessFaultException) {
                BusinessFaultException e = (BusinessFaultException)re.getCause();
                BPELFault fault = new BPELFault(QName.valueOf(e.getFaultName()));
                fault.setParts(e.getFaultMessage().getPayload());
                throw fault;
            }
            BPELFault fault = new BPELFault(BPELDefs.QN_REMOTE_FAULT);
            String summary = String.valueOf(re);
            String detail = CubeFabricUtil.getRootCause((Throwable)re).getMessage();
            fault.setPart("summary", (Object)summary);
            fault.setPart("detail", (Object)detail);
            throw fault;
        }
        BPELExecutionLogger.debug((String)className, (String)methodName, (Object)"got Throwable", (Throwable)exc);
        BPELFault fault = new BPELFault(BPELDefs.QN_REMOTE_FAULT, (Throwable)exc);
        String summary = String.valueOf(exc);
        String detail = CubeFabricUtil.getRootCause((Throwable)exc).getMessage();
        fault.setPart("summary", (Object)summary);
        fault.setPart("detail", (Object)detail);
        throw fault;
    }

    private static IProcessInstance getProcessInstance(BPMNCubeElement node, IWorkItem item, IScope scope, ICubeContext context, int thread, int parentThread, boolean isAGInstance) throws Exception {
        Role role;
        Object element = node.getFlowElement();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)"Creating instance using cube instance");
        String activityId = element.getId();
        String activityName = element.getDefaultLabel();
        HashMap map = item.getNodeActivationContext();
        int step = BPMNTokenMetadataUtils.getStepFromTokenMetadata(map);
        ICubeInstance cubeinstance = item.getCubeInstance();
        long instanceId = cubeinstance.getId();
        String title = cubeinstance.getTitle();
        Date createdDate = cubeinstance.getCreationDate();
        String creator = cubeinstance.getCreator();
        String appContext = null;
        IdentityType assigneeType = null;
        IdentityType ownerType = null;
        Lane lane = null;
        if (element != null) {
            lane = element.getLane();
        }
        if (lane != null && (role = BPMNUtility.getRole(element.getLane())) != null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)("Role name is " + role.getId()));
            String compositeDN = cubeinstance.getComponentDN().getCompositeDN();
            List<Participant> participants = DeploymentDescriptorUtil.getParticipantsForProcessRole(compositeDN, role.getId(), null);
            if (participants != null && participants.size() > 0) {
                assigneeType = new IdentityType();
                Participant participant = participants.get(0);
                PrincipleRefType pType = (PrincipleRefType)participant.getValue();
                appContext = pType.getApplicationContext();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)("Application context is " + appContext));
                String name = pType.getName();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)("App role name is " + name));
                assigneeType.setId(name);
                if (pType.getType().equals((Object)ParticipantTypeEnum.GROUP)) {
                    assigneeType.setType("group");
                } else if (pType.getType().equals((Object)ParticipantTypeEnum.APPROLE)) {
                    assigneeType.setType("application_role");
                }
            }
        }
        ComponentDN compDN = cubeinstance.getComponentDN();
        String processOwnerRole = compDN.getCompositeName() + "." + "ProcessOwner";
        if (BPMNUtility.checkIfProcessRoleExists(compDN.getCompositeDN(), BPM_PROCESS_OWNER_ROLE_SUFFIX)) {
            String compositeLevelAppRole = compDN.getCompositeName() + "." + BPM_PROCESS_OWNER_ROLE_SUFFIX;
            ownerType = new IdentityType();
            ownerType.setId(compositeLevelAppRole);
            ownerType.setType("application_role");
        } else if (BPMNUtility.checkIfProcessRoleExists(compDN.getCompositeDN(), compDN.getComponentName() + "." + BPM_PROCESS_OWNER_ROLE_SUFFIX)) {
            String processLevelAppRole = compDN.getCompositeName() + "." + compDN.getComponentName() + "." + BPM_PROCESS_OWNER_ROLE_SUFFIX;
            ownerType = new IdentityType();
            ownerType.setId(processLevelAppRole);
            ownerType.setType("application_role");
        } else if (BPMNUtility.checkIfProcessRoleExists(compDN.getCompositeDN(), processOwnerRole)) {
            ownerType = new IdentityType();
            ownerType.setId(processOwnerRole);
            ownerType.setType("application_role");
        }
        if (assigneeType == null && ownerType != null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)"Use process owner as assignee ");
            assigneeType = ownerType;
        }
        if (assigneeType == null && ownerType == null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)"Use BPM admin as assignee and owner");
            ownerType = new IdentityType();
            ownerType.setId("BPMProcessAdmin");
            ownerType.setType("application_role");
            assigneeType = ownerType;
        }
        if (appContext == null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)"Application context is null. Use hard coded application context");
            appContext = ApplicationContextTypeEnum.ORACLE_BPM_PROCESS_ROLES_APP.value();
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)("Information is   Step = " + step + " thread = " + thread + " parent thread " + parentThread + " instance id " + instanceId));
        ProcessInstance instance = new ProcessInstance();
        if (title != null) {
            instance.setTitle(title);
        }
        instance.setCubeInstanceId(String.valueOf(instanceId));
        IProcessSystemAttributes sysAttributes = instance.getSystemAttributes();
        if (createdDate != null) {
            Calendar createdCal = Calendar.getInstance();
            createdCal.setTime(createdDate);
            sysAttributes.setCreatedDate(createdCal);
        }
        if (creator != null) {
            instance.setCreator(creator);
        }
        sysAttributes.setThread(thread);
        sysAttributes.setParentThread(parentThread);
        sysAttributes.setComponentType("BPMN");
        sysAttributes.setActivityId(activityId);
        sysAttributes.setActivityName(activityName);
        sysAttributes.setIsGroup(true);
        ComponentDN dn = cubeinstance.getComponentDN();
        ScaType sca = instance.getSca();
        sca.setComponentName(dn.getComponentName());
        sca.setCompositeDN(dn.getCompositeDN());
        sca.setCompositeVersion(dn.getRevision());
        sca.setEcId(cubeinstance.getECID());
        sca.setCompositeInstanceId(cubeinstance.getCompositeInstanceId());
        String componentDN = dn.toString();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)("Component DN " + componentDN + "  composite DN " + dn.getCompositeDN() + "  component Name " + dn.getComponentName()));
        instance.setProcessDN(componentDN);
        if (ownerType != null) {
            instance.setOwner(ownerType.getId(), IIdentityType.IDENTITY_TYPE.ROLE);
        }
        if (appContext != null) {
            instance.setApplicationContext(appContext);
        }
        sysAttributes.addAssignee((IIdentityType)assigneeType);
        if (isAGInstance) {
            sysAttributes.setActivityGuideRootId(instanceId);
        }
        String id = BPMNUtility.getId((IProcessInstance)instance);
        Task taskObject = instance.getTask();
        taskObject.getSystemAttributes().setTaskId(id);
        if (WorkflowUtil.isNull((String)instance.getIdentityContext())) {
            try {
                instance.setIdentityContext(ISConfiguration.getDefaultRealmName());
            }
            catch (BPMConfigException exc) {
                instance.setIdentityContext("jazn.com");
            }
        }
        BPMNUtility.promoteProjectDataObjectToInstance((IProcessInstance)instance, element, scope);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"insertInstance2Track", (String)"End of Creating instance using cube instance");
        return instance;
    }

    private static void promoteProjectDataObjectToInstance(IProcessInstance instance, FlowNode node, IScope scope) throws Exception {
        if (node == null) {
            return;
        }
        ScaType sca = instance.getSca();
        String dn = sca.getCompositeDN() + "/" + sca.getComponentName();
        Project project = node.getProject();
        Collection dataObjects = project.getProjectDataObjects();
        if (dataObjects.size() > 0) {
            List<PayloadMappingType> mappings = BPMNPayloadMappingCache.getPayloadMappings(dn);
            for (PayloadMappingType mapping : mappings) {
                String variableName = mapping.getPayloadAttribute();
                String attribute = mapping.getLabel().getTaskAttribute();
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"promoteProjectDataObjectToInstance", (String)("Variable name from mapping = " + variableName + " with flex attribute is " + attribute));
                ProjectDataObject dataObject = project.findDataObject(variableName);
                if (dataObject != null) {
                    Object object = DataHandlingUtils.getVariableValue(variableName, scope);
                    if (object != null) {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"promoteProjectDataObjectToInstance", (String)("Value for data object " + variableName + " is " + object));
                        CatalogType type = dataObject.getType();
                        Object convertedObject = null;
                        if (type.isString()) {
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"promoteProjectDataObjectToInstance", (String)("Converting value  " + object + " to string"));
                            convertedObject = object instanceof Element ? ((Element)object).getTextContent() : object.toString();
                        } else if (type.isNumber() || type.isDecimal() || type.isInt()) {
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"promoteProjectDataObjectToInstance", (String)("Converting value  " + object + " to Double"));
                            convertedObject = Double.parseDouble(object instanceof Element ? ((Element)object).getTextContent() : object.toString());
                        } else if (type.isTime()) {
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"promoteProjectDataObjectToInstance", (String)("Converting value  " + object + " to Date"));
                            convertedObject = JaxbDatatypeConverter.parseDateTime((String)(object instanceof Element ? ((Element)object).getTextContent() : object.toString()));
                        } else if (type.isBoolean()) {
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"promoteProjectDataObjectToInstance", (String)("Converting boolean value  " + object + " to String"));
                            convertedObject = object instanceof Element ? ((Element)object).getTextContent() : object.toString();
                        } else {
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.WARNING, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"promoteProjectDataObjectToInstance", (String)("Not supported type " + type.getName()));
                        }
                        if (convertedObject == null) continue;
                        SystemMessageAttributesType sysType = ((ProcessFlexAttributes)instance.getFlexAttributes()).getSystemMessageAttributesType();
                        TaskUtil.setSystemMessageAttribute((SystemMessageAttributesType)sysType, (String)attribute, (Object)convertedObject);
                        continue;
                    }
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"promoteProjectDataObjectToInstance", (String)("Value is null for data object " + variableName));
                    continue;
                }
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"promoteProjectDataObjectToInstance", (String)("Warning project data object doesn't exist for " + variableName));
            }
        }
    }

    private static void addProcessInstanceInContext(IProcessInstance currentInstance, ICubeContext ctx, boolean isEndEvent) {
        IProcessSystemAttributes mAttr;
        List<IProcessInstance> instances = BPMNUtility.getProcessInstances(ctx);
        int size = instances.size();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"addProcessInstanceInContext", (String)("Start of process instance in list of size =  " + size));
        IProcessSystemAttributes currentAttributes = currentInstance.getSystemAttributes();
        String currentId = currentAttributes.getProcessInstanceId();
        String currentState = currentAttributes.getState();
        boolean canRemoveChildOpenInstance = false;
        if (currentState.equals("OPEN") || isEndEvent && currentState.equals("COMPLETED")) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"addProcessInstanceInContext", (String)"Setting flag to to true for removing open child instances from the list ");
            canRemoveChildOpenInstance = true;
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"addProcessInstanceInContext", (String)("Adding instance id=  " + currentId));
        IProcessInstance mainInstance = null;
        int currentThread = currentAttributes.getThread();
        boolean includesChildOpenInstances = false;
        if (currentThread == 0) {
            mainInstance = currentInstance;
        } else if (currentState.equals("OPEN")) {
            includesChildOpenInstances = true;
        }
        for (int i = 0; i < instances.size(); ++i) {
            IProcessInstance pInstance = instances.get(i);
            IProcessSystemAttributes pAttr = pInstance.getSystemAttributes();
            String pState = pAttr.getState();
            String pTaskId = pInstance.getSystemAttributes().getProcessInstanceId();
            if (pInstance.getSystemAttributes().getProcessInstanceId().equals(currentId)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"addProcessInstanceInContext", (String)("ID is already exist just copy over =  " + currentId));
                if (pState.equals("COMPLETED") && currentState.equals("OPEN") && BPMNUtility.isAssigneesDifferent(currentAttributes, pAttr)) {
                    currentInstance.setRemoveAssignees(pAttr.getAssignees());
                }
                instances.remove(pInstance);
                continue;
            }
            if (pAttr.getThread() != 0 && canRemoveChildOpenInstance && pState.equals("OPEN")) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"addProcessInstanceInContext", (String)("Removing the instance of type from the list " + pAttr.getActivityName()));
                int pParentThread = pInstance.getSystemAttributes().getParentThread();
                if (pParentThread == currentAttributes.getThread()) {
                    instances.remove(pInstance);
                    continue;
                }
            }
            if (pAttr.getThread() == 0) {
                mainInstance = pInstance;
                continue;
            }
            if (includesChildOpenInstances || pAttr.getThread() == 0 || !pAttr.getState().equals("OPEN")) continue;
            includesChildOpenInstances = true;
        }
        if (mainInstance != null && includesChildOpenInstances && mainInstance.getSystemAttributes().getState().equals("COMPLETED") && (mAttr = mainInstance.getSystemAttributes()).getState().equals("COMPLETED")) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.INFORMATION, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"addProcessInstanceInContext", (String)"Changing the state of close of main task to open as it includes some open child");
            mAttr.setState("OPEN");
            mAttr.clearAssignees();
        }
        instances.add(currentInstance);
    }

    private static boolean isAssigneesDifferent(IProcessSystemAttributes open, IProcessSystemAttributes close) {
        List openAssignees = open.getAssignees();
        List closeAssignees = close.getAssignees();
        if (openAssignees.size() != closeAssignees.size()) {
            return true;
        }
        for (int i = 0; i < openAssignees.size(); ++i) {
            IIdentityType type = (IIdentityType)openAssignees.get(i);
            boolean exist = false;
            for (int j = 0; j < closeAssignees.size(); ++j) {
                IIdentityType type1 = (IIdentityType)closeAssignees.get(j);
                if (!type.getId().equals(type1.getId())) continue;
                exist = true;
            }
            if (exist) continue;
            return true;
        }
        return false;
    }

    private static List<IProcessInstance> getProcessInstances(ICubeContext ctx) {
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"getProcessInstances", (String)"Start of getting instances from context");
        ArrayList<IProcessInstance> instances = (ArrayList<IProcessInstance>)ctx.getFromEnvironment(BPM_RPOCESS_INSTANCES_CONTEXT_KEY);
        if (instances == null) {
            instances = new ArrayList<IProcessInstance>();
            ctx.addToEnvironment(BPM_RPOCESS_INSTANCES_CONTEXT_KEY, instances);
            BPMNInstanceObserver.addBPMNObserver(ctx);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"getProcessInstances", (String)("End of getting instances from context size = " + instances.size()));
        return instances;
    }

    private static boolean checkIfProcessRoleExists(String compositeDN, String processRole) throws Exception {
        oracle.bpm.services.organization.model.Organization organization = DeploymentDescriptorUtil.getBPMOrganization(compositeDN);
        List roles = organization.getApplicationRoles().getApplicationRole();
        for (ApplicationRoleType role : roles) {
            String name = role.getName();
            if (!processRole.equals(name)) continue;
            return true;
        }
        return false;
    }

    private static IWorkflowContext getInternalWorkflowContext() throws WorkflowException {
        try {
            IWorkflowContext wfCtx = (IWorkflowContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return VerificationService.createInternalWorkflowContext();
                }
            });
            return wfCtx;
        }
        catch (PrivilegedActionException pae) {
            Exception orgEx = pae.getException();
            if (orgEx instanceof WorkflowException) {
                throw (WorkflowException)((Object)orgEx);
            }
            throw new WorkflowException((Throwable)pae);
        }
    }

    private static boolean isAGRootProcess(ComponentDN dn) throws Exception {
        String processId = dn.getComponentName();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"isAGRooProcess", (String)("Start of isAGRootProcess for " + processId));
        boolean isAgRootProcess = false;
        IBpmAGMetadataService service = BPMServiceLocator.getBpmAGMetadataService();
        IActivityGuide activityGuide = service.getAGDefinition(dn.getCompositeDN());
        if (activityGuide != null) {
            String agRootprocessId = activityGuide.getRootProcessId();
            isAgRootProcess = agRootprocessId.equals(processId);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)"bpmn.engine.model.runtime.util.BPMNUtility", (String)"isAGRooProcess", (String)("End of isAGRootProcess = " + isAgRootProcess));
        return isAgRootProcess;
    }

    private static String getId(IProcessInstance instance) {
        String cubeInstanceId = instance.getCubeInstanceId();
        int thread = instance.getSystemAttributes().getThread();
        int parentThread = instance.getSystemAttributes().getParentThread();
        String taskId = cubeInstanceId;
        if (thread > 0 || parentThread > 0) {
            taskId = taskId + "-" + thread;
            taskId = taskId + "-" + parentThread;
        }
        return taskId;
    }

    private static boolean isProcessTrackingDisabled(ComponentModel compModel) {
        String flag;
        PropertyModel flagProperty = compModel.getProperty("disableProcessTracking");
        if (flagProperty != null && (flag = flagProperty.getValue()) != null) {
            return flag.equals("true");
        }
        BPMNServiceEngine engine = BPMNServiceEngine.getInstance();
        BPMNConfig config = engine.getBPMNConfig();
        return config.getDisableProcessTracking();
    }

    public static Role getRole(Lane lane) {
        Organization organization;
        Project p;
        Role role = null;
        if (lane != null && (p = lane.getProject()) != null && (organization = p.getOrganization()) != null) {
            role = organization.findRoleById(lane.getId());
        }
        return role;
    }

    private static boolean isInstanceTrackingNotRequired(FlowNode node) {
        BpmnType type = node.getBpmnType();
        return type.equals((Object)BpmnType.SERVICE_TASK) || type.equals((Object)BpmnType.SCRIPT_TASK) || type.equals((Object)BpmnType.BUSINESS_RULE_TASK) || type.equals((Object)BpmnType.CALL_ACTIVITY) || type.equals((Object)BpmnType.MANUAL_TASK) || type.equals((Object)BpmnType.SEND_TASK);
    }
}

