/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.util;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.util.TokenManager;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMRuntimeLogger;
import oracle.soa.common.collections.Queue;

public final class BPMNTokenManager {
    public static String getNodeScopeKey(IScope scope, String nodeId, String suffix) {
        return scope.getAbsoluteScopeId() + "." + nodeId + "." + suffix;
    }

    public static HashMap<String, Object> consumeOpenToken(IScope scope, ICubeContext context, String nodeId) throws CubeException {
        String activationIdsOfRemovedToken;
        Queue tokens = BPMNTokenManager.getTokenObject(scope, nodeId);
        BPMRuntimeLogger.log(Level.ALL, "BPMNTokenManager", "canActivate", "Token object = " + tokens);
        Object o = tokens.remove();
        HashMap<String, Object> removedToken = BPMNTokenMetadataUtils.convertToToken(o);
        if (tokens.size() == 0) {
            TokenManager.consumeOpenToken((IScope)scope, (String)nodeId);
        }
        if ((activationIdsOfRemovedToken = BPMNTokenMetadataUtils.getActivationIdsFromTokenMetadata(removedToken)) == null || activationIdsOfRemovedToken.equals(Boolean.TRUE)) {
            activationIdsOfRemovedToken = "";
        }
        BPMRuntimeLogger.logSystemOut("Removed token is == " + removedToken);
        if (!activationIdsOfRemovedToken.equals("")) {
            BPMRuntimeLogger.logSystemOut("Removed token " + removedToken);
            context.addToEnvironment(BPMNTokenManager.getNodeScopeKey(scope, nodeId, "++node-activation-ids"), (Object)activationIdsOfRemovedToken);
        }
        return removedToken;
    }

    public static HashMap<String, Object> generateOpenToken(IScope scope, BPMNCubeElement sourceNode, String targetId, String activationIds, int parentThread, int thread, int step, Map<String, Object> metadata) throws CubeException {
        HashMap<String, Object> tokenMetadata = new HashMap<String, Object>();
        if (metadata != null) {
            tokenMetadata.putAll(metadata);
        }
        tokenMetadata.put("ACTIVATION_IDS", activationIds);
        tokenMetadata.put("PARENT_THREAD", parentThread);
        tokenMetadata.put("THREAD", thread);
        tokenMetadata.put("STEP", step);
        if (sourceNode.getFlowElement() != null) {
            tokenMetadata.put("SOURCE_ACTIVITY_ID", sourceNode.getFlowElement().getId());
        }
        TokenManager.generateOpenToken((IScope)scope, (String)targetId, tokenMetadata);
        return tokenMetadata;
    }

    @Deprecated
    public static HashMap<String, Object> generateOpenToken(IScope scope, BPMNCubeElement sourceNode, String targetId, String activationIds, int parentThread, int thread, int step) throws CubeException {
        return BPMNTokenManager.generateOpenToken(scope, sourceNode, targetId, activationIds, parentThread, thread, step, new HashMap<String, Object>());
    }

    public static HashMap<String, Object> generateOpenToken(IScope scope, BPMNCubeElement sourceNode, String targetId, HashMap<String, Object> metadata) throws CubeException {
        HashMap<String, Object> tokenMetadata = new HashMap<String, Object>();
        if (metadata != null) {
            tokenMetadata.putAll(metadata);
        }
        if (sourceNode != null && sourceNode.getFlowElement() != null) {
            tokenMetadata.put("SOURCE_ACTIVITY_ID", sourceNode.getFlowElement().getId());
        }
        TokenManager.generateOpenToken((IScope)scope, (String)targetId, tokenMetadata);
        return tokenMetadata;
    }

    public static Queue fetchOpenToken(IScope scope, String targetId) throws CubeException {
        return (Queue)TokenManager.fetchOpenToken((IScope)scope, (String)targetId);
    }

    public static Queue getTokenObject(IScope scope, String mapElementId) throws CubeException {
        return (Queue)scope.getTokenObject(scope.getAbsoluteScopeId(), mapElementId);
    }
}

