/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.token;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.bpmn.engine.model.runtime.token.GatewayToken;

public class BPMNToken
implements Serializable {
    private boolean active = false;
    private String activtyId = null;
    private List<GatewayToken> gatewayTokens = new ArrayList<GatewayToken>();
    private String seqFlowId = null;

    public BPMNToken(String activtyId, boolean active, String seqFlowId) {
        this(activtyId, active, seqFlowId, null);
    }

    public BPMNToken(String activtyId, boolean active, String seqFlowId, List<GatewayToken> tokens) {
        this.activtyId = activtyId;
        this.active = active;
        this.seqFlowId = seqFlowId;
        if (tokens != null) {
            this.gatewayTokens.addAll(tokens);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getActivtyId() {
        return this.activtyId;
    }

    public void addGateway(GatewayToken token) {
        if (token != null) {
            this.gatewayTokens.add(token);
        }
    }

    public void addGateways(List<GatewayToken> token) {
        if (token != null) {
            this.gatewayTokens.addAll(token);
        }
    }

    public List<GatewayToken> getGatewayTokens() {
        return this.gatewayTokens;
    }

    public String getSeqFlowId() {
        return this.seqFlowId;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.activtyId).append("-").append(this.active).append("[");
        for (int i = 0; i < this.gatewayTokens.size(); ++i) {
            buffer.append(this.gatewayTokens.get(i)).append(",");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

