/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.sequenceflow;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import oracle.bpm.bpmn.engine.model.runtime.scripting.SequenceFlowConditionEvaluator;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.SequenceFlowInfo;
import oracle.bpm.bpmn.engine.runtime.BPMNExpression;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionDataElementContextType;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionLanguage;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionMetadata;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.model.processes.BpmnSequenceFlowType;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.FlowNode;

public class ConditionalSequenceFlowInfo
extends SequenceFlowInfo {
    private int evaluationOrder;
    private String script;
    private String scriptLanguage;

    protected ConditionalSequenceFlowInfo(String id, String sourceActivityId, String targetActivityId, String targetNodeId) {
        super(id, sourceActivityId, targetActivityId, targetNodeId);
    }

    @Override
    public int getEvaluationOrder() {
        return this.evaluationOrder;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public String getScript() {
        return this.script;
    }

    @Override
    public BpmnSequenceFlowType getBpmnSequenceFlowType() {
        return BpmnSequenceFlowType.CONDITIONAL;
    }

    @Override
    protected SequenceFlowConditionEvaluator createConditionEvaluator() {
        return new SequenceFlowConditionEvaluator(){

            @Override
            public boolean evaluate(FlowNode flowNode, IScope scope, ICubeContext ctx, IWorkItem workItem) throws CubeException {
                Expression expression = ((ConditionalFlow)ConditionalSequenceFlowInfo.this.getSequenceFlow()).getCondition();
                BPMNExpressionMetadata bpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, null, expression.getExpressionValue(), BPMNExpressionLanguage.XPATH, expression.getNamespaces());
                BPMNExpression bpmnExpression = BPMNExpression.createBPMNExpression(flowNode, bpmnExpressionMetadata, scope);
                return bpmnExpression.evaluateBoolean(scope, ctx);
            }
        };
    }

    void setEvaluationOrder(int evaluationOrder) {
        this.evaluationOrder = evaluationOrder;
    }

    void setScriptLanguage(String scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }

    void setScript(String script) {
        this.script = script;
    }
}

