/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.scripting;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.types.bpel.CXTypeVariable;
import com.oracle.bpel.client.BPELFault;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.xml.namespace.QName;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.Process;

public class ScriptTaskUtils {
    private static final String JAVA_SCRIPT_EXCEPTION_THROW_ROLLBACK = "JavaScriptException: __ThrowRollback__ ";
    private static final String BPEL_SCHEMA = "http://schemas.oracle.com/bpel/extension";
    private static final String ROLLBACK = "rollback";
    protected static Map<String, ScriptEngine> scriptEngineCache = new HashMap<String, ScriptEngine>();
    public static final String DEFAULT_SCRIPT_LANGUAGE = "JavaScript";

    public static Object evaluate(Map<String, Object> map, String sl, String script) {
        SimpleBindings sb = new SimpleBindings(map);
        ScriptEngine engine = ScriptTaskUtils.getScriptEngine(sl);
        Object obj = null;
        try {
            obj = engine.eval(script, (Bindings)sb);
        }
        catch (ScriptException e) {
            if (Boolean.getBoolean("oracle.bpm.runtime.tests.enabled") && e.getMessage().contains(JAVA_SCRIPT_EXCEPTION_THROW_ROLLBACK)) {
                throw new BPELFault(new QName(BPEL_SCHEMA, ROLLBACK));
            }
            throw new RuntimeException(e);
        }
        return obj;
    }

    public static Object evaluate(Map<String, Object> map, String sl, Reader reader) {
        SimpleBindings sb = new SimpleBindings(map);
        ScriptEngine engine = ScriptTaskUtils.getScriptEngine(sl);
        Object obj = null;
        try {
            obj = engine.eval(reader, (Bindings)sb);
        }
        catch (ScriptException e) {
            if (e.getMessage().contains(JAVA_SCRIPT_EXCEPTION_THROW_ROLLBACK)) {
                throw new BPELFault(new QName(BPEL_SCHEMA, ROLLBACK));
            }
            throw new RuntimeException(e);
        }
        return obj;
    }

    public static Object evaluate(Map<String, Object> map, String scriptLanguage, Object script) {
        Object ret;
        if (script instanceof Reader) {
            Reader reader = (Reader)script;
            ret = ScriptTaskUtils.evaluate(map, scriptLanguage, reader);
        } else if (script instanceof InputStream) {
            ret = ScriptTaskUtils.evaluate(map, scriptLanguage, new BufferedReader(new InputStreamReader((InputStream)script)));
        } else {
            String reader = (String)script;
            ret = ScriptTaskUtils.evaluate(map, scriptLanguage, reader);
        }
        return ret;
    }

    public static String getDefaultScriptLanguage() {
        return DEFAULT_SCRIPT_LANGUAGE;
    }

    public static void bindProcessDataObjects(Process process, IScope iScope, Map<String, Object> bindings) throws CubeException {
        Sequence dataObjects = process.getDataObjects();
        ScriptTaskUtils.bindDataObjects((Sequence<DataObject>)dataObjects, iScope, bindings);
    }

    public static void bindDataObjects(Sequence<DataObject> dataObjects, IScope iScope, Map<String, Object> bindings) throws CubeException {
        for (DataObject dataObject : dataObjects) {
            String objName = dataObject.getName();
            Object obj = iScope.getObject(objName);
            if (obj instanceof CXTypeVariable) {
                Object value = ((CXTypeVariable)obj).getValue();
                if (value == null) {
                    value = "";
                }
                bindings.put(objName, value);
                continue;
            }
            bindings.put(objName, obj);
        }
    }

    public static void unbindProcessDataObjects(Process process, IScope iScope, Map<String, Object> bindings) throws CubeException {
        ScriptTaskUtils.unbindDataObjects((Sequence<DataObject>)process.getDataObjects(), iScope, bindings);
    }

    public static void unbindDataObjects(Sequence<DataObject> dataObjects, IScope iScope, Map<String, Object> bindings) throws CubeException {
        for (DataObject dataObject : dataObjects) {
            Object newObj;
            String objName = dataObject.getName();
            Object obj = iScope.getObject(objName);
            if (!(obj instanceof CXTypeVariable) || (newObj = bindings.get(objName)) instanceof CXTypeVariable) continue;
            ((CXTypeVariable)obj).setValue(newObj);
        }
    }

    private static ScriptEngine getScriptEngine(String sl) {
        return new ScriptEngineManager().getEngineByName(sl);
    }
}

