/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions.md;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.microkernel.MDServiceActivity;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.processes.OperationReference;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;

public abstract class MDServiceActivityBase
implements MDServiceActivity {
    private boolean allowsWrappedArguments;
    private QName faultCodeError;
    private QName faultMessageType;
    private Map<String, String> inputPartNamesMap;
    private QName inputType;
    private boolean isMessage = false;
    private boolean isTwoWay;
    private String operationRefName;
    private Map<String, String> outputPartNamesMap;
    private QName outputType;
    private QName portType;

    protected MDServiceActivityBase(OperationReference operationRef, DataAssociationSet inputDataAssociationSet, DataAssociationSet outputDataAssociationSet) {
        if (operationRef != null) {
            this.isMessage = true;
            this.isTwoWay = operationRef.isTwoWay();
            this.inputType = operationRef.getInputType();
            this.outputType = operationRef.getOutputType();
            this.faultMessageType = operationRef.getFaultMessageType();
            this.faultCodeError = operationRef.getFaultCodeError();
            this.operationRefName = operationRef.getName();
            this.portType = operationRef.getPortType();
            this.allowsWrappedArguments = operationRef.allowsWrappedArguments();
            this.inputPartNamesMap = new HashMap<String, String>();
            this.outputPartNamesMap = new HashMap<String, String>();
            MDServiceActivityBase.fillPartNamesMap(operationRef, inputDataAssociationSet, this.inputPartNamesMap);
            MDServiceActivityBase.fillPartNamesMap(operationRef, outputDataAssociationSet, this.outputPartNamesMap);
        }
    }

    @Override
    public boolean isAllowsWrappedArguments() {
        return this.allowsWrappedArguments;
    }

    @Override
    public boolean isMessage() {
        return this.isMessage;
    }

    @Override
    public boolean isTwoWay() {
        return this.isTwoWay;
    }

    @Override
    public QName getInputType() {
        return this.inputType;
    }

    @Override
    public QName getOutputType() {
        return this.outputType;
    }

    @Override
    public QName getFaultMessageType() {
        return this.faultMessageType;
    }

    @Override
    public QName getFaultCodeError() {
        return this.faultCodeError;
    }

    public String getOperationRefName() {
        return this.operationRefName;
    }

    public QName getPortType() {
        return this.portType;
    }

    public Map<String, String> getInputPartNamesMap() {
        return Collections.unmodifiableMap(this.inputPartNamesMap);
    }

    public Map<String, String> getOutputPartNamesMap() {
        return Collections.unmodifiableMap(this.outputPartNamesMap);
    }

    private static void fillPartNamesMap(OperationReference operationRef, DataAssociationSet dataAssociationSet, Map<String, String> partNamesMap) {
        if (dataAssociationSet != null) {
            Sequence dataDeclarationSequence = dataAssociationSet.getArguments();
            for (DataDeclaration dataDeclaration : dataDeclarationSequence) {
                String partName = operationRef.findArgumentPartName(dataDeclaration.getName());
                if (partNamesMap.containsKey(dataDeclaration.getName())) {
                    throw new RuntimeException("MDServiceActivityBase.fillPartNamesMap duplicated arguments");
                }
                partNamesMap.put(dataDeclaration.getName(), partName);
            }
        }
    }
}

