/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions.md;

import com.collaxa.cube.CubeException;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.bpmn.engine.model.runtime.InstanceAttributeSupport;
import oracle.bpm.bpmn.engine.service.audit.AuditServiceFactory;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryMetadata;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditVariableMetadata;

public class MDAuditLog {
    private AuditInstanceOperation auditInstanceOperation;
    private IAuditVariableMetadata auditVariableMetadata;
    private List<Counter> counters;
    private FlowNode element;
    private boolean isEntryPoint;
    private boolean isInstanceCreated;
    private boolean isInstanceTerminated;
    private boolean isInSubprocess;
    private InstanceAttributeSupport loopCountAttr;
    private InstanceAttributeSupport instanceCountAttr;
    private AuditQueryMetadata mAuditMetadata;
    private String mComponentType;
    private List<Measurement> measurementMarks;
    private String compositeDN;
    private final Object lockObject = new Object();

    public MDAuditLog(String componentType, AuditInstanceOperation operation, boolean isEntryPoint, boolean isInstanceCreated, boolean isInstanceTerminated, InstanceAttributeSupport loopCountAttr, InstanceAttributeSupport instanceCountAttr, boolean isInSubprocess, FlowNode element, String compositeDN) {
        this.mComponentType = componentType;
        this.isEntryPoint = isEntryPoint;
        this.isInstanceCreated = isInstanceCreated;
        this.isInstanceTerminated = isInstanceTerminated;
        this.auditInstanceOperation = operation;
        this.measurementMarks = new ArrayList<Measurement>();
        this.counters = new ArrayList<Counter>();
        this.isInSubprocess = isInSubprocess;
        this.loopCountAttr = loopCountAttr;
        this.instanceCountAttr = instanceCountAttr;
        this.element = element;
        this.compositeDN = compositeDN;
    }

    public boolean isEntryPoint() {
        return this.isEntryPoint;
    }

    public boolean isInstanceCreated() {
        return this.isInstanceCreated;
    }

    public boolean isInstanceTerminated() {
        return this.isInstanceTerminated;
    }

    public AuditInstanceOperation getAuditInstanceOperation() {
        return this.auditInstanceOperation;
    }

    public IAuditVariableMetadata getAuditVariableMetadata() {
        if (this.auditVariableMetadata == null) {
            this.auditVariableMetadata = AuditUtil.createAuditVariableMetadata(this.mAuditMetadata);
        }
        return this.auditVariableMetadata;
    }

    @Deprecated
    public void setAuditVariableMetadata(IAuditVariableMetadata metadata) {
        this.auditVariableMetadata = metadata;
    }

    public void addMeasurementMark(Measurement measurement) {
        this.measurementMarks.add(measurement);
    }

    public boolean hasMeasurementMarks() {
        return this.measurementMarks.size() > 0;
    }

    public void addCounter(Counter counter) {
        this.counters.add(counter);
    }

    public boolean hasCounter() {
        return this.counters.size() > 0;
    }

    public Sequence<Measurement> getMeasurements() {
        return CollectionUtils.asSequence(this.measurementMarks);
    }

    public Sequence<Counter> getCounters() {
        return CollectionUtils.asSequence(this.counters);
    }

    public String getComponentType() {
        return this.mComponentType;
    }

    public void setComponentType(String componentType) {
        this.mComponentType = componentType;
    }

    public FlowNode getFlowElement() {
        return this.element;
    }

    public void setAuditQueryMetadata(AuditQueryMetadata auditMetadata) {
        this.mAuditMetadata = auditMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuditQueryMetadata getAuditQueryMetadata() throws CubeException {
        if (this.mAuditMetadata == null) {
            Object object = this.lockObject;
            synchronized (object) {
                if (this.mAuditMetadata == null) {
                    try {
                        this.mAuditMetadata = AuditServiceFactory.getInstance().getAuditService().getAuditQueryMetadata(this.compositeDN);
                    }
                    catch (Exception exc) {
                        throw new CubeException((Throwable)exc);
                    }
                }
            }
        }
        return this.mAuditMetadata;
    }

    public InstanceAttributeSupport getLoopCountAttr() {
        return this.loopCountAttr;
    }

    public boolean isInSubprocess() {
        return this.isInSubprocess;
    }

    public InstanceAttributeSupport getInstanceCountAttr() {
        return this.instanceCountAttr;
    }
}

