/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.ICubeInstance;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.ICubeProcess;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.delivery.IDeliveryService;
import com.collaxa.cube.engine.delivery.SubscriptionInfo;
import com.collaxa.cube.engine.types.bpel.CXMessageVariable;
import com.collaxa.cube.engine.types.bpel.CXPartnerLink;
import com.collaxa.cube.lang.compiler.bpel.BPELDefs;
import com.oracle.bpel.client.BPELFault;
import com.oracle.bpel.client.CorrelationId;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIUserTaskCallback;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDServiceTask;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.project.model.processes.UserTask;
import oracle.soa.common.util.XMLUtil;
import oracle.soa.management.ComponentDN;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MIUserTaskResponse
extends MIBase<Object> {
    private MDServiceTask mdServiceTask;
    private UserTask userTask = null;
    public static final String TASK_SERVICE_NAMESPACE = "http://xmlns.oracle.com/bpel/workflow/taskService";
    private static final String TASK_SERVICE_CALLBACK_OPERATION = "onTaskCompleted";
    private static final String TASK_SERVICE_CALLBACK_PORTTYPE = "TaskServiceCallback";
    private static final String TASK_NAMESPACE = "http://xmlns.oracle.com/bpel/workflow/task";
    private static final String TASK_PRIORITY_XPATH = "/task:task/task:priority";
    private static final String TASK_PAYLOAD_XPATH = "/task:task/task:payload";
    private static final String TASK_TITLE_XPATH = "/task:task/task:title";
    private static final String TASK_OWNER_USER_XPATH = "/task:task/task:ownerUser";
    private static final String TASK_CREATOR_XPATH = "/task:task/task:creator";
    private static final String TASK_INSTANCEID_XPATH = "/task:task/task:processInfo/task:instanceId";
    private static final String TASK_PROCESSID_XPATH = "/task:task/task:processInfo/task:processId";
    private static final String TASK_ACTIVITYID_XPATH = "/task:task/task:systemAttributes/task:activityId";
    private static final String TASK_THREAD_XPATH = "/task:task/task:systemAttributes/task:thread";
    private static final String TASK_PARENTTHREAD_XPATH = "/task:task/task:systemAttributes/task:parentThread";
    private static final String PAYLOAD_ELEMENT_NAME = "payload";
    private static final String TASK_ELEMENT_NAME = "task";
    private static final String TITLE_ELEMENT_NAME = "title";
    public static final String INITIATETASK_OP = "initiateTask";
    public static final String RE_INITIATETASK_OP = "reinitiateTask";
    public static final String TASKSERVICE_PORTTYPE = "TaskService";
    public static final String TASKSERVICE_INIIATETASKMESSAGE = "initiateTaskMessage";
    public static final String TASKSERVICE_INIIATETASKRESPONSEMESSAGE = "initiateTaskResponseMessage";
    public static final String TASKSERVICE_INITIATE_TASK_RESPONSE = "initiateTaskResponse";
    public static final String TASKSERVICE_INIIATEFAULTMESSAGE = "workflowErrorMessage";
    private static final String[] sTaskElementsXPath = new String[]{"/task:task/task:priority", "/task:task/task:payload", "/task:task/task:title", "/task:task/task:ownerUser", "/task:task/task:creator", "/task:task/task:processInfo/task:instanceId", "/task:task/task:processInfo/task:processId", "/task:task/task:systemAttributes/task:activityId", "/task:task/task:systemAttributes/task:thread", "/task:task/task:systemAttributes/task:parentThread"};

    public MIUserTaskResponse(MDServiceTask mdServiceTask) {
        this.mdServiceTask = mdServiceTask;
        this.userTask = (UserTask)mdServiceTask.getFlowElement();
    }

    @Override
    protected Object doExecute(MicroInstructionContext context) throws Throwable {
        this.handleTaskServiceResponse(context);
        return null;
    }

    private void handleTaskServiceResponse(MicroInstructionContext context) throws Throwable {
        IWorkItem wi = context.getWorkItem();
        IScope sc = wi.getScope();
        ICubeContext ctx = context.getCubeContext();
        ICubeInstanceImpl ci = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        String serviceName = this.userTask.getHumanTask().getText() + ".reference";
        CXPartnerLink partnerLink = (CXPartnerLink)sc.getObject(serviceName);
        String convId = partnerLink.getConversationId();
        CXMessageVariable result = (CXMessageVariable)sc.getObject(this.mdServiceTask.getOutputVariableName());
        if (this.userTask.isManualStart()) {
            this.setTitleofCubeInstance((Map)result, (ICubeInstance)ci);
        }
        if (!wi.isComplete()) {
            if (this.getState((Map)result, (ICubeInstance)ci) != null) {
                this.registerCallback(wi, sc, ctx, convId);
                wi.markAsOpenPendingComplete();
            } else {
                wi.markAsComplete();
                MIUserTaskCallback.processOutputData(context, this.userTask, (Map)result);
                BPMNUtility.insertInstance2Track(context.getNode(), context.getWorkItem(), context.getCubeContext(), true);
            }
        }
        String activationIds = BPMNTokenMetadataUtils.getActivationIdsFromTokenMetadata(wi.getNodeActivationContext());
        sc.declareAndSet(convId + ".activationid", (Object)activationIds);
    }

    private String getState(Map output, ICubeInstance ci) {
        NodeList stateNodes;
        XMLElement task;
        XMLElement systemAttributes;
        XMLElement taskService;
        String state = "";
        if (output != null && (taskService = (XMLElement)output.get(PAYLOAD_ELEMENT_NAME)) != null && (systemAttributes = (XMLElement)(task = (XMLElement)taskService.getElementsByTagNameNS(TASK_NAMESPACE, TASK_ELEMENT_NAME).item(0)).getElementsByTagNameNS(TASK_NAMESPACE, "systemAttributes").item(0)) != null && (stateNodes = systemAttributes.getElementsByTagNameNS(TASK_NAMESPACE, "state")).getLength() > 0) {
            Node stateE = stateNodes.item(0);
            String stateValue = XMLUtil.getNodeValue((Node)stateE);
            if (stateValue == null || stateValue.equals("COMPLETED")) {
                return null;
            }
            return stateValue;
        }
        return state;
    }

    private void setTitleofCubeInstance(Map output, ICubeInstance ci) {
        String titleValue;
        XMLElement task;
        XMLElement title;
        XMLElement taskService;
        if (output != null && (taskService = (XMLElement)output.get(PAYLOAD_ELEMENT_NAME)) != null && (title = (XMLElement)(task = (XMLElement)taskService.getElementsByTagNameNS(TASK_NAMESPACE, TASK_ELEMENT_NAME).item(0)).getElementsByTagNameNS(TASK_NAMESPACE, TITLE_ELEMENT_NAME).item(0)) != null && (titleValue = XMLUtil.getNodeValue((Node)title)) != null && !titleValue.trim().equals("")) {
            ci.setTitle(titleValue);
        }
    }

    private void registerCallback(IWorkItem wi, IScope sc, ICubeContext ctx, String conversationId) throws Exception {
        IDeliveryService ds = (IDeliveryService)ctx.lookup("__delivery-service");
        String partnerName = this.userTask.getHumanTask().getText() + ".reference";
        CXPartnerLink partner = (CXPartnerLink)sc.getObject(partnerName);
        ICubeInstanceImpl ci = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        CorrelationId cId = new CorrelationId(ci.getProcessClass().getProcessDN(), wi.getKey().toString());
        ICubeProcess cp = ci.getProcessClass();
        ComponentDN pid = cp.getProcessDN();
        SubscriptionInfo sbInfo = null;
        wi.setCustomId(conversationId);
        sbInfo = new SubscriptionInfo(conversationId, cId.toString(), pid, partner.getName(), TASK_SERVICE_CALLBACK_OPERATION, null, ci.getKey());
        sbInfo.getProperties().putAll(partner.getProperties());
        sbInfo.setNodeType("bpel");
        sbInfo.setPortTypeName(new QName(TASK_SERVICE_NAMESPACE, TASK_SERVICE_CALLBACK_PORTTYPE));
        sbInfo.setConversationType(partner.getConversationType());
        try {
            ds.subscribe(sbInfo, ctx);
        }
        catch (Exception e) {
            if (e instanceof CubeException && ((CubeException)((Object)e)).getErrorCode() == 3810) {
                BPELFault bf = new BPELFault(BPELDefs.QN_CONFLICTIING_RECEIVE, e.getMessage());
                throw bf;
            }
            throw e;
        }
    }
}

