/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.types.bpel.CXMessageVariable;
import com.collaxa.cube.engine.types.bpel.CXPartnerLink;
import com.collaxa.cube.xml.dom.DOMUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.task.impl.TaskUtil;
import oracle.bpel.services.workflow.task.model.ObjectFactory;
import oracle.bpel.services.workflow.task.model.ProcessType;
import oracle.bpel.services.workflow.task.model.SystemAttributesType;
import oracle.bpel.services.workflow.task.model.TaskImpl;
import oracle.bpm.bpmn.engine.logging.BPMNLoggerManager;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDServiceTask;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.runtime.BPMNExpression;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionDataElementContextType;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionLanguage;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionMetadata;
import oracle.bpm.bpmn.engine.runtime.DataElementVariable;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.type.Argument;
import oracle.fabric.common.wsdl.SchemaManager;
import oracle.fabric.composite.model.ComponentModel;
import oracle.integration.platform.common.NMUtil;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import org.collaxa.thirdparty.jaxen.SimpleNamespaceContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MIUserTaskRequest
extends MIBase<Object> {
    private MDServiceTask mdServiceTask;
    private UserTask userTask = null;
    private Map mElementMap = null;
    private Logger logger = BPMNLoggerManager.getInstance().getLogger(BPELExecutionLogger.class.getName());
    public static final String TASK_SERVICE_NAMESPACE = "http://xmlns.oracle.com/bpel/workflow/taskService";
    public static final String TASK_NAMESPACE = "http://xmlns.oracle.com/bpel/workflow/task";
    private static final String TASK_XML_FRAGMENT = "<task xmlns=\"http://xmlns.oracle.com/bpel/workflow/task\">\n</task>";
    private static final String INITIATE_TASKSERVICE_XML_FRAGMENT = "<initiateTask xmlns=\"http://xmlns.oracle.com/bpel/workflow/taskService\">\n<task xmlns=\"http://xmlns.oracle.com/bpel/workflow/task\">\n</task></initiateTask>";
    private static final String REINITIATE_TASKSERVICE_XML_FRAGMENT = "<reinitiateTask xmlns=\"http://xmlns.oracle.com/bpel/workflow/taskService\">\n<task xmlns=\"http://xmlns.oracle.com/bpel/workflow/task\">\n</task></reinitiateTask>";
    public static final String PAYLOAD_ELEMENT_NAME = "payload";
    public static final String TASK_ELEMENT_NAME = "task";
    private static final String TASKSERVICE_ELEMENT_NAME = "taskService";
    public static final String SYSATTRS_ELEMENT_NAME = "systemAttributes";
    public static final String STATE_ELEMENT_NAME = "state";
    public static final String TASKSERVICE_PORTTYPE = "TaskService";
    public static final String TASKSERVICE_INIIATETASKMESSAGE = "initiateTaskMessage";
    public static final String TASKSERVICE_INIIATETASKRESPONSEMESSAGE = "initiateTaskResponseMessage";
    public static final String TASKSERVICE_INIIATEFAULTMESSAGE = "workflowErrorMessage";
    public static final String INITIATETASK_OP = "initiateTask";
    public static final String RE_INITIATETASK_OP = "reinitiateTask";

    public MIUserTaskRequest(MDServiceTask mdServiceTask, Map map) {
        this.mdServiceTask = mdServiceTask;
        this.userTask = (UserTask)mdServiceTask.getFlowElement();
        this.mElementMap = map;
    }

    @Override
    protected Object doExecute(MicroInstructionContext context) throws Throwable {
        IWorkItem wi = context.getWorkItem();
        IScope sc = wi.getScope();
        ICubeContext ctx = context.getCubeContext();
        ICubeInstanceImpl ci = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        this.handleTaskServiceInvoke(ci, wi, sc, ctx, context);
        return null;
    }

    private void handleTaskServiceInvoke(ICubeInstanceImpl ci, IWorkItem wi, IScope sc, ICubeContext ctx, MicroInstructionContext context) throws Throwable {
        String operationName = null;
        String serviceName = this.userTask.getHumanTask().getText() + ".reference";
        CXPartnerLink partnerLink = (CXPartnerLink)sc.getObject(serviceName);
        HashMap<String, Boolean> partnerProperties = partnerLink.getProperties();
        if (partnerProperties == null) {
            partnerProperties = new HashMap<String, Boolean>();
            partnerLink.setProperties(partnerProperties);
        }
        partnerProperties.put("DONNOT_MARK_COMPLETE", true);
        String convId = NMUtil.generateConversationId();
        partnerLink.setConversationId(convId);
        ComponentModel component = CubeContextHelper.getScaComponent((ICubeContext)ctx);
        String correlatingId = ci.getConversationId();
        HashMap inputs = new HashMap();
        this.processInputData(this.userTask, sc, ctx, wi, inputs, component.getComposite().getWSDLManager().getSchemaManager(), ci, operationName, correlatingId);
        CXMessageVariable inputVariable = (CXMessageVariable)sc.getObject(this.mdServiceTask.getInputVariableName());
        inputVariable.putAll(inputs);
    }

    private Map<String, Object> getInitiatValues(IScope sc, ICubeContext ctx) throws Exception {
        HashMap<String, Object> initialeValues = new HashMap<String, Object>();
        if (this.userTask.isReinitiate()) {
            NodeList nodes;
            Element taskServiceOutputElement;
            UserTask rUserTask = this.userTask.getReinitiateSource();
            if (rUserTask == null) {
                return initialeValues;
            }
            String outputVarName = rUserTask.getDefaultLabel() + "_" + rUserTask.getId() + "_out";
            CXMessageVariable outputVariable = (CXMessageVariable)sc.getObject(outputVarName);
            if (outputVariable != null && (taskServiceOutputElement = (Element)outputVariable.get((Object)PAYLOAD_ELEMENT_NAME)) != null && (nodes = taskServiceOutputElement.getElementsByTagNameNS(TASK_NAMESPACE, TASK_ELEMENT_NAME)).getLength() > 0) {
                Element reinitiateElement = (Element)nodes.item(0);
                Element taskElement = DOMUtil.createRootElement((String)TASK_ELEMENT_NAME, (String)TASK_NAMESPACE);
                NodeList payloadNode = (taskElement = (Element)DOMUtil.copyObjHelper((Object)reinitiateElement, (Object)taskElement, (boolean)false, (ICubeContext)ctx)).getElementsByTagNameNS(TASK_NAMESPACE, PAYLOAD_ELEMENT_NAME);
                if (payloadNode.getLength() > 0) {
                    Element payloadElement = (Element)payloadNode.item(0);
                    if (!this.userTask.getReinitiatePolicy().isClear()) {
                        for (DataDeclaration datType : this.userTask.getInputDataAssociationSet().getArguments()) {
                            String elementName = datType.getNativeName();
                            String variableId = datType.getName();
                            if (variableId.equals("execData")) continue;
                            SchemaObject object = datType.getType().getDelegate().asSchemaObject();
                            String nameSpace = null;
                            nameSpace = object.isType() ? TASK_NAMESPACE : object.getNamespace();
                            NodeList argNodes = payloadElement.getElementsByTagNameNS(nameSpace, elementName);
                            if (argNodes.getLength() <= 0) continue;
                            initialeValues.put(variableId, argNodes.item(0));
                        }
                    }
                    NodeList payloadChildNodes = payloadElement.getChildNodes();
                    for (int i = 0; i < payloadChildNodes.getLength(); ++i) {
                        payloadElement.removeChild(payloadChildNodes.item(i));
                    }
                }
                initialeValues.put("execData", taskElement);
            }
        }
        return initialeValues;
    }

    private void processInputData(UserTask userTask, IScope sc, ICubeContext ctx, IWorkItem wi, Map payload, SchemaManager manager, ICubeInstanceImpl ci, String operationName, String conversationId) throws Exception {
        HashMap<String, Element> inputData = new HashMap<String, Element>();
        String partName = PAYLOAD_ELEMENT_NAME;
        SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
        namespaceContext.addNamespace(TASKSERVICE_ELEMENT_NAME, TASK_SERVICE_NAMESPACE);
        namespaceContext.addNamespace(TASK_ELEMENT_NAME, TASK_NAMESPACE);
        Map<String, Object> initialValues = this.getInitiatValues(sc, ctx);
        Map<String, DataElementVariable> data = DataHandlingUtils.processInputData((FlowNode)userTask, userTask.getInputDataAssociationSet(), sc, ctx, wi, initialValues);
        XMLElement execDataObject = null;
        DataElementVariable execDataVar = data.get("execData");
        execDataObject = (XMLElement)execDataVar.getValue();
        Element element = this.getTaskServiceElement();
        Element taskElement = (Element)element.getElementsByTagNameNS(TASK_NAMESPACE, TASK_ELEMENT_NAME).item(0);
        if (execDataObject != null) {
            taskElement = (Element)DOMUtil.copyObjHelper((Object)execDataObject, (Object)taskElement, (boolean)false, (ICubeContext)ctx);
        }
        this.addTaskAttributesToXml(ctx, userTask, taskElement, sc, wi, ci, conversationId);
        XMLElement payloadElement = (XMLElement)taskElement.getElementsByTagNameNS(TASK_NAMESPACE, PAYLOAD_ELEMENT_NAME).item(0);
        DataAssociationSet inputAssociation = userTask.getInputDataAssociationSet();
        boolean isInitiateTask = userTask.isManualStart();
        boolean isDataAssociationExit = false;
        if (isInitiateTask && inputAssociation != null) {
            Sequence associations = inputAssociation.getDataAssociations();
            boolean bl = isDataAssociationExit = associations != null && !associations.isEmpty();
        }
        if (isInitiateTask && !isDataAssociationExit) {
            this.createPayloadForTaskAlways(ctx, userTask, payloadElement, data);
        } else if (data != null) {
            this.processDataAssociations(ctx, inputAssociation, payloadElement, data, true);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"processInputData", (Object)XMLUtil.toString((Node)element));
        }
        inputData.put(partName, element);
        payload.putAll(inputData);
    }

    private void createPayloadForTaskAlways(ICubeContext ctx, UserTask userTask, XMLElement payloadElement, Map data) throws Exception {
        HumanTask ht = userTask.getHumanTask();
        Sequence arguments = ht.getArguments();
        for (Argument argument : arguments) {
            String dataIpOpName = argument.getName();
            SchemaObject asSchemaObject = argument.getType().asSchemaObject();
            String argName = null;
            argName = asSchemaObject.isType() ? dataIpOpName : asSchemaObject.getName();
            Element element = (Element)this.mElementMap.get(argName);
            if (element == null) continue;
            Element newElement = (Element)XMLUtil.cloneNode((Document)payloadElement.getDocument(), (Node)element);
            payloadElement.appendChild((Node)newElement);
        }
    }

    private void processDataAssociations(ICubeContext ctx, DataAssociationSet dataAssociationSet, Object payload, Map data, boolean input) throws Exception {
        Sequence dataDecls = dataAssociationSet.getArguments();
        for (DataDeclaration datType : dataDecls) {
            String elementName = datType.getNativeName();
            String variableId = datType.getName();
            if (input && variableId.equals("execData") || !input && (variableId.equals("execData") || variableId.equals("outcome"))) continue;
            SchemaObject object = datType.getType().getDelegate().asSchemaObject();
            String nameSpace = null;
            nameSpace = object.isType() ? TASK_NAMESPACE : object.getNamespace();
            XMLElement payloadElement = (XMLElement)payload;
            if (input) {
                DataElementVariable var = (DataElementVariable)data.get(variableId);
                Object val = var.getValue();
                if (val instanceof String) {
                    this.addChildElementAndPopulateValue(ctx, PAYLOAD_ELEMENT_NAME, elementName, (Element)((XMLElement)payloadElement.getParentNode()), val);
                    continue;
                }
                Element xmlElement = null;
                if (object.isType()) {
                    xmlElement = payloadElement.getOwnerDocument().createElementNS(nameSpace, elementName);
                    xmlElement = (Element)DOMUtil.copyObjHelper((Object)val, (Object)xmlElement, (boolean)false, (ICubeContext)ctx);
                } else {
                    xmlElement = (Element)val;
                }
                if (xmlElement == null) continue;
                payloadElement.appendChild(payloadElement.getDocument().importNode((Node)((XMLNode)xmlElement), true));
                continue;
            }
            Element node = null;
            NodeList list = payloadElement.getElementsByTagNameNS(nameSpace, elementName);
            if (object.isType()) {
                Element element = (Element)list.item(0);
                String namespace = object.getNamespace();
                String outputElementName = datType.getName();
                node = DOMUtil.createRootElement((String)outputElementName, (String)namespace);
                node = (Element)DOMUtil.copyObjHelper((Object)element, (Object)node, (boolean)false, (ICubeContext)ctx);
            } else {
                node = (Element)list.item(0);
            }
            if (list.getLength() < 0) continue;
            data.put(variableId, node);
        }
    }

    private Element getTaskServiceElement() throws Exception {
        if (this.userTask.isReinitiate()) {
            return XMLUtil.parseDocument((String)REINITIATE_TASKSERVICE_XML_FRAGMENT).getDocumentElement();
        }
        return XMLUtil.parseDocument((String)INITIATE_TASKSERVICE_XML_FRAGMENT).getDocumentElement();
    }

    private BPMNExpression getBPMNExpression(Expression expression, IScope scope, ICubeContext ctx) throws Exception {
        String strExpression = expression.getExpressionValue();
        BPMNExpressionMetadata forBPMNExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, null, strExpression, BPMNExpressionLanguage.XPATH, expression.getNamespaces());
        BPMNExpression forBPMNExpression = BPMNExpression.createBPMNExpression((FlowNode)this.userTask, forBPMNExpressionMetadata, scope);
        return forBPMNExpression;
    }

    private String getStringValue(Expression expression, IScope scope, ICubeContext ctx) throws Exception {
        if (expression == null || expression.getExpressionValue().equals("")) {
            return null;
        }
        BPMNExpression forBPMNExpression = this.getBPMNExpression(expression, scope, ctx);
        return forBPMNExpression.evaluateString(scope, ctx);
    }

    private void addTaskAttributesToXml(ICubeContext ctx, UserTask userTask, Element taskElement, IScope sc, IWorkItem wi, ICubeInstanceImpl ci, String conversationId) throws Exception {
        TaskImpl task = (TaskImpl)TaskUtil.getInstance().unmarshal((Node)taskElement);
        Element payload = XMLUtil.parseDocument((String)"<payload xmlns=\"http://xmlns.oracle.com/bpel/workflow/task\"/>").getDocumentElement();
        task.setPayloadAsElement(payload);
        String title = this.getStringValue(userTask.getSubject(), sc, ctx);
        int priority = userTask.getPriority();
        String taskOwner = this.getStringValue(userTask.getOwner(), sc, ctx);
        String creator = this.getStringValue(userTask.getInitiator(), sc, ctx);
        String applicationContext = this.getStringValue(userTask.getApplicationContext(), sc, ctx);
        String identityContext = this.getStringValue(userTask.getIdentificationContext(), sc, ctx);
        String identificationKey = this.getStringValue(userTask.getIdentificationKey(), sc, ctx);
        if (!this.checkIfStringIsNullOrEmpty(title)) {
            task.setTitle(title);
        }
        if (!this.checkIfStringIsNullOrEmpty(applicationContext)) {
            task.setApplicationContext(applicationContext);
        }
        if (!this.checkIfStringIsNullOrEmpty(identityContext)) {
            task.setIdentityContext(identityContext);
        }
        if (!this.checkIfStringIsNullOrEmpty(identificationKey)) {
            task.setIdentificationKey(identificationKey);
        }
        if (!this.checkIfStringIsNullOrEmpty(taskOwner)) {
            task.setOwnerUser(taskOwner);
        }
        if (this.checkIfStringIsNullOrEmpty(creator) && userTask.isManualStart()) {
            creator = wi.getCubeInstance().getCreator();
        }
        if (!this.checkIfStringIsNullOrEmpty(creator)) {
            task.setCreator(creator);
        }
        if (priority > 0) {
            task.setPriority(priority);
        }
        ProcessType type = task.getProcessInfo();
        ObjectFactory factory = new ObjectFactory();
        if (type == null) {
            type = factory.createProcessType();
            task.setProcessInfo(type);
        }
        long instanceId = ci.getId();
        String processId = userTask.getProcess().getId();
        type.setProcessName(userTask.getProcess().getName());
        type.setProcessId(processId);
        type.setInstanceId(instanceId + "");
        SystemAttributesType sysType = task.getSystemAttributes();
        if (sysType == null) {
            sysType = factory.createSystemAttributesType();
        }
        String activityId = userTask.getId();
        HashMap map = wi.getNodeActivationContext();
        int thread = BPMNTokenMetadataUtils.getThreadFromTokenMetadata(map);
        int parentThread = BPMNTokenMetadataUtils.getParentThreadFromTokenMetadata(map);
        sysType.setActivityId(activityId);
        sysType.setThread(thread);
        sysType.setParentThread(parentThread);
        if (userTask.isManualStart()) {
            task.setIdentificationKey(conversationId);
        }
    }

    private boolean checkIfStringIsNullOrEmpty(String str) {
        return str == null || str.trim().equals("");
    }

    private void addChildElementAndPopulateValue(ICubeContext ctx, String parentElementName, String childElementName, Element element, Object value) throws Exception {
        XMLElement parentElement = (XMLElement)element.getElementsByTagNameNS(TASK_NAMESPACE, parentElementName).item(0);
        if (parentElement != null) {
            parentElement.appendChild((Node)parentElement.getDocument().createElementNS(TASK_NAMESPACE, childElementName));
            XMLElement childElement = (XMLElement)element.getElementsByTagNameNS(TASK_NAMESPACE, childElementName).item(0);
            DOMUtil.copyObjHelper((Object)value, (Object)childElement, (boolean)false, (ICubeContext)ctx);
        }
    }
}

