/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.xml.dom.DOMUtil;
import java.util.HashMap;
import java.util.Map;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpel.services.workflow.task.impl.TaskUtil;
import oracle.bpel.services.workflow.task.model.IdentityType;
import oracle.bpel.services.workflow.task.model.SystemAttributesType;
import oracle.bpel.services.workflow.task.model.TaskImpl;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.fabric.common.NormalizedMessage;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MIUserTaskCallback
extends MIBase<Object> {
    private UserTask userTask;

    public MIUserTaskCallback(UserTask userTask) {
        this.userTask = userTask;
    }

    @Override
    protected Object doExecute(MicroInstructionContext context) throws Throwable {
        IWorkItem wi = context.getWorkItem();
        IScope sc = wi.getScope();
        ICubeContext ctx = context.getCubeContext();
        ICubeInstanceImpl ci = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        this.doHandleCallback(context);
        return null;
    }

    protected void doHandleCallback(MicroInstructionContext context) throws Throwable {
        IWorkItem wi = context.getWorkItem();
        MIUserTaskCallback.processOutputData(context, this.userTask);
        wi.markAsComplete();
    }

    public static void processOutputData(MicroInstructionContext context, UserTask userTask) throws Exception {
        ICubeContext ctx = context.getCubeContext();
        NormalizedMessage nm = (NormalizedMessage)ctx.getFromEnvironment("__call-NM");
        Map inputs = null;
        if (nm != null) {
            inputs = nm.getPayload();
        }
        if (inputs != null) {
            MIUserTaskCallback.processOutputData(context, userTask, inputs);
        }
    }

    public static void processOutputData(MicroInstructionContext context, UserTask userTask, Map inputs) throws Exception {
        IWorkItem wi = context.getWorkItem();
        IScope sc = wi.getScope();
        ICubeContext ctx = context.getCubeContext();
        XMLElement payload = (XMLElement)inputs.get("payload");
        XMLElement taskObject = null;
        taskObject = payload.getNamespaceURI().equals("http://xmlns.oracle.com/bpel/workflow/task") && payload.getNodeLocalName().equals("task") ? payload : (XMLElement)payload.getElementsByTagNameNS("http://xmlns.oracle.com/bpel/workflow/task", "task").item(0);
        XMLElement payloadElement = (XMLElement)taskObject.getElementsByTagNameNS("http://xmlns.oracle.com/bpel/workflow/task", "payload").item(0);
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (payloadElement != null) {
            MIUserTaskCallback.processDataAssociations(ctx, userTask.getOutputDataAssociationSet(), payloadElement, data);
        }
        String outcome = "";
        if (taskObject != null) {
            TaskImpl task = (TaskImpl)TaskUtil.getInstance().unmarshal((Node)taskObject);
            SystemAttributesType sysAttr = task.getSystemAttributes();
            IdentityType idType = sysAttr.getUpdatedBy();
            if (idType != null) {
                String updatedBy = idType.getId() + "," + idType.getType();
                ctx.addToEnvironment("USER_TASK_UPDATED_BY", (Object)updatedBy);
            }
            outcome = sysAttr.getOutcome();
            task = null;
        } else {
            BPELExecutionLogger.warn((String)"MIUserTaskCallback", (String)"processOutputData", (Object)XMLUtil.toString((Node)payload));
        }
        data.put("outcome", outcome);
        data.put("execData", taskObject);
        DataHandlingUtils.processOutputData((FlowNode)userTask, userTask.getOutputDataAssociationSet(), sc, ctx, data, wi);
    }

    private static void processDataAssociations(ICubeContext ctx, DataAssociationSet dataAssociationSet, Object payload, Map data) throws Exception {
        Sequence dataDecls = dataAssociationSet.getArguments();
        for (DataDeclaration datType : dataDecls) {
            String elementName = datType.getNativeName();
            String variableId = datType.getName();
            SchemaObject object = datType.getType().getDelegate().asSchemaObject();
            String nameSpace = null;
            nameSpace = object.isType() ? "http://xmlns.oracle.com/bpel/workflow/task" : object.getNamespace();
            XMLElement payloadElement = (XMLElement)payload;
            Element node = null;
            NodeList list = payloadElement.getElementsByTagNameNS(nameSpace, elementName);
            if (object.isType()) {
                Element element = (Element)list.item(0);
                String namespace = object.getNamespace();
                String outputElementName = datType.getName();
                node = DOMUtil.createRootElement((String)outputElementName, (String)namespace);
                node = (Element)DOMUtil.copyObjHelper((Object)element, (Object)node, (boolean)false, (ICubeContext)ctx);
            } else {
                node = (Element)list.item(0);
            }
            if (list.getLength() < 0) continue;
            data.put(variableId, node);
        }
    }
}

