/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.core.map.ICubeNode;
import com.collaxa.cube.engine.ext.bpel.common.BPELWMPHelper;
import com.collaxa.cube.xml.schema.XMLSchemaUtils;
import java.util.Date;
import javax.xml.namespace.NamespaceContext;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MITimerEvent;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDTimerEvent;
import oracle.bpm.bpmn.engine.runtime.BPMNExpression;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionDataElementContextType;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionLanguage;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionMetadata;
import oracle.bpm.lib.Expression;
import oracle.soa.common.util.CXStringUtils;

public class MITimerEventDefineExpirationDate
extends MIBase<Date> {
    private MDTimerEvent mdTimerEvent;

    public MITimerEventDefineExpirationDate(MDTimerEvent mdTimerEvent) {
        this.mdTimerEvent = mdTimerEvent;
    }

    @Override
    protected Date doExecute(MicroInstructionContext context) throws Throwable {
        Date date;
        IWorkItem wi = context.getWorkItem();
        IScope sc = wi.getScope();
        ICubeContext ctx = context.getCubeContext();
        BPMNCubeElement node = context.getNode();
        Expression forExpr = this.mdTimerEvent.getTimeCycle();
        Expression untilExpr = this.mdTimerEvent.getTimeDate();
        BPELWMPHelper.setNamespaceContext((NamespaceContext)BPELWMPHelper.getNamespaceContext((ICubeNode)((ICubeNode)node), (ICubeContext)ctx), (ICubeContext)ctx);
        Object result = null;
        Object emulatedDate = null;
        ICubeInstanceImpl ci = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        String expressionResult = null;
        if (forExpr != null) {
            String forValue = null;
            BPMNExpressionMetadata forBPMNExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, null, forExpr.getExpressionValue(), BPMNExpressionLanguage.XPATH, forExpr.getNamespaces());
            BPMNExpression forBPMNExpression = BPMNExpression.createBPMNExpression(node.getFlowElement(), forBPMNExpressionMetadata, sc);
            forValue = forBPMNExpression.evaluateString(sc, ctx);
            expressionResult = "For:" + forValue;
            if (!CXStringUtils.isEmpty((String)forValue)) {
                result = new Date(System.currentTimeMillis() + XMLSchemaUtils.parseDuration((String)forValue));
            }
        } else if (untilExpr != null) {
            String untilValue = null;
            BPMNExpressionMetadata forBPMNExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, null, untilExpr.getExpressionValue(), BPMNExpressionLanguage.XPATH, untilExpr.getNamespaces());
            BPMNExpression untilBPMNExpression = BPMNExpression.createBPMNExpression(node.getFlowElement(), forBPMNExpressionMetadata, sc);
            untilValue = untilBPMNExpression.evaluateString(sc, ctx);
            expressionResult = "Until:" + untilValue;
            if (!CXStringUtils.isEmpty((String)untilValue)) {
                result = XMLSchemaUtils.parseDateTime((String)untilValue).getTime();
            }
        }
        if (result != null && result instanceof Date && (date = (Date)result).getTime() < System.currentTimeMillis()) {
            result = MITimerEvent.STR_SKIP;
        }
        if (result == null) {
            result = MITimerEvent.STR_NEVER;
        }
        sc.declareAndSet(MITimerEvent.EXPIRATION_DATE + wi.getKey(), result);
        sc.declareAndSet(MITimerEvent.EXPIRATION_DATE_EXPRESSION + wi.getKey(), expressionResult);
        if (result instanceof Date) {
            return (Date)result;
        }
        return null;
    }
}

