/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeEngineResources;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.lang.compiler.bpel.BPELDefs;
import com.oracle.bpel.client.BPELFault;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;

public class MITimerEvent
extends MIBase<Object> {
    protected static SimpleDateFormat SDF = new SimpleDateFormat(CubeEngineResources.getString((String)"LABEL_date"));
    protected static String EXPIRATION_DATE = "expirationDate";
    protected static String EXPIRATION_DATE_EXPRESSION = "expirationDateExpression";
    protected static String STR_SKIP = "SKIP";
    protected static String STR_NEVER = "NEVER";

    @Override
    protected Object doExecute(MicroInstructionContext context) throws Throwable {
        IWorkItem wi = context.getWorkItem();
        IScope sc = wi.getScope();
        ICubeContext ctx = context.getCubeContext();
        String expVar = EXPIRATION_DATE + wi.getKey();
        Object value = sc.getAsObject(expVar);
        if (STR_SKIP.equals(value)) {
            wi.markAsComplete();
        } else if (STR_NEVER.equals(value)) {
            wi.markAsOpenPendingComplete();
        } else {
            if (value instanceof String) {
                BPELFault bf = new BPELFault(BPELDefs.QNX_INVALID_DATA_FAULT);
                bf.setPart("reason", value);
                throw bf;
            }
            Date date = (Date)value;
            if (date.getTime() < System.currentTimeMillis()) {
                wi.markAsComplete();
            } else {
                wi.markAsOpenPendingComplete();
            }
        }
        return null;
    }

    @Override
    protected String getMicroInstructionDescription(MicroInstructionContext context) {
        IWorkItem wi = context.getWorkItem();
        Object expression = null;
        try {
            expression = wi.getScope().getAsObject(EXPIRATION_DATE_EXPRESSION + wi.getKey());
        }
        catch (CubeException e) {
            expression = "";
        }
        return super.getMicroInstructionDescription(context) + "(" + (expression == null ? "" : expression) + ")";
    }
}

