/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.types.bpel.CXMessageVariable;
import java.util.Map;
import oracle.bpm.bpmn.engine.microkernel.MDIncomingMessage;
import oracle.bpm.bpmn.engine.microkernel.MDServiceActivity;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.ServiceInteractionUtils;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;

public abstract class MIProcessMessageOutputDataAssociationsForService
extends MIBase<Map> {
    protected final MDIncomingMessage mdIncomingMessage;
    protected final MDServiceActivity mdServiceActivity;
    protected boolean saveAsProperty;
    protected static final String MESSAGE_VARIABLE = "MESSAGE_VARIABLE";

    public MIProcessMessageOutputDataAssociationsForService(MDServiceActivity mdServiceActivity, MDIncomingMessage mdOutgoingMessage, boolean saveAsProperty) {
        this.mdServiceActivity = mdServiceActivity;
        this.mdIncomingMessage = mdOutgoingMessage;
        this.saveAsProperty = saveAsProperty;
    }

    public static class Step2
    extends MIProcessMessageOutputDataAssociationsForService {
        public Step2(MDServiceActivity mdServiceActivity, MDIncomingMessage mdOutgoingMessage, boolean saveAsProperty) {
            super(mdServiceActivity, mdOutgoingMessage, saveAsProperty);
        }

        @Override
        public String getMicroInstructionDescription() {
            return MIProcessMessageOutputDataAssociationsForService.class.getSimpleName() + "." + super.getMicroInstructionDescription();
        }

        @Override
        protected Map doExecute(MicroInstructionContext context) throws Throwable {
            ICubeContext ctx = context.getCubeContext();
            IWorkItem wi = context.getWorkItem();
            IScope sc = wi.getScope();
            CXMessageVariable result = this.saveAsProperty ? context.getProperty(MIProcessMessageOutputDataAssociationsForService.MESSAGE_VARIABLE, CXMessageVariable.class) : (CXMessageVariable)context.removeTokenMetadataProperty(MIProcessMessageOutputDataAssociationsForService.MESSAGE_VARIABLE);
            DataAssociationSet outputDataAssociationSet = this.mdIncomingMessage.getOutputDataAssociationSet();
            if (outputDataAssociationSet != null) {
                Object payload = ServiceInteractionUtils.isWrappedArguments(this.mdServiceActivity, result) ? ServiceInteractionUtils.unwrapArguments(outputDataAssociationSet, result) : result;
                DataHandlingUtils.processOutputDataForServiceActivities(this.mdServiceActivity.getFlowElement(), this.mdIncomingMessage.getOutputPartNamesMap(), outputDataAssociationSet, sc, ctx, (Map<String, Object>)payload, wi, false);
            }
            return result;
        }
    }

    public static class Step1
    extends MIProcessMessageOutputDataAssociationsForService {
        public Step1(MDServiceActivity mdServiceActivity, MDIncomingMessage mdOutgoingMessage, boolean saveAsProperty) {
            super(mdServiceActivity, mdOutgoingMessage, saveAsProperty);
        }

        @Override
        public String getMicroInstructionDescription() {
            return MIProcessMessageOutputDataAssociationsForService.class.getSimpleName() + "." + super.getMicroInstructionDescription();
        }

        @Override
        protected Map doExecute(MicroInstructionContext context) throws Throwable {
            String varName = context.getProperty("DATA_ASSOCIATION_OUTPUT_VARIABLE", String.class);
            IWorkItem wi = context.getWorkItem();
            IScope sc = wi.getScope();
            CXMessageVariable result = (CXMessageVariable)sc.getObject(varName);
            if (this.saveAsProperty) {
                context.setProperty(MIProcessMessageOutputDataAssociationsForService.MESSAGE_VARIABLE, result);
            } else {
                context.setPropertyToAddInTokenMetadata(MIProcessMessageOutputDataAssociationsForService.MESSAGE_VARIABLE, result);
            }
            return result;
        }
    }
}

