/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.types.bpel.CXMessageVariable;
import java.util.Map;
import oracle.bpm.bpmn.engine.microkernel.MDOutgoingMessage;
import oracle.bpm.bpmn.engine.microkernel.MDServiceActivity;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.ServiceInteractionUtils;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;

public class MIProcessMessageInputDataAssociationsForService
extends MIBase<Map> {
    private final MDOutgoingMessage mdOutgoingMessage;
    private final MDServiceActivity mdServiceActivity;

    public MIProcessMessageInputDataAssociationsForService(MDServiceActivity mdServiceActivity, MDOutgoingMessage mdOutgoingMessage) {
        this.mdServiceActivity = mdServiceActivity;
        this.mdOutgoingMessage = mdOutgoingMessage;
    }

    @Override
    protected Map doExecute(MicroInstructionContext context) throws Throwable {
        String varName = context.getProperty("DATA_ASSOCIATION_INPUT_VARIABLE", String.class);
        ICubeContext ctx = context.getCubeContext();
        IWorkItem wi = context.getWorkItem();
        IScope sc = wi.getScope();
        CXMessageVariable result = (CXMessageVariable)sc.getObject(varName);
        DataAssociationSet inputDataAssociationSet = this.mdOutgoingMessage.getInputDataAssociationSet();
        Map<String, Object> map = DataHandlingUtils.processInputDataForServiceActivities(this.mdServiceActivity.getFlowElement(), this.mdOutgoingMessage.getInputPartNamesMap(), inputDataAssociationSet, sc, ctx, wi, result.getMessageType());
        if (ServiceInteractionUtils.isWrappedArguments(this.mdServiceActivity, result)) {
            ServiceInteractionUtils.wrapArguments(inputDataAssociationSet, result, map, result.getMessageType());
        } else {
            result.putAll(map);
        }
        return result;
    }
}

