/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.IScope;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDGenerateNextToken;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenManager;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;

public abstract class MIGenerateTokenMicroInstruction
extends MIBase<Object> {
    protected MDGenerateNextToken mdGenerateNextToken;

    protected MIGenerateTokenMicroInstruction(MDGenerateNextToken mdGenerateNextToken) {
        this.mdGenerateNextToken = mdGenerateNextToken;
    }

    @Override
    public final Object doExecute(MicroInstructionContext context) throws CubeException {
        int step;
        int thread;
        int parentThread;
        if (this.mdGenerateNextToken.isCreateNewThread()) {
            parentThread = context.getThread();
            thread = BPMNTokenMetadataUtils.getNewThreadNumber(context.getWorkItem().getScope());
            step = 0;
        } else {
            thread = context.getThread();
            step = context.getStep() + 1;
            parentThread = context.getParentThread();
        }
        return this.doExecute(context, thread, step, parentThread);
    }

    @Override
    public String getMicroInstructionDescription() {
        StringBuilder builder = new StringBuilder();
        BPMNCubeElement source = this.mdGenerateNextToken.getSourceNode();
        String target = this.mdGenerateNextToken.getNextTokenId();
        boolean newThread = this.mdGenerateNextToken.isCreateNewThread();
        builder.append(super.getMicroInstructionDescription());
        builder.append(":");
        builder.append(source.getId());
        builder.append("->");
        builder.append(target);
        if (newThread) {
            builder.append("(N)");
        }
        return builder.toString();
    }

    protected abstract Object doExecute(MicroInstructionContext var1, int var2, int var3, int var4) throws CubeException;

    protected void generateToken(MicroInstructionContext context, int thread, int step, int parentThread, IScope scope) throws CubeException {
        BPMNTokenManager.generateOpenToken(scope, this.mdGenerateNextToken.getSourceNode(), this.mdGenerateNextToken.getNextTokenId(), context.getActivationIds(), parentThread, thread, step, context.getPropertiesToAddInTokenMetadata());
    }

    public static class ToNextActivityInParentScope
    extends MIGenerateTokenMicroInstruction {
        public ToNextActivityInParentScope(MDGenerateNextToken mdGenerateNextToken) {
            super(mdGenerateNextToken);
        }

        @Override
        protected Object doExecute(MicroInstructionContext context, int thread, int step, int parentThread) throws CubeException {
            this.generateToken(context, thread, step, parentThread, context.getWorkItem().getScope().getParentScope());
            return null;
        }
    }

    public static class ToNextActivity
    extends MIGenerateTokenMicroInstruction {
        public ToNextActivity(MDGenerateNextToken mdGenerateNextToken) {
            super(mdGenerateNextToken);
        }

        @Override
        protected Object doExecute(MicroInstructionContext context, int thread, int step, int parentThread) throws CubeException {
            this.generateToken(context, thread, step, parentThread, context.getWorkItem().getScope());
            return null;
        }
    }
}

