/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.types.bpel.CXMessageVariable;
import com.collaxa.cube.xml.dom.DOMUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.WSDLException;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpm.bpmn.engine.logging.BPMNLoggerManager;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDServiceTask;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.fabric.common.MetadataManager;
import oracle.fabric.common.metadata.MetadataManagerImpl;
import oracle.fabric.common.wsdl.SchemaManager;
import oracle.fabric.common.wsdl.WSDLManager;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MIBusinessRuleTaskResponse
extends MIBase<Object> {
    private BusinessRuleTask businessRuleTask = null;
    private MDServiceTask mdServiceTask;
    private String referenceName = null;
    private String serviceName = null;
    private String targetNameSpace = null;
    private Logger logger = BPMNLoggerManager.getInstance().getLogger(BPELExecutionLogger.class.getName());
    private static final String RESULT_LIST_ELEMENT_NAME = "resultList";
    private static final String MESSAGE_PARTNAME = "payload";
    private static MetadataManager metadataManager = new MetadataManagerImpl();
    private static WSDLManager wsdlManager;
    private static SchemaManager schemaManager;

    public MIBusinessRuleTaskResponse(MDServiceTask mdServiceTask, String targetNameSpace, String referenceName, String serviceName) {
        this.mdServiceTask = mdServiceTask;
        this.serviceName = serviceName;
        this.targetNameSpace = targetNameSpace;
        this.referenceName = referenceName;
        this.businessRuleTask = (BusinessRuleTask)mdServiceTask.getFlowElement();
    }

    public void processOutputData(DataAssociationSet outputArgumentMapping, IScope sc, ICubeContext ctx, IWorkItem item, Map<String, Object> payload) throws Exception {
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"processOutputData", (Object)"Start of process output data");
        XMLElement callBackMessage = (XMLElement)payload.get(MESSAGE_PARTNAME);
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"processOutputData", (Object)("Call back message is " + DOMUtil.toXML((Node)callBackMessage)));
        Element resultElement = this.getElement((Element)callBackMessage, RESULT_LIST_ELEMENT_NAME, this.targetNameSpace);
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (resultElement != null) {
            Sequence dataDeclas = outputArgumentMapping.getArguments();
            for (DataDeclaration dataType : dataDeclas) {
                String dataOutputName = dataType.getName();
                SchemaObject object = dataType.getType().getDelegate().asSchemaObject();
                String nameSpace = object.getNamespace();
                String elementName = object.getName();
                BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"processOutputData", (Object)("Getting element value for " + elementName + " with namespace " + nameSpace));
                NodeList list = resultElement.getElementsByTagNameNS(nameSpace, elementName);
                if (list.getLength() >= 0) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"processOutputData", (Object)("Include the value with key as " + dataOutputName + " value as " + XMLUtil.toString((Node)list.item(0))));
                    }
                    data.put(dataOutputName, list.item(0));
                    continue;
                }
                BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"processOutputData", (Object)("No value for element name " + elementName + " with name space  " + nameSpace));
            }
        }
        DataHandlingUtils.processOutputData((FlowNode)this.businessRuleTask, outputArgumentMapping, sc, ctx, data, item);
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"processOutputData", (Object)"End of process output data");
    }

    @Override
    protected Object doExecute(MicroInstructionContext context) throws Throwable {
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"doExecuteStatements", (Object)"Start of executing the business rule");
        IWorkItem wi = context.getWorkItem();
        IScope sc = wi.getScope();
        ICubeContext ctx = context.getCubeContext();
        ICubeInstanceImpl ci = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        this.handleBusinessRuleResponse(ci, wi, sc, ctx);
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"doExecuteStatements", (Object)"End of executing the business rule");
        return null;
    }

    private Element getElement(Element element, String name, String nameSpace) throws CubeException {
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"getElement", (Object)("Start of getting element with name " + name));
        NodeList nodes = element.getElementsByTagNameNS(nameSpace, name);
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            return (XMLElement)node;
        }
        BPELExecutionLogger.error((String)this.getClass().getName(), (String)"getElement", (Object)("Element with name " + name + " and namespace " + nameSpace + "doesn't Exist in " + DOMUtil.toXML((Node)element)));
        Object[] obj = new Object[]{name, nameSpace};
        throw new CubeException(75002, obj);
    }

    private void handleBusinessRuleResponse(ICubeInstanceImpl ci, IWorkItem wi, IScope sc, ICubeContext ctx) throws Throwable {
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"handleBusinessRuleResponse", (Object)"Start of handle business rule invoke ");
        CXMessageVariable result = (CXMessageVariable)sc.getObject(this.mdServiceTask.getOutputVariableName());
        this.processOutputData(this.businessRuleTask.getOutputDataAssociationSet(), sc, ctx, wi, (Map<String, Object>)result);
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"handleBusinessRuleResponse", (Object)"End of handle business rule invoke ");
    }

    static {
        try {
            wsdlManager = new WSDLManager(metadataManager);
        }
        catch (WSDLException wSDLException) {
            // empty catch block
        }
        schemaManager = new SchemaManager(wsdlManager, metadataManager);
    }
}

