/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.types.bpel.CXElementVariable;
import com.collaxa.cube.engine.types.bpel.CXMessageVariable;
import com.collaxa.cube.engine.types.bpel.CXTypeVariable;
import com.collaxa.cube.xml.dom.DOMUtil;
import com.collaxa.cube.xml.xsd.SchemaToXML;
import com.collaxa.cube.xml.xsd.XPathQueryInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import oracle.bpel.services.common.util.XMLUtil;
import oracle.bpm.bpmn.engine.logging.BPMNLoggerManager;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDServiceTask;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.runtime.DataElementVariable;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.fabric.common.MetadataManager;
import oracle.fabric.common.metadata.MetadataManagerImpl;
import oracle.fabric.common.wsdl.SchemaManager;
import oracle.fabric.common.wsdl.WSDLManager;
import oracle.fabric.composite.model.ComponentModel;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.v2.XMLElement;
import org.collaxa.thirdparty.jaxen.NamespaceContext;
import org.collaxa.thirdparty.jaxen.SimpleNamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MIBusinessRuleTaskRequest
extends MIBase<Object> {
    private BusinessRuleTask businessRuleTask = null;
    private MDServiceTask mdServiceTask;
    private String referenceName = null;
    private String serviceName = null;
    private String targetNameSpace = null;
    private Logger logger = BPMNLoggerManager.getInstance().getLogger(BPELExecutionLogger.class.getName());
    private static final String INPUT_STATELESS_ELEMENT_NAME = "callFunctionStateless";
    private static final String PARAMETER_LIST_ELEMENT_NAME = "parameterList";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String MESSAGE_PARTNAME = "payload";
    private static MetadataManager metadataManager = new MetadataManagerImpl();
    private static WSDLManager wsdlManager;
    private static SchemaManager schemaManager;

    public MIBusinessRuleTaskRequest(MDServiceTask mdServiceTask, String targetNameSpace, String referenceName, String serviceName) {
        this.mdServiceTask = mdServiceTask;
        this.serviceName = serviceName;
        this.targetNameSpace = targetNameSpace;
        this.referenceName = referenceName;
        this.businessRuleTask = (BusinessRuleTask)mdServiceTask.getFlowElement();
    }

    @Override
    protected Object doExecute(MicroInstructionContext context) throws Throwable {
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"doExecuteStatements", (Object)"Start of executing the business rule");
        IWorkItem wi = context.getWorkItem();
        IScope sc = wi.getScope();
        ICubeContext ctx = context.getCubeContext();
        ICubeInstanceImpl ci = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        this.handleBusinessRuleInvoke(ci, wi, sc, ctx);
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"doExecuteStatements", (Object)"End of executing the business rule");
        return null;
    }

    private void processInputData(BusinessRuleTask businessRuleTask, IScope sc, ICubeContext ctx, IWorkItem wi, Map<String, Object> payload, SchemaManager manager) throws Exception {
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"processInputData", (Object)"Start of processInputData");
        String operationName = INPUT_STATELESS_ELEMENT_NAME;
        XMLSchema schema = manager.lookupSchema(this.targetNameSpace);
        XSDElement xsdElement = schema.getElement(this.targetNameSpace, operationName);
        SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
        namespaceContext.addNamespace("rl", this.targetNameSpace);
        ArrayList<XPathQueryInfo> xInfos = new ArrayList<XPathQueryInfo>();
        boolean i = true;
        XPathQueryInfo info = new XPathQueryInfo("/rl:" + operationName + "/@" + NAME_ATTRIBUTE, 1);
        xInfos.add(info);
        XMLElement inputElement = SchemaToXML.generateXMLElement(null, (QName)xsdElement.getQName(), xInfos, (boolean)true, (boolean)false, (NamespaceContext)namespaceContext, (SchemaManager)manager);
        Attr attr = inputElement.getAttributeNode(NAME_ATTRIBUTE);
        DOMUtil.copyObjHelper((Object)this.serviceName, (Object)attr, (boolean)false, (ICubeContext)ctx);
        DataAssociationSet inputArgumentMapping = businessRuleTask.getInputDataAssociationSet();
        Sequence dataAssociations = inputArgumentMapping.getDataAssociations();
        HashMap<String, XMLElement> inputData = new HashMap<String, XMLElement>();
        Map<String, DataElementVariable> data = DataHandlingUtils.processInputData((FlowNode)businessRuleTask, businessRuleTask.getInputDataAssociationSet(), sc, ctx, wi);
        Element paramListElement = this.getElement((Element)inputElement, PARAMETER_LIST_ELEMENT_NAME, this.targetNameSpace);
        if (data != null) {
            for (String name : data.keySet()) {
                CXElementVariable cxVar;
                DataElementVariable var = data.get(name);
                SchemaObject schemaObject = var.getDataDeclaration().getType().getDelegate().asSchemaObject();
                String elementName = schemaObject.getName();
                String namespace = schemaObject.getNamespace();
                if (var == null || var.getStructure() == null) continue;
                QName parameterQName = null;
                if (var.getStructure() instanceof CXElementVariable) {
                    cxVar = (CXElementVariable)var.getStructure();
                    parameterQName = cxVar.getElement();
                } else if (var.getStructure() instanceof CXTypeVariable) {
                    cxVar = (CXTypeVariable)var.getStructure();
                    parameterQName = cxVar.getType();
                }
                Object value = var.getValue();
                if (value != null) {
                    Element parameterElement = paramListElement.getOwnerDocument().createElementNS(namespace, elementName);
                    paramListElement.appendChild(parameterElement);
                    parameterElement = (Element)DOMUtil.copyObjHelper((Object)value, (Object)parameterElement, (boolean)false, (ICubeContext)ctx);
                    continue;
                }
                BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"processInputData", (Object)("After evaluating the data handeling element is null for name " + name));
            }
        } else {
            throw new RuntimeException("ERROR: == Data is not evaluated properly");
        }
        if (this.logger.isLoggable(Level.FINE)) {
            BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"processInputData", (Object)("Input request of business rule service is *** " + XMLUtil.toString((Node)inputElement)));
        }
        inputData.put(MESSAGE_PARTNAME, inputElement);
        payload.putAll(inputData);
    }

    private Element getElement(Element element, String name, String nameSpace) throws CubeException {
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"getElement", (Object)("Start of getting element with name " + name));
        NodeList nodes = element.getElementsByTagNameNS(nameSpace, name);
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            return (XMLElement)node;
        }
        BPELExecutionLogger.error((String)this.getClass().getName(), (String)"getElement", (Object)("Element with name " + name + " and namespace " + nameSpace + "doesn't Exist in " + DOMUtil.toXML((Node)element)));
        Object[] obj = new Object[]{name, nameSpace};
        throw new CubeException(75002, obj);
    }

    private void handleBusinessRuleInvoke(ICubeInstanceImpl ci, IWorkItem wi, IScope sc, ICubeContext ctx) throws Throwable {
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"handleBusinessRuleInvoke", (Object)"Start of handle business rule invoke ");
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"handleBusinessRuleInvoke", (Object)("Reference name is " + this.referenceName));
        ComponentModel component = CubeContextHelper.getScaComponent((ICubeContext)ctx);
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        this.processInputData(this.businessRuleTask, sc, ctx, wi, inputs, component.getComposite().getWSDLManager().getSchemaManager());
        CXMessageVariable inputVariable = (CXMessageVariable)sc.getObject(this.mdServiceTask.getInputVariableName());
        inputVariable.putAll(inputs);
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"handleBusinessRuleInvoke", (Object)"End of handle business rule invoke ");
    }

    static {
        try {
            wsdlManager = new WSDLManager(metadataManager);
        }
        catch (WSDLException wSDLException) {
            // empty catch block
        }
        schemaManager = new SchemaManager(wsdlManager, metadataManager);
    }
}

