/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.audit.AuditLevel;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeInstance;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.oracle.bpel.client.BPELFault;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.analytics.measurement.IElementContext;
import oracle.bpm.analytics.measurement.MeasurementUtil;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.common.SequenceFlowMetadata;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDAuditLog;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.SequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.runtime.DeploymentDescriptorUtil;
import oracle.bpm.bpmn.engine.service.BPMNAuditEvent;
import oracle.bpm.bpmn.engine.service.audit.AuditServiceFactory;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.bpmn.engine.service.audit.IAuditService;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryMetadata;
import oracle.bpm.collections.Sequence;
import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.OutputDataAssociationEnabled;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItem;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItemRef;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditVariable;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.PrincipleRefType;

public class MIAuditLog
extends MIBase<Object> {
    private MDAuditLog mdAuditLog;
    private static final String logClassName = MIAuditLog.class.getName();
    private static final List<BpmnType> sAsyncTypes = new ArrayList<BpmnType>();
    private static final String FAULT_MESSAGE = "FaultMessage";
    private static final String LOOP_COUNT_NAME = "LoopCount";
    private static final String INSTANCE_COUNT_NAME = "InstanceCount";

    public MIAuditLog(MDAuditLog metadata) {
        this.mdAuditLog = metadata;
    }

    public MDAuditLog getMetadata() {
        return this.mdAuditLog;
    }

    @Override
    public String getMicroInstructionDescription() {
        String desc = this.mdAuditLog.getFlowElement().getId() + (this.mdAuditLog.isEntryPoint() ? "Pre" : "Post");
        return super.getMicroInstructionDescription() + "(" + desc + ")";
    }

    @Override
    protected Object doExecute(MicroInstructionContext context) throws CubeException {
        String logMethodName = "doExecute";
        FlowNode element = this.mdAuditLog.getFlowElement();
        try {
            String enabled = (String)context.getCubeContext().getFromEnvironment("AUDIT_ENABLED");
            if (enabled == null || Boolean.parseBoolean(enabled)) {
                IAuditService auditService = AuditServiceFactory.getInstance().getAuditService();
                if (enabled == null) {
                    enabled = auditService.canLog(context.getCubeContext(), AuditLevel.Minimal, this.getElementContext(context)) + "";
                    context.getCubeContext().addToEnvironment("AUDIT_ENABLED", (Object)enabled);
                }
                if (Boolean.parseBoolean(enabled)) {
                    BPMNAuditEvent event = this.createAuditEvent(context, false);
                    if (auditService.canLog(context.getCubeContext(), AuditLevel.Production)) {
                        boolean canLog = auditService.canLog(context.getCubeContext(), AuditLevel.Development) || sAsyncTypes.contains(element.getBpmnType());
                        this.handleAuditDetail(context, element, event, canLog, false);
                    } else {
                        BPELExecutionLogger.debug((String)logClassName, (String)"doExecute", (Object)"Audit detail will not be created. Check the Audit Log Level if it is required");
                    }
                    ICubeContext ctx = context.getCubeContext();
                    String sourceId = context.getSourceActivityId();
                    if (this.mdAuditLog.isEntryPoint()) {
                        this.handleMeasurementMarks(context, auditService, sourceId);
                        auditService.logAuditInstance(ctx, event);
                    } else {
                        this.handleCounters(context, auditService);
                        auditService.logAuditInstance(ctx, event);
                        this.handleMeasurementMarks(context, auditService, sourceId);
                    }
                } else {
                    BPELExecutionLogger.debug((String)logClassName, (String)"doExecute", (Object)"No audit logging will be performed. Auditing if OFF and it is not required by measurement");
                }
            }
        }
        catch (Exception e) {
            throw new CubeException((Throwable)e);
        }
        return null;
    }

    protected BPMNCubeElement getNode(MicroInstructionContext context) {
        return context.getNode();
    }

    private void handleMeasurementMarks(MicroInstructionContext context, IAuditService auditService, String sourceId) throws Exception {
        String logMethodName = "handleMeasurementMarks";
        BPELExecutionLogger.debug((String)logClassName, (String)"handleMeasurementMarks", (Object)"BEGIN");
        if (this.mdAuditLog.hasMeasurementMarks()) {
            for (Measurement m : this.mdAuditLog.getMeasurements()) {
                BPMNAuditEvent measureEvent = null;
                if (this.mdAuditLog.getFlowElement().isGateway()) {
                    BPELExecutionLogger.debug((String)logClassName, (String)"handleMeasurementMarks", (Object)("Processing measurement mark for gateway - ID {" + m.getId() + "} Label {" + m.getDefaultLabel() + "} Source {" + m.getTransition().getSource().getId() + "} Target {" + m.getTransition().getTarget().getId() + "} isEntryPoint {" + this.mdAuditLog.isEntryPoint() + "} Measurement Type {" + m.getMeasurementType().toString() + "}"));
                    measureEvent = this.createMeasureEventForGateway(context, m, sourceId);
                } else {
                    BPELExecutionLogger.debug((String)logClassName, (String)"handleMeasurementMarks", (Object)("Processing measurement mark for flow element - ID {" + m.getId() + "} Label {" + m.getDefaultLabel() + "} Source {" + m.getTransition().getSource().getId() + "} Target {" + m.getTransition().getTarget().getId() + "} isEntryPoint {" + this.mdAuditLog.isEntryPoint() + "} Measurement Type {" + m.getMeasurementType().toString() + "}"));
                    measureEvent = this.createMeasureEventForFlow(context, m, sourceId);
                }
                if (measureEvent == null) continue;
                measureEvent.setActivityId(m.getName());
                measureEvent.setActivityName(m.getMeasurementType().toString());
                measureEvent.setLabel(m.getDefaultLabel());
                measureEvent.setFlowElementType(BpmnType.MEASUREMENT.getInnerType().toString());
                measureEvent.setActivityType(BpmnType.MEASUREMENT.name());
                for (ProjectDataObject var : m.getBusinessIndicators()) {
                    BPELExecutionLogger.debug((String)logClassName, (String)"handleMeasurementMarks", (Object)("Associating variable {" + var.getName() + "} - {" + var.getDefaultLabel() + "}"));
                    measureEvent.addAssociatedVariable(var.getName());
                }
                ICubeContext ctx = context.getCubeContext();
                if (auditService.canLog(context.getCubeContext(), AuditLevel.Production)) {
                    boolean canLog = auditService.canLog(context.getCubeContext(), AuditLevel.Development) || sAsyncTypes.contains(this.mdAuditLog.getFlowElement().getBpmnType());
                    this.handleAuditDetail(context, this.mdAuditLog.getFlowElement(), measureEvent, canLog, true);
                } else {
                    BPELExecutionLogger.debug((String)logClassName, (String)"handleMeasurementMarks", (Object)"Audit detail will not be created. Check the Audit Log Level if it is required");
                }
                auditService.logAuditInstance(ctx, measureEvent);
            }
        }
        BPELExecutionLogger.debug((String)logClassName, (String)"handleMeasurementMarks", (Object)"END");
    }

    private void handleCounters(MicroInstructionContext context, IAuditService auditService) throws Exception {
        String logMethodName = "handleCounters";
        if (this.mdAuditLog.hasCounter()) {
            BPELExecutionLogger.debug((String)logClassName, (String)"handleCounters", (Object)"BEGIN Processing counters");
            for (Counter c : this.mdAuditLog.getCounters()) {
                BPMNAuditEvent counterEvent = this.createAuditEvent(context, true);
                BPELExecutionLogger.debug((String)logClassName, (String)"handleCounters", (Object)("Merging counter from activity ID {" + counterEvent.getActivityId() + "} to {" + c.getActivityId() + "}"));
                counterEvent.setOperation(AuditInstanceOperation.MEASUREMENT_COUNTER);
                counterEvent.setFlowElementType(BpmnType.COUNTER.getInnerType().toString());
                for (ProjectDataObject var : c.getBusinessIndicators()) {
                    BPELExecutionLogger.debug((String)logClassName, (String)"handleCounters", (Object)("Associating variable {" + var.getName() + "} - {" + var.getDefaultLabel() + "}"));
                    counterEvent.addAssociatedVariable(var.getName());
                }
                ICubeContext ctx = context.getCubeContext();
                if (auditService.canLog(context.getCubeContext(), AuditLevel.Production)) {
                    boolean canLog = auditService.canLog(context.getCubeContext(), AuditLevel.Development) || sAsyncTypes.contains(this.mdAuditLog.getFlowElement().getBpmnType());
                    this.handleAuditDetail(context, this.mdAuditLog.getFlowElement(), counterEvent, canLog, true);
                } else {
                    BPELExecutionLogger.debug((String)logClassName, (String)"handleCounters", (Object)"Audit detail will not be created. Check the Audit Log Level if it is required");
                }
                auditService.logAuditInstance(ctx, counterEvent);
            }
            BPELExecutionLogger.debug((String)logClassName, (String)"handleCounters", (Object)"END Processing counters");
        }
    }

    private BPMNAuditEvent createAuditEvent(MicroInstructionContext context, boolean isArtifact) throws CubeException {
        String logMethodName = "createAuditEvent";
        IWorkItem iWorkItem = context.getWorkItem();
        FlowNode element = this.mdAuditLog.getFlowElement();
        BPELExecutionLogger.debug((String)logClassName, (String)"createAuditEvent", (Object)"BEGIN");
        HashMap activationContext = context.getNodeActivationContext();
        BPELExecutionLogger.debug((String)logClassName, (String)"createAuditEvent", (Object)activationContext.toString());
        ICubeInstance cInstance = context.getCubeInstance();
        BPELExecutionLogger.debug((String)logClassName, (String)"createAuditEvent", (Object)("NODE - ID {" + this.getNode(context).getId() + "} Parent Block ID {" + this.getNode(context).getParentBlockId() + "} Process {" + element.getProcess().getDefaultLabel() + "} Type {" + this.getNode(context).getType() + "} Entry {" + this.mdAuditLog.isEntryPoint() + "} Component Type {" + this.mdAuditLog.getComponentType() + "}"));
        BPMNAuditEvent event = null;
        AuditQueryMetadata varMd = this.mdAuditLog.getAuditQueryMetadata();
        BPELExecutionLogger.debug((String)logClassName, (String)"createAuditEvent", (Object)("Audit Query Metadata {" + (varMd != null ? varMd.getCompositeDn() : "NULL Metadata!") + "}"));
        event = new BPMNAuditEvent();
        event.setAuditQueryMetadata(varMd);
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(cInstance.getCreationDate().getTime());
        event.setPartitionDate(c);
        BpmnType flowObjectSubType = this.mdAuditLog.getFlowElement().getBpmnType();
        event.setActivityName(flowObjectSubType.toString());
        event.setActivityId(this.mdAuditLog.getFlowElement().getId());
        event.setFlowElementType(flowObjectSubType.getInnerType().name());
        event.setActivityType(AuditUtil.getActivityType(this.mdAuditLog.getFlowElement(), flowObjectSubType));
        if (this.mdAuditLog.isEntryPoint()) {
            event.setAuditInstanceType(EAuditInstanceType.START.toString());
        } else {
            event.setAuditInstanceType(EAuditInstanceType.END.toString());
        }
        event.setComponentInstanceId(cInstance.getKey().toString());
        event.setComponentName(cInstance.getComponentDN().getComponentName());
        event.setComponentType(this.mdAuditLog.getComponentType());
        event.setCompositeDn(cInstance.getComponentDN().getCompositeDN());
        event.setCompositeInstanceId(cInstance.getCompositeInstanceId());
        event.setCompositeName(cInstance.getComponentDN().getCompositeName());
        event.setProcessName(element.getProcess().getId());
        BPELExecutionLogger.debug((String)logClassName, (String)"createAuditEvent", (Object)("Process ID {" + event.getProcessName() + "} Process Name {" + element.getProcess().getDefaultLabel() + "}"));
        event.setStep(Long.valueOf(context.getStep()));
        Integer loopCount = null;
        BPELExecutionLogger.debug((String)logClassName, (String)"createAuditEvent", (Object)("Loop Counter - SUBPROCESS INSTANCE {" + (element instanceof Subprocess) + "} loopCountAttr {" + (this.mdAuditLog.getLoopCountAttr() != null) + "}"));
        if (this.mdAuditLog.getLoopCountAttr() != null) {
            if (this.mdAuditLog.isInSubprocess()) {
                if (this.mdAuditLog.getLoopCountAttr().containsValue(context.getScope().getParentScope(), context.getCubeContext())) {
                    loopCount = (Integer)this.mdAuditLog.getLoopCountAttr().getValue(context.getScope().getParentScope(), context.getCubeContext());
                }
            } else if (this.mdAuditLog.getLoopCountAttr().containsValue(context.getScope(), context.getCubeContext())) {
                loopCount = (Integer)this.mdAuditLog.getLoopCountAttr().getValue(context.getScope(), context.getCubeContext());
            }
        }
        if (loopCount != null) {
            event.setLoopCount(loopCount.longValue());
            BPELExecutionLogger.debug((String)logClassName, (String)"createAuditEvent", (Object)("Loop Counter {" + loopCount + "}"));
        } else {
            event.setLoopCount(0L);
        }
        Integer instanceCount = null;
        BPELExecutionLogger.debug((String)logClassName, (String)"createAuditEvent", (Object)("Instance Counter - SUBPROCESS INSTANCE {" + (element instanceof Subprocess) + "} instanceCountAttr {" + (this.mdAuditLog.getInstanceCountAttr() != null) + "}"));
        if (this.mdAuditLog.getInstanceCountAttr() != null) {
            if (this.mdAuditLog.isInSubprocess()) {
                if (this.mdAuditLog.getInstanceCountAttr().containsValue(context.getScope().getParentScope(), context.getCubeContext())) {
                    instanceCount = (Integer)this.mdAuditLog.getInstanceCountAttr().getValue(context.getScope().getParentScope(), context.getCubeContext());
                }
            } else if (this.mdAuditLog.getInstanceCountAttr().containsValue(context.getScope(), context.getCubeContext())) {
                instanceCount = (Integer)this.mdAuditLog.getInstanceCountAttr().getValue(context.getScope(), context.getCubeContext());
            }
        }
        if (instanceCount != null) {
            event.setInstanceCount(instanceCount.longValue());
            BPELExecutionLogger.debug((String)logClassName, (String)"createAuditEvent", (Object)("Instance Counter {" + instanceCount + "}"));
        } else {
            event.setInstanceCount(0L);
        }
        if (iWorkItem != null && iWorkItem.getExpirationDate() != null) {
            c = Calendar.getInstance();
            c.setTime(iWorkItem.getExpirationDate());
            event.setDueDate(c);
        } else {
            event.setDueDate(null);
        }
        event.setOperation(this.mdAuditLog.getAuditInstanceOperation());
        this.handleException(context, iWorkItem, event);
        event.setInvokedComponentName(null);
        try {
            event.setLabel(element.getDefaultLabel());
        }
        catch (Exception e) {
            throw new CubeException((Throwable)e);
        }
        event.setParentThreadId(Long.valueOf(context.getParentThread()));
        BPELExecutionLogger.debug((String)logClassName, (String)"createAuditEvent", (Object)("SCOPE_ID {" + context.getScope().getAbsoluteScopeId() + "}"));
        event.setScopeId(context.getScope().getAbsoluteScopeId());
        this.resolveParticipant(element, event, context);
        BPELExecutionLogger.debug((String)logClassName, (String)"createAuditEvent", (Object)("Participant resolved to {" + event.getParticipant() + "}"));
        if (this.mdAuditLog.isEntryPoint()) {
            event.setSourceActivity(context.getSourceActivityId());
            event.setTargetActivity(this.mdAuditLog.getFlowElement().getId());
        } else if (flowObjectSubType.isGateway()) {
            if (flowObjectSubType == BpmnType.EVENT_BASED_GATEWAY) {
                event.setSourceActivity(this.mdAuditLog.getFlowElement().getId());
                event.setTargetActivity(this.getNode(context).getFlowElement().getId());
            } else {
                Gateway gw = (Gateway)this.mdAuditLog.getFlowElement();
                Map<String, HashMap<String, Object>> gTokens = this.getGeneratedTokensMetadata(context);
                Sequence outSequenceFlows = gw.getOutgoingSequenceFlows();
                for (SequenceFlow s : outSequenceFlows) {
                    BPELExecutionLogger.debug((String)logClassName, (String)"createAuditEvent", (Object)("Outgoing Sequence flow information for a gateway {" + s.getId() + "} source {" + s.getSource().getId() + "} target {" + s.getTarget().getId() + "} activation {" + context.getActivationIds() + "}"));
                    if (!gTokens.containsKey(s.getTarget().getId())) continue;
                    event.setSourceActivity(s.getSource().getId());
                    event.setTargetActivity(s.getTarget().getId());
                    break;
                }
            }
        } else {
            SequenceFlowMetadata sequenceFlowMetadata = this.getNode(context).getSequenceFlowMetadata();
            event.setSourceActivity(this.mdAuditLog.getFlowElement().getId());
            if (!this.mdAuditLog.isInstanceTerminated() && sequenceFlowMetadata != null && sequenceFlowMetadata.getOutgoingSequenceFlow() != null && context.getLastException() == null) {
                event.setTargetActivity(sequenceFlowMetadata.getOutgoingSequenceFlow().getTargetActivityId());
            }
        }
        BPELExecutionLogger.debug((String)logClassName, (String)"createAuditEvent", (Object)("Source Activity {" + event.getSourceActivity() + "} Target Activity {" + event.getTargetActivity() + "}"));
        event.setThreadId(Long.valueOf(context.getThread()));
        event.setTitle(this.mdAuditLog.getFlowElement().getName());
        this.handleBusinessIndicators(context, event, isArtifact);
        BPELExecutionLogger.debug((String)logClassName, (String)"createAuditEvent", (Object)"END");
        return event;
    }

    private BPMNAuditEvent createMeasureEventForFlow(MicroInstructionContext context, Measurement measurement, String sourceId) throws Exception {
        String logMethodName = "createMeasureEventForFlow";
        BPELExecutionLogger.debug((String)logClassName, (String)"createMeasureEventForFlow", (Object)"BEGIN");
        SequenceFlowMetadata sequenceFlowMetadata = this.getNode(context).getSequenceFlowMetadata();
        BPMNAuditEvent measureEvent = null;
        String nodeId = this.mdAuditLog.getFlowElement().getId();
        switch (measurement.getMeasurementType()) {
            case START: {
                if (this.mdAuditLog.isEntryPoint()) {
                    measureEvent = this.createFlowMeasureEvent(context, sequenceFlowMetadata.getIncomingSequenceFlow(), measurement, sourceId, nodeId);
                }
                if (measureEvent == null) break;
                measureEvent.setOperation(AuditInstanceOperation.MEASUREMENT_START);
                break;
            }
            case STOP: {
                if (!this.mdAuditLog.isEntryPoint()) {
                    measureEvent = this.createFlowMeasureEvent(context, sequenceFlowMetadata.getOutgoingSequenceFlow(), measurement, sourceId, nodeId);
                }
                if (measureEvent == null) break;
                measureEvent.setOperation(AuditInstanceOperation.MEASUREMENT_STOP);
                measureEvent.setReferenceId(measurement.getRelatedMeasurement().getName());
                break;
            }
            case START_STOP: {
                if (!this.mdAuditLog.isEntryPoint()) {
                    measureEvent = this.createFlowMeasureEvent(context, sequenceFlowMetadata.getOutgoingSequenceFlow(), measurement, sourceId, nodeId);
                }
                if (measureEvent == null) break;
                measureEvent.setOperation(AuditInstanceOperation.MEASUREMENT_START_STOP);
                break;
            }
        }
        BPELExecutionLogger.debug((String)logClassName, (String)"createMeasureEventForFlow", (Object)"END");
        return measureEvent;
    }

    private BPMNAuditEvent createMeasureEventForGateway(MicroInstructionContext context, Measurement measurement, String sourceId) throws Exception {
        String logMethodName = "createMeasureEventForGateway";
        BPELExecutionLogger.debug((String)logClassName, (String)"createMeasureEventForGateway", (Object)"BEGIN");
        BPMNAuditEvent measureEvent = null;
        Gateway gw = (Gateway)this.mdAuditLog.getFlowElement();
        String nodeId = gw.getId();
        switch (measurement.getMeasurementType()) {
            case START: {
                if (this.mdAuditLog.isEntryPoint()) {
                    measureEvent = this.createGatewayMeasureEvent(context, measurement, sourceId, nodeId, true);
                }
                if (measureEvent == null) break;
                measureEvent.setOperation(AuditInstanceOperation.MEASUREMENT_START);
                break;
            }
            case STOP: {
                if (!this.mdAuditLog.isEntryPoint()) {
                    measureEvent = this.createGatewayMeasureEvent(context, measurement, sourceId, nodeId, false);
                }
                if (measureEvent == null) break;
                measureEvent.setOperation(AuditInstanceOperation.MEASUREMENT_STOP);
                measureEvent.setReferenceId(measurement.getRelatedMeasurement().getName());
                break;
            }
            case START_STOP: {
                if (!this.mdAuditLog.isEntryPoint()) {
                    measureEvent = this.createGatewayMeasureEvent(context, measurement, sourceId, nodeId, false);
                }
                if (measureEvent == null) break;
                measureEvent.setOperation(AuditInstanceOperation.MEASUREMENT_START_STOP);
                break;
            }
        }
        BPELExecutionLogger.debug((String)logClassName, (String)"createMeasureEventForGateway", (Object)"END");
        return measureEvent;
    }

    private BPMNAuditEvent createFlowMeasureEvent(MicroInstructionContext context, SequenceFlowInfo sequenceFlowInfo, Measurement measurement, String sourceId, String nodeId) throws Exception {
        String logMethodName = "createFlowMeasureEvent";
        BPMNAuditEvent measureEvent = null;
        String flowId = null;
        if (sequenceFlowInfo != null) {
            flowId = sequenceFlowInfo.getId();
            if (measurement.getTransition().getId().equals(flowId)) {
                measureEvent = this.createAuditEvent(context, true);
            } else {
                BPELExecutionLogger.debug((String)logClassName, (String)"createFlowMeasureEvent", (Object)("The {" + measurement.getMeasurementType().toString() + "} mark {" + measurement.getId() + "} is not on the current sequence flow. This will not be processed"));
            }
        } else {
            BPELExecutionLogger.debug((String)logClassName, (String)"createFlowMeasureEvent", (Object)("FLOWNODE Testing for SOURCE {" + measurement.getTransition().getSource().getId() + " == " + sourceId + "} TARGET {" + measurement.getTransition().getTarget().getId() + " == " + nodeId + "}"));
            if (measurement.getTransition().getSource().getId().equals(sourceId) && measurement.getTransition().getTarget().getId().equals(nodeId)) {
                measureEvent = this.createAuditEvent(context, true);
            } else {
                BPELExecutionLogger.debug((String)logClassName, (String)"createFlowMeasureEvent", (Object)("The sequence flow for this node is null. This {" + measurement.getMeasurementType().toString() + "} measurement {" + measurement.getId() + "} will not be processed. Expected Sequence flow From {" + sourceId + "} to {" + nodeId + "} Measurement - {" + measurement.getTransition().getSource().getId() + "} to {" + measurement.getTransition().getTarget().getId() + "}"));
            }
        }
        return measureEvent;
    }

    private BPMNAuditEvent createGatewayMeasureEvent(MicroInstructionContext context, Measurement measurement, String sourceId, String nodeId, boolean isEntry) throws Exception {
        String logMethodName = "createGatewayMeasureEvent";
        BPELExecutionLogger.debug((String)logClassName, (String)"createGatewayMeasureEvent", (Object)"BEGIN");
        BPMNAuditEvent measureEvent = null;
        Map<String, HashMap<String, Object>> generatedTokenMap = this.getGeneratedTokensMetadata(context);
        BPELExecutionLogger.debug((String)logClassName, (String)"createGatewayMeasureEvent", (Object)("Generate measurement for Node id = " + nodeId + " source id " + sourceId));
        if (isEntry) {
            BPELExecutionLogger.debug((String)logClassName, (String)"createGatewayMeasureEvent", (Object)("PREAUDIT Testing for SOURCE {" + measurement.getTransition().getSource().getId() + " == " + sourceId + "} TARGET {" + measurement.getTransition().getTarget().getId() + " == " + nodeId + "}"));
            if (measurement.getTransition().getSource().getId().equals(sourceId) && measurement.getTransition().getTarget().getId().equals(nodeId)) {
                measureEvent = this.createAuditEvent(context, true);
                measureEvent.setSourceActivity(measurement.getTransition().getSource().getId());
                measureEvent.setTargetActivity(measurement.getTransition().getTarget().getId());
            } else {
                BPELExecutionLogger.debug((String)logClassName, (String)"createGatewayMeasureEvent", (Object)("Not generating measurement as transition source id " + measurement.getTransition().getSource().getId() + " doesn't match with Node id = " + nodeId + " source id " + sourceId));
            }
        } else {
            BPELExecutionLogger.debug((String)logClassName, (String)"createGatewayMeasureEvent", (Object)("POSTAUDIT Testing for SOURCE {" + measurement.getTransition().getSource().getId() + " == " + nodeId + "} TARGET {" + measurement.getTransition().getTarget().getId() + " is in generatedTokenMap " + generatedTokenMap.containsKey(measurement.getTransition().getTarget().getId()) + "}"));
            if (measurement.getTransition().getSource().getId().equals(nodeId) && generatedTokenMap.containsKey(measurement.getTransition().getTarget().getId())) {
                measureEvent = this.createAuditEvent(context, true);
                measureEvent.setSourceActivity(measurement.getTransition().getSource().getId());
                measureEvent.setTargetActivity(measurement.getTransition().getTarget().getId());
            } else {
                BPELExecutionLogger.debug((String)logClassName, (String)"createGatewayMeasureEvent", (Object)("Not generating measurement as transition source id " + measurement.getTransition().getSource().getId() + " doesn't match with Node id = " + nodeId + " source id " + sourceId));
            }
        }
        BPELExecutionLogger.debug((String)logClassName, (String)"createGatewayMeasureEvent", (Object)"END");
        return measureEvent;
    }

    private void handleBusinessIndicators(MicroInstructionContext context, BPMNAuditEvent event, boolean isArtifact) throws CubeException {
        String logMethodName = "handleBusinessIndicators";
        Process proc = this.mdAuditLog.getFlowElement().getProcess();
        if (proc != null) {
            Collection vars = proc.getProject().getProjectDataObjects();
            for (ProjectDataObject var : vars) {
                if (!var.isBusiness()) continue;
                BusinessVariableType varType = var.getBusinessVariableType();
                BPELExecutionLogger.debug((String)logClassName, (String)"handleBusinessIndicators", (Object)("Business variable {" + var.getId() + "} Name {" + var.getDefaultLabel() + " - " + var.getName() + "} Type {" + varType.toString().substring(0, 1) + "} Raw class {" + var.getRawClass().getName() + "} Storage Type {" + var.getType().getName() + "} isArtifact {" + isArtifact + "}"));
                String name = var.getName();
                AuditUtil.setAuditVariableValue(context.getScope(), this.mdAuditLog.getAuditVariableMetadata(), event, name);
                if (varType != BusinessVariableType.DIMENSION && (isArtifact || varType != BusinessVariableType.MEASURE)) continue;
                BPELExecutionLogger.debug((String)logClassName, (String)"handleBusinessIndicators", (Object)("Associating business indicator {" + name + "} of type {" + varType.toString() + "}"));
                event.addAssociatedVariable(name);
            }
        } else {
            BPELExecutionLogger.debug((String)logClassName, (String)"handleBusinessIndicators", (Object)"Project is null");
        }
    }

    private IElementContext getElementContext(MicroInstructionContext context) {
        ICubeInstance cInstance = context.getCubeInstance();
        BpmnType flowObjectSubType = this.mdAuditLog.getFlowElement().getBpmnType();
        IElementContext eCtx = MeasurementUtil.getElementContext((String)cInstance.getComponentDN().getCompositeDN(), (String)cInstance.getComponentDN().getComponentName(), (String)flowObjectSubType.toString(), (String)this.mdAuditLog.getAuditInstanceOperation().toString(), (String)(this.mdAuditLog.isEntryPoint() ? EAuditInstanceType.START.toString() : EAuditInstanceType.END.toString()), (String)this.mdAuditLog.getFlowElement().getId());
        return eCtx;
    }

    private void handleAuditDetail(MicroInstructionContext context, FlowNode element, BPMNAuditEvent event, boolean canLog, boolean isArtifact) throws Exception {
        String logMethodName = "handleAuditDetail";
        if (canLog) {
            BPELExecutionLogger.debug((String)logClassName, (String)"handleAuditDetail", (Object)("Able to record detail - isArtifact {" + isArtifact + "}"));
            if (element instanceof OutputDataAssociationEnabled) {
                OutputDataAssociationEnabled activity = (OutputDataAssociationEnabled)element;
                DataAssociationSet dataSet = activity.getOutputDataAssociationSet();
                if (dataSet != null) {
                    this.processOutDataAssociations(context.getScope(), event, dataSet);
                }
                if (isArtifact) {
                    for (Map.Entry<String, IAuditVariable> entry : event.getVariables().entrySet()) {
                        BPELExecutionLogger.debug((String)logClassName, (String)"handleAuditDetail", (Object)("Adding Business Indicator {" + entry.getKey() + "}"));
                        event.addAuditPayloadElement(entry.getValue());
                    }
                }
            } else if (isArtifact) {
                for (Map.Entry<String, IAuditVariable> entry : event.getVariables().entrySet()) {
                    BPELExecutionLogger.debug((String)logClassName, (String)"handleAuditDetail", (Object)("Adding Business Indicator {" + entry.getKey() + "}"));
                    event.addAuditPayloadElement(entry.getValue());
                }
            } else {
                BPELExecutionLogger.debug((String)logClassName, (String)"handleAuditDetail", (Object)"No payload to record as Audit Detail");
            }
            if (this.mdAuditLog.getLoopCountAttr() != null) {
                this.putVariableToPayload(event, LOOP_COUNT_NAME, event.getLoopCount());
            }
            if (this.mdAuditLog.getInstanceCountAttr() != null) {
                this.putVariableToPayload(event, INSTANCE_COUNT_NAME, event.getInstanceCount());
            }
            if (context.getLastException() != null) {
                this.putVariableToPayload(event, FAULT_MESSAGE, context.getLastException().toString());
            }
        } else {
            BPELExecutionLogger.debug((String)logClassName, (String)"handleAuditDetail", (Object)"Audit Detail will only be created for asynchronous activities. Check the Audit Log Level if finer grained logging is required ");
        }
    }

    private void processOutDataAssociations(IScope scope, BPMNAuditEvent event, DataAssociationSet dataSet) throws CubeException {
        String logMethodName = "processOutDataAssociations";
        Sequence dataAssociations = dataSet.getDataAssociations();
        if (dataAssociations != null && !dataAssociations.isEmpty()) {
            for (DataAssociation association : dataAssociations) {
                DataAssociationItem targetItem = association.getTarget();
                if (targetItem.getRefs().isEmpty()) continue;
                String name = ((DataAssociationItemRef)targetItem.getDataAssociationItemRefs().iterator().next()).getRef();
                Object value = DataHandlingUtils.getVariableValue(name, scope);
                this.putVariableToPayload(event, name, value);
            }
        }
    }

    private void resolveParticipant(FlowNode element, BPMNAuditEvent event, MicroInstructionContext context) throws CubeException {
        String logMethodName = "resolveParticipant";
        Lane lane = element.getLane();
        Role role = null;
        if (lane != null) {
            role = BPMNUtility.getRole(lane);
        }
        if (lane != null && role != null) {
            event.setRoleId(role.getId());
            if (element.getBpmnType().isActivity() && event.getActivityName().equals("USER_TASK")) {
                if (this.mdAuditLog.isEntryPoint()) {
                    BPELExecutionLogger.debug((String)logClassName, (String)"resolveParticipant", (Object)"Processing the pre-audit USER_TASK performer");
                    List<Participant> participants = null;
                    if (role != null) {
                        Participant participant;
                        try {
                            participants = DeploymentDescriptorUtil.getParticipantsForProcessRole(event.getCompositeDn(), role.getId(), null);
                        }
                        catch (Exception e) {
                            BPELExecutionLogger.debug((String)logClassName, (String)"resolveParticipant", (Object)"Unable to obtain the participant detail");
                            event.setParticipant(null);
                        }
                        if (participants != null && participants.size() > 0 && (participant = participants.get(0)).getValue() != null) {
                            String participantType = null;
                            switch (((PrincipleRefType)participant.getValue()).getType()) {
                                case USER: {
                                    participantType = "user";
                                    break;
                                }
                                case GROUP: {
                                    participantType = "group";
                                    break;
                                }
                                case APPROLE: {
                                    participantType = "application_role";
                                    break;
                                }
                            }
                            if (participant.getValue() != null) {
                                event.setParticipant(((PrincipleRefType)participant.getValue()).getName() + "," + participantType);
                            }
                        }
                    }
                } else {
                    BPELExecutionLogger.debug((String)logClassName, (String)"resolveParticipant", (Object)"Processing the post-audit USER_TASK performer");
                    String updatedBy = (String)context.getCubeContext().removeFromEnvironment("USER_TASK_UPDATED_BY");
                    event.setParticipant(updatedBy);
                }
            }
        }
    }

    private void handleException(MicroInstructionContext context, IWorkItem iWorkItem, BPMNAuditEvent event) {
        Throwable lastException = context.getLastException();
        if (lastException != null) {
            if (lastException instanceof BPELFault) {
                BPELFault bpelFault = (BPELFault)lastException;
                BPELExecutionLogger.error((Object)("BPELFault {" + String.valueOf(bpelFault.getFaultName()) + "} current Operation {" + event.getOperation() + "}"));
                if (bpelFault.getFaultName().getNamespaceURI().equals("http://schemas.oracle.com/bpel/extension")) {
                    this.setSystemFaultDetail(event, String.valueOf(bpelFault.getFaultName()));
                } else if (iWorkItem != null) {
                    this.setBusinessFaultDetail(event, iWorkItem.getFaultName(), iWorkItem.isPendingRecovery());
                } else {
                    this.setBusinessFaultDetail(event, String.valueOf(bpelFault.getFaultName()), true);
                }
            } else {
                this.setSystemFaultDetail(event, lastException.getMessage());
            }
        } else if (iWorkItem != null && iWorkItem.getFaultName() != null) {
            BPELExecutionLogger.error((Object)("Business Fault {" + iWorkItem.getFaultName() + "} Current Operation {" + event.getOperation() + "}"));
            this.setBusinessFaultDetail(event, iWorkItem.getFaultName(), iWorkItem.isPendingRecovery());
        }
    }

    private void setSystemFaultDetail(BPMNAuditEvent event, String message) {
        event.setOperation(AuditInstanceOperation.INSTANCE_SYSTEM_FAULT);
        event.setFaultIsrecoverable(false);
        event.setFaultType(message);
    }

    private void setBusinessFaultDetail(BPMNAuditEvent event, String message, boolean recoverable) {
        event.setOperation(AuditInstanceOperation.INSTANCE_FAULT);
        event.setFaultIsrecoverable(recoverable);
        event.setFaultType(message);
    }

    private void putVariableToPayload(BPMNAuditEvent event, String name, Object value) {
        String logMethodName = "putVariableToPayload";
        IAuditVariable var = null;
        var = event.getVariable(name);
        if (var == null) {
            var = AuditUtil.createNewAuditVariable();
            var.setName(name);
            var.setValue(value);
        }
        BPELExecutionLogger.debug((String)logClassName, (String)"putVariableToPayload", (Object)("Adding the variable {" + name + "} to the audit log detail"));
        event.addAuditPayloadElement(var);
    }

    private Map<String, HashMap<String, Object>> getGeneratedTokensMetadata(MicroInstructionContext context) {
        return context.getGeneratedTokensMetadata();
    }

    static {
        sAsyncTypes.add(BpmnType.USER_TASK);
        sAsyncTypes.add(BpmnType.SERVICE_TASK);
        sAsyncTypes.add(BpmnType.RECEIVE_TASK);
        sAsyncTypes.add(BpmnType.SEND_TASK);
        sAsyncTypes.add(BpmnType.THROW_INTERMEDIATE_EVENT);
        sAsyncTypes.add(BpmnType.CATCH_INTERMEDIATE_EVENT);
    }

    private static enum EAuditInstanceType {
        START,
        END;

    }
}

