/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.util.ThreadCountManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.AbstractMicroInstruction;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.ExclusiveGatewayMicroInstructionMetadata;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.SequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenManager;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.bpmn.engine.runtime.features.SequenceFlowToEndActivityFearure;
import oracle.bpm.project.model.processes.FlowNode;

public class ExclusiveGatewayMicroInstruction
extends AbstractMicroInstruction<ExclusiveGatewayMicroInstructionMetadata> {
    public ExclusiveGatewayMicroInstruction(ExclusiveGatewayMicroInstructionMetadata metadata) {
        super(metadata);
    }

    @Override
    protected void doExecute(MicroInstructionContext context) throws CubeException {
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"doExecute", (Object)"Start of executing exclusive gateway ");
        IWorkItem iWorkItem = context.getWorkItem();
        this.generateNextTokens(context);
        iWorkItem.markAsComplete();
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"doExecute", (Object)"End of executing exclusive gateway ");
    }

    private boolean isActivationIdExist(IScope scope, FlowNode gNode, String activationId) {
        String flowKey = scope.getAbsoluteScopeId() + "." + gNode.getId() + "." + activationId;
        return scope.contains(flowKey);
    }

    private String getActivationId(MicroInstructionContext context, SequenceFlowInfo sequenceFlow, String activationId, int thread, int parentThread, int step) throws CubeException {
        FlowNode gatewayNode = ((ExclusiveGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getFlowElement();
        String activationIdAfterRemove = activationId;
        if (BPMNUtility.isSequenceFlowGoesToEnd(sequenceFlow, gatewayNode)) {
            SequenceFlowToEndActivityFearure feature = (SequenceFlowToEndActivityFearure)gatewayNode.getFeature(SequenceFlowToEndActivityFearure.class);
            String[] activationIds = activationId.split(",");
            ArrayList<String> removeIds = new ArrayList<String>();
            if (feature != null) {
                int i;
                List info = feature.getValue();
                IWorkItem iWorkItem = context.getWorkItem();
                IScope iScope = iWorkItem.getScope();
                boolean tokenGenerated = false;
                for (i = 0; i < activationIds.length; ++i) {
                    String gActivationId = activationIds[i];
                    for (int j = info.size() - 1; j >= 0; --j) {
                        FlowNode gNode = ((SequenceFlowToEndActivityFearure.EndActivityFlowInfo)info.get(j)).getMergeGatewayNode();
                        if (!this.isActivationIdExist(iScope, gNode, gActivationId)) continue;
                        removeIds.add(gActivationId);
                        if (tokenGenerated) continue;
                        HashMap<String, Object> extraMetadata = new HashMap<String, Object>();
                        extraMetadata.put("DUMMY_TOKEN_FOR_MERGING_GATEWAY", true);
                        extraMetadata.put("PARENT_THREAD", parentThread);
                        HashMap<String, Object> generatedTokenMetadata = BPMNTokenManager.generateOpenToken(iScope, ((ExclusiveGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getCubeElement(), gNode.getId(), activationId, parentThread, thread, step + 1, extraMetadata);
                        context.addGeneratedTokenMetadata(gNode.getId(), generatedTokenMetadata);
                        tokenGenerated = true;
                    }
                }
                if (removeIds.size() != 0) {
                    activationIdAfterRemove = "";
                    for (i = 0; i < activationIds.length; ++i) {
                        if (removeIds.contains(activationIds[i])) continue;
                        activationIdAfterRemove = activationIdAfterRemove.equals("") ? activationIds[i] : activationIdAfterRemove + "," + activationIds[i];
                    }
                }
            }
        }
        return activationIdAfterRemove;
    }

    private void generateNextTokens(MicroInstructionContext context) throws CubeException {
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"generateNextTokens", (Object)"Start of generating the next token");
        IWorkItem iWorkItem = context.getWorkItem();
        ICubeContext iCubeContext = context.getCubeContext();
        IScope iScope = iWorkItem.getScope();
        int intThread = BPMNTokenMetadataUtils.getThreadFromTokenMetadata(iWorkItem.getNodeActivationContext());
        int parentThread = BPMNTokenMetadataUtils.getParentThreadFromTokenMetadata(iWorkItem.getNodeActivationContext());
        int intStep = BPMNTokenMetadataUtils.getStepFromTokenMetadata(iWorkItem.getNodeActivationContext());
        ++intStep;
        String activationId = BPMNTokenMetadataUtils.getActivationIdsFromTokenMetadata(iWorkItem.getNodeActivationContext());
        if (activationId == null) {
            activationId = "";
        }
        String nextToken = null;
        String nextActivityId = null;
        for (SequenceFlowInfo sequenceFlowInfo : ((ExclusiveGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getGatewaySequenceFlowMetadata().getOutgoingSequenceFlows()) {
            boolean result = sequenceFlowInfo.getConditionEvaluator().evaluate(((ExclusiveGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getFlowElement(), iScope, iCubeContext, iWorkItem);
            BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"generateNextTokens", (Object)(" Result for sequenceFlowInfo = " + sequenceFlowInfo.getId() + "  result = " + result));
            if (!result) continue;
            nextToken = sequenceFlowInfo.getTargetNodeId();
            nextActivityId = sequenceFlowInfo.getTargetActivityId();
            activationId = this.getActivationId(context, sequenceFlowInfo, activationId, intThread, parentThread, intStep);
            break;
        }
        HashMap<String, Object> generatedTokenMetadata = null;
        if (nextToken != null) {
            generatedTokenMetadata = BPMNTokenManager.generateOpenToken(iScope, ((ExclusiveGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getCubeElement(), nextToken, activationId, parentThread, intThread, intStep);
        } else {
            SequenceFlowInfo unconditionalSequenceFlowInfo = ((ExclusiveGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getGatewaySequenceFlowMetadata().getDefaultOutgoingSequenceFlow();
            if (unconditionalSequenceFlowInfo != null) {
                nextToken = unconditionalSequenceFlowInfo.getTargetNodeId();
                nextActivityId = unconditionalSequenceFlowInfo.getTargetActivityId();
                activationId = this.getActivationId(context, unconditionalSequenceFlowInfo, activationId, intThread, parentThread, intStep);
                BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"generateNextTokens", (Object)"Evaluating the default sequence flow ");
                if (nextToken.equals(context.getWorkItem().getCubeNode().getParentBlockId())) {
                    ThreadCountManager.decreaseThreadCount((IScope)context.getWorkItem().getScope());
                    HashMap tokenMetadata = context.getWorkItem().getNodeActivationContext();
                    BPMNTokenMetadataUtils.setStepToTokenMetadata(tokenMetadata, context.getStep());
                    context.getWorkItem().getScope().declareAndSet("EXIT_TOKEN_METADATA", (Object)tokenMetadata);
                } else {
                    generatedTokenMetadata = BPMNTokenManager.generateOpenToken(iScope, ((ExclusiveGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getCubeElement(), nextToken, activationId, parentThread, intThread, intStep);
                }
            } else {
                throw new CubeException(75000, BPMNUtility.getObjects(iWorkItem.getCubeInstance(), ((ExclusiveGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getFlowElement()));
            }
        }
        if (generatedTokenMetadata != null) {
            context.addGeneratedTokenMetadata(nextActivityId, generatedTokenMetadata);
        }
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"generateNextTokens", (Object)"End of generating the next token");
    }
}

