/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime.microinstructions;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.util.ThreadCountManager;
import java.util.HashMap;
import java.util.SortedSet;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.AbstractMicroInstruction;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.AbstractPairingGatewayMicroInstructionMetadata;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.SequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenManager;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.project.model.processes.Gateway;

public abstract class AbstractPairingGatewayMicroInstruction
extends AbstractMicroInstruction<AbstractPairingGatewayMicroInstructionMetadata> {
    public AbstractPairingGatewayMicroInstruction(AbstractPairingGatewayMicroInstructionMetadata metadata) {
        super(metadata);
    }

    @Override
    protected void doExecute(MicroInstructionContext context) throws CubeException {
        IWorkItem iWorkItem = context.getWorkItem();
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"doExecuteStatements", (Object)"start");
        this.generateNextTokens(context);
        iWorkItem.markAsComplete();
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"doExecuteStatements", (Object)"end");
    }

    protected void _bindProcessDataObjects(MicroInstructionContext context) throws CubeException {
    }

    protected void setThreadStepForMergeGateway(IScope scope, IWorkItem item, String activationId) throws CubeException {
        String mGatewayId = ((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getMergingGateway().getId();
        HashMap nodeActivationContext = item.getNodeActivationContext();
        int step = BPMNTokenMetadataUtils.getStepFromTokenMetadata(nodeActivationContext);
        int thread = BPMNTokenMetadataUtils.getThreadFromTokenMetadata(nodeActivationContext);
        int parentThread = BPMNTokenMetadataUtils.getParentThreadFromTokenMetadata(nodeActivationContext);
        String stepKey = BPMNTokenMetadataUtils.getMergeGatewayStepKey(mGatewayId, activationId);
        scope.declareAndSet(stepKey, ++step);
        String threadKey = BPMNTokenMetadataUtils.getMergeGatewayThreadey(mGatewayId, activationId);
        scope.declareAndSet(threadKey, thread);
        String parentThreadKey = BPMNTokenMetadataUtils.getMergeGatewayParentThreadey(mGatewayId, activationId);
        scope.declareAndSet(parentThreadKey, parentThread);
    }

    protected String getOutgoingActivationId(SequenceFlowInfo sequenceFlow, int[] flows, String activationIds, String newActivationId) {
        String activatioIdwithNewId = null;
        int flow = flows[0];
        if (!BPMNUtility.isSequenceFlowGoesToEnd(sequenceFlow, ((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getFlowElement())) {
            ++flow;
            if (activationIds == null || activationIds.equals("")) {
                activatioIdwithNewId = newActivationId;
            } else {
                activatioIdwithNewId = activationIds;
                if (!newActivationId.equals("")) {
                    activatioIdwithNewId = newActivationId + "," + activatioIdwithNewId;
                }
            }
        } else {
            activatioIdwithNewId = activationIds == null ? "" : activationIds;
        }
        flows[0] = flow;
        return activatioIdwithNewId;
    }

    protected int _generateToken(MicroInstructionContext context, String newActivationId, String activationIds, int parentThread, int intThread, int intStep) throws CubeException {
        IWorkItem wi = context.getWorkItem();
        IScope scope = wi.getScope();
        SortedSet<SequenceFlowInfo> sequence = ((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getGatewaySequenceFlowMetadata().getOutgoingSequenceFlows();
        int[] flows = new int[]{0};
        for (SequenceFlowInfo sequenceFlow : sequence) {
            HashMap<String, Object> generatedTokenMetadata;
            String activatioIdwithNewId = this.getOutgoingActivationId(sequenceFlow, flows, activationIds, newActivationId);
            String targetId = sequenceFlow.getTargetNodeId();
            BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"_generateToken", (Object)(" Creating token for " + targetId + " with activation id " + activationIds));
            if (((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).isForkingGateway()) {
                ThreadCountManager.increaseThreadCount((IScope)scope);
                generatedTokenMetadata = BPMNTokenManager.generateOpenToken(scope, ((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getCubeElement(), targetId, activatioIdwithNewId, intThread, BPMNTokenMetadataUtils.getNewThreadNumber(scope), 0);
            } else {
                generatedTokenMetadata = BPMNTokenManager.generateOpenToken(scope, ((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getCubeElement(), targetId, activatioIdwithNewId, parentThread, intThread, intStep);
            }
            context.addGeneratedTokenMetadata(sequenceFlow.getTargetActivityId(), generatedTokenMetadata);
        }
        return flows[0];
    }

    private void generateNextTokens(MicroInstructionContext context) throws CubeException {
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"generateNextTokens", (Object)"start");
        IWorkItem wi = context.getWorkItem();
        IScope scope = wi.getScope();
        ICubeContext iCubeContext = context.getCubeContext();
        String activationIds = BPMNTokenMetadataUtils.getActivationIdsFromTokenMetadata(wi.getNodeActivationContext());
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"generateNextTokens", (Object)("Generating token from parallel gatewway with " + activationIds));
        String newActivationId = null;
        int intThread = BPMNTokenMetadataUtils.getThreadFromTokenMetadata(wi.getNodeActivationContext());
        int parentThread = BPMNTokenMetadataUtils.getParentThreadFromTokenMetadata(wi.getNodeActivationContext());
        int intStep = BPMNTokenMetadataUtils.getStepFromTokenMetadata(wi.getNodeActivationContext());
        newActivationId = ((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).isForkingGateway() ? BPMNTokenMetadataUtils.getUniqueActivationId(scope) : "";
        this._bindProcessDataObjects(context);
        int flows = this._generateToken(context, newActivationId, activationIds, parentThread, intThread, ++intStep);
        Gateway mGateway = ((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).getMergingGateway();
        if (mGateway != null && ((AbstractPairingGatewayMicroInstructionMetadata)this.getMicroInstructionMetadata()).isForkingGateway()) {
            String flowKey = scope.getAbsoluteScopeId() + "." + mGateway.getId() + "." + newActivationId;
            scope.declareAndSet(flowKey, (Object)Integer.toString(flows));
            this.setThreadStepForMergeGateway(scope, wi, newActivationId);
        }
    }
}

