/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.types.bpel.CXElementVariable;
import com.collaxa.cube.xml.dom.DOMUtil;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.model.runtime.CharacteristicsRuntimeHelper;
import oracle.bpm.bpmn.engine.model.runtime.InstanceAttributeSupport;
import oracle.bpm.bpmn.engine.runtime.BPMNExpression;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionDataElementContextType;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionLanguage;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionMetadata;
import oracle.bpm.bpmn.engine.runtime.InstanceAttributeType;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.PredefinedVariablesHelper;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.InputDataAssociationEnabled;
import oracle.bpm.project.model.processes.MultiInstance;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MultiInstanceRuntimeHelper
extends CharacteristicsRuntimeHelper<MultiInstance> {
    private InstanceAttributeSupport<Boolean> completionConditionInstanceAttribute;
    private InstanceAttributeSupport<CXElementVariable> inputDataItemInstanceAttribute;
    private InstanceAttributeSupport<Integer> loopCounterInstanceAttribute;
    private InstanceAttributeSupport<CXElementVariable> loopDataInputInstanceAttribute;
    private InstanceAttributeSupport<CXElementVariable> loopDataOutputInstanceAttribute;
    private InstanceAttributeSupport<Integer> numberOfActiveInstancesInstanceAttribute;
    private InstanceAttributeSupport<Integer> numberOfCompletedInstancesInstanceAttribute;
    private InstanceAttributeSupport<Integer> numberOfInstancesInstanceAttribute;
    private InstanceAttributeSupport<Integer> numberOfTerminatedInstancesInstanceAttribute;
    private InstanceAttributeSupport<CXElementVariable> outputDataItemInstanceAttribute;
    public static final QName COMPLETIONCONDITIONSIGNAL = new QName("http://www.omg.org/bpmn20/runtime", "completionConditionSignal");

    public MultiInstanceRuntimeHelper(FlowNode flowNode, MultiInstance characteristics) {
        super(flowNode, characteristics);
        this.loopCounterInstanceAttribute = new InstanceAttributeSupport(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, (FlowElement)flowNode, PredefinedVariablesHelper.LOOP_COUNTER);
        this.numberOfInstancesInstanceAttribute = new InstanceAttributeSupport(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, (FlowElement)flowNode, PredefinedVariablesHelper.NUMBER_OF_INSTANCES);
        this.numberOfActiveInstancesInstanceAttribute = new InstanceAttributeSupport(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, (FlowElement)flowNode, PredefinedVariablesHelper.NUMBER_OF_ACTIVE_INSTANCES);
        this.numberOfCompletedInstancesInstanceAttribute = new InstanceAttributeSupport(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, (FlowElement)flowNode, PredefinedVariablesHelper.NUMBER_OF_COMPLETED_INSTANCES);
        this.numberOfTerminatedInstancesInstanceAttribute = new InstanceAttributeSupport(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, (FlowElement)flowNode, PredefinedVariablesHelper.NUMBER_OF_TERMINATED_INSTANCES);
        this.inputDataItemInstanceAttribute = new InstanceAttributeSupport(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, (FlowElement)flowNode, PredefinedVariablesHelper.INPUT_DATAITEM);
        this.outputDataItemInstanceAttribute = new InstanceAttributeSupport(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, (FlowElement)flowNode, PredefinedVariablesHelper.OUTPUT_DATAITEM);
        this.loopDataInputInstanceAttribute = new InstanceAttributeSupport(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, (FlowElement)flowNode, PredefinedVariablesHelper.LOOP_DATAINPUT);
        this.loopDataOutputInstanceAttribute = new InstanceAttributeSupport(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, (FlowElement)flowNode, PredefinedVariablesHelper.LOOP_DATAOUTPUT);
        this.completionConditionInstanceAttribute = new InstanceAttributeSupport(InstanceAttributeType.ACTIVITY_INSTANCE_ATTRIBUTE, (FlowElement)flowNode, PredefinedVariablesHelper.COMPLETION_CONDITION);
    }

    public boolean isSequential() {
        return ((MultiInstance)this.getCharacteristics()).isSequential();
    }

    public boolean isParallel() {
        return !this.isSequential();
    }

    public InstanceAttributeSupport<Integer> getLoopCounterInstanceAttribute() {
        return this.loopCounterInstanceAttribute;
    }

    public InstanceAttributeSupport<Integer> getNumberOfInstancesInstanceAttribute() {
        return this.numberOfInstancesInstanceAttribute;
    }

    public InstanceAttributeSupport<Integer> getNumberOfActiveInstancesInstanceAttribute() {
        return this.numberOfActiveInstancesInstanceAttribute;
    }

    public InstanceAttributeSupport<Integer> getNumberOfCompletedInstancesInstanceAttribute() {
        return this.numberOfCompletedInstancesInstanceAttribute;
    }

    public InstanceAttributeSupport<Integer> getNumberOfTerminatedInstancesInstanceAttribute() {
        return this.numberOfTerminatedInstancesInstanceAttribute;
    }

    public InstanceAttributeSupport<CXElementVariable> getInputDataItemInstanceAttribute() {
        return this.inputDataItemInstanceAttribute;
    }

    public InstanceAttributeSupport<CXElementVariable> getOutputDataItemInstanceAttribute() {
        return this.outputDataItemInstanceAttribute;
    }

    public InstanceAttributeSupport<CXElementVariable> getLoopDataInputInstanceAttribute() {
        return this.loopDataInputInstanceAttribute;
    }

    public InstanceAttributeSupport<CXElementVariable> getLoopDataOutputInstanceAttribute() {
        return this.loopDataOutputInstanceAttribute;
    }

    public InstanceAttributeSupport<Boolean> getCompletionConditionInstanceAttribute() {
        return this.completionConditionInstanceAttribute;
    }

    public int evaluateLoopCardinality(IScope iScope, ICubeContext iCubeContext) throws CubeException {
        Expression loopCardinalityExpression = ((MultiInstance)this.getCharacteristics()).getLoopCardinality();
        BPMNExpressionMetadata bpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, null, loopCardinalityExpression.getExpressionValue(), BPMNExpressionLanguage.XPATH, loopCardinalityExpression.getNamespaces());
        BPMNExpression bpmnExpression = BPMNExpression.createBPMNExpression(this.getFlowNode(), bpmnExpressionMetadata, iScope);
        Number number = bpmnExpression.evaluateNumber(iScope, iCubeContext);
        return number.intValue();
    }

    public boolean evaluateCompletionCondition(IScope iScope, ICubeContext iCubeContext) throws CubeException {
        Expression completionCondition = ((MultiInstance)this.getCharacteristics()).getCompletionCondition();
        BPMNExpressionMetadata bpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, null, completionCondition.getExpressionValue(), BPMNExpressionLanguage.XPATH, completionCondition.getNamespaces());
        BPMNExpression bpmnExpression = BPMNExpression.createBPMNExpression(this.getFlowNode(), bpmnExpressionMetadata, iScope);
        return bpmnExpression.evaluateBoolean(iScope, iCubeContext);
    }

    public void declareAndSetLoopDataInput(IScope iScope, ICubeContext iCubeContext) throws CubeException {
        String loopDataInputRef = ((MultiInstance)this.getCharacteristics()).getLoopDataInput().getName();
        if (loopDataInputRef != null) {
            Node loopDataInputValue = null;
            if (this.getFlowNode() instanceof InputDataAssociationEnabled) {
                InputDataAssociationEnabled inputDataAssociationEnabled = (InputDataAssociationEnabled)this.getFlowNode();
                DataAssociationSet dataAssociationSet = inputDataAssociationEnabled.getInputDataAssociationSet();
                Sequence dataAssociations = dataAssociationSet.getDataAssociations();
                for (DataAssociation dataAssociation : dataAssociations) {
                    if (!dataAssociation.getTarget().getRefs().contains((Object)loopDataInputRef)) continue;
                    BPMNExpressionMetadata sourceBpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)dataAssociation.getSource().getRefs(), dataAssociation.getSource().getExpression().getExpressionValue(), BPMNExpressionLanguage.XPATH, dataAssociation.getSource().getExpression().getNamespaces());
                    BPMNExpression sourceBPMNExpression = BPMNExpression.createBPMNExpression(this.getFlowNode(), sourceBpmnExpressionMetadata, iScope);
                    loopDataInputValue = sourceBPMNExpression.evaluateNode(iScope, iCubeContext);
                    break;
                }
            }
            if (loopDataInputValue != null) {
                CXElementVariable loopDataInputElementVariable = new CXElementVariable();
                loopDataInputElementVariable.setName(this.getLoopDataInputInstanceAttribute().getPredefinedVariableElement().getName());
                loopDataInputElementVariable.setValue((Element)loopDataInputValue);
                this.getLoopDataInputInstanceAttribute().declareAndSet(iScope, iCubeContext, loopDataInputElementVariable);
            } else {
                throw new CubeException((Throwable)new IllegalArgumentException("Failed to resolve multi-instance loopDataInput value for activity. " + this.getFlowNode().getName()));
            }
        }
    }

    public void declareAndSetLoopDataOutputValue(IScope iScope, ICubeContext iCubeContext) throws CubeException {
        CXElementVariable loopDataOutputElementVariable = new CXElementVariable();
        loopDataOutputElementVariable.setName(this.getLoopDataOutputInstanceAttribute().getPredefinedVariableElement().getName());
        Integer numberOfInstanceAttribute = this.getNumberOfInstancesInstanceAttribute().getValue(iScope, iCubeContext);
        Element rootElement = DOMUtil.createRootElement((String)"", (String)"");
        if (this.isParallel()) {
            for (int i = 0; i < numberOfInstanceAttribute; ++i) {
                rootElement.appendChild(rootElement.getOwnerDocument().createElement(""));
            }
        }
        loopDataOutputElementVariable.setValue(rootElement);
        this.getLoopDataOutputInstanceAttribute().declareAndSet(iScope, iCubeContext, loopDataOutputElementVariable);
    }

    public void publishDataOutput(IScope iScope, ICubeContext iCubeContext) {
    }
}

