/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IScopeImpl;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.core.map.ICubeNode;
import com.collaxa.cube.engine.ext.bpel.common.wmp.BaseBPELActivityWMP;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.runtime.MIBPMNActivityNode;

public final class MIBPMNActivityWMP
extends BaseBPELActivityWMP {
    private MIBPMNActivityNode node = null;
    private Map<String, Object> runtimeContext = new HashMap<String, Object>();

    public MIBPMNActivityWMP(MIBPMNActivityNode node) {
        this.node = node;
    }

    public void setRuntimeContext(String prop, Object value) {
        this.runtimeContext.put(prop, value);
    }

    public <T> T getRuntimeContext(String prop, Class<T> resultType) {
        return this.getRuntimeContext(prop, resultType, null);
    }

    public <T> T getRuntimeContext(String prop, Class<T> resultType, T defaultValue) {
        Object value = this.runtimeContext.get(prop);
        if (value == null) {
            return defaultValue;
        }
        if (!resultType.isAssignableFrom(value.getClass())) {
            throw new RuntimeException("Can not assign " + value.getClass().getName() + " to " + resultType.getName());
        }
        return resultType.cast(value);
    }

    public MIBPMNActivityNode getBPMNCubeNode() {
        return this.node;
    }

    public ICubeNode getCubeNode() {
        return this.getBPMNCubeNode();
    }

    public void expire(IWorkItem wi, ICubeContext ctx) throws Exception {
        this.executeProcedureControlled(wi, ctx, "EXPIRE", null);
    }

    public void handleCallback(IWorkItem wi, ICubeContext ctx) throws Throwable {
        this.executeProcedure(wi, ctx, "HANDLE_CALLBACK", "HANDLE_CALLBACK_EXCEPTION");
    }

    public IWorkItem manage(IScopeImpl scope, ICubeContext ctx) throws Exception {
        IWorkItem result = super.manage(scope, ctx);
        HashMap nodeActivationContext = (HashMap)ctx.removeFromEnvironment("__node_activation-context");
        if (nodeActivationContext == null) {
            nodeActivationContext = new HashMap();
        }
        result.setNodeActivationContext(nodeActivationContext);
        return result;
    }

    public void cancelPerform(IWorkItem wi, ICubeContext ctx) throws Exception {
        this.executeProcedureControlled(wi, ctx, "CANCEL_PERFORM", null);
    }

    public void throwException(IWorkItem wi, Throwable exception, ICubeContext ctx) throws Exception {
        super.throwException(wi, exception, ctx);
        this.executeProcedureControlled(wi, ctx, "THROW_EXCEPTION", null);
    }

    protected boolean doDefaultObserverNotification() {
        return this.getBPMNCubeNode().getCountActivityEvent();
    }

    protected Date __defineExpirationDate(IWorkItem wi, ICubeContext ctx) throws Exception {
        return (Date)this.executeProcedureControlled(wi, ctx, "DEFINE_EXPIRATION_DATE", null);
    }

    protected void __executeStatements(IWorkItem wi, IScope sc, ICubeContext ctx) throws Throwable {
        super.__executeStatements(wi, sc, ctx);
        this.executeProcedure(wi, ctx, "EXECUTE_STATEMENT", "EXECUTE_STATEMENT_EXCEPTION");
    }

    protected void setOutgoingLinks(boolean b, IScope iScope, ICubeContext iCubeContext) throws CubeException {
    }

    private Object executeProcedure(IWorkItem wi, ICubeContext ctx, String procedure, String procedure_exception) throws Throwable {
        MicroInstructionContext context = this.createMicroInstructionContext(wi, ctx);
        return context.executeProcedure(procedure, procedure_exception);
    }

    private Object executeProcedureControlled(IWorkItem wi, ICubeContext ctx, String procedure, String procedure_exception) throws Exception {
        MicroInstructionContext context = this.createMicroInstructionContext(wi, ctx);
        return context.executeProcedureControlled(procedure, procedure_exception);
    }

    private MicroInstructionContext createMicroInstructionContext(IWorkItem wi, ICubeContext ctx) throws CubeException {
        return new MicroInstructionContext(wi, ctx, (BPMNCubeElement)this.getBPMNCubeNode(), this);
    }
}

