/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkManager;
import com.collaxa.cube.engine.core.IWorkPerformer;
import com.collaxa.cube.engine.ext.bpel.common.BaseBPELCubeNode;
import com.collaxa.cube.engine.util.ThreadCountManager;
import com.collaxa.cube.engine.util.TokenManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.common.SequenceFlowMetadata;
import oracle.bpm.bpmn.engine.model.common.SequenceFlowMetadataSupport;
import oracle.bpm.bpmn.engine.model.runtime.MIBPMNActivityWMP;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenManager;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.util.ArrayUtils;

public class MIBPMNActivityNode<T extends FlowNode>
extends BaseBPELCubeNode
implements BPMNCubeElement<T> {
    private boolean boundaryFlowEndElement = false;
    private boolean countActivityEvent = false;
    private T flowElement;
    private Map<String, IMicroInstruction> microInstructionsMap;
    private SequenceFlowMetadata sequenceFlowMetadata;
    private boolean startOfMainFlow = true;

    public MIBPMNActivityNode(BPMNCubeMapBuilderContext context, String name, T flowElement) {
        this(context, "", name, flowElement.getBpmnType(), flowElement);
    }

    public MIBPMNActivityNode(BPMNCubeMapBuilderContext context, String idSuffix, String name, BpmnType type, T flowElement) {
        super.setId(context.getCubeElementId((FlowNode)flowElement, idSuffix));
        this.setName(name);
        this.setType(type.name());
        this.flowElement = flowElement;
        this.initSequenceFlowMetadata();
        this.microInstructionsMap = new HashMap<String, IMicroInstruction>();
    }

    public final String getId() {
        return super.getId();
    }

    public final void setId(String id) {
        throw new UnsupportedOperationException();
    }

    public final void setCountActivityEvent() {
        this.countActivityEvent = true;
    }

    public boolean getCountActivityEvent() {
        return this.countActivityEvent;
    }

    @Override
    public void addMicroInstruction(String tag, IMicroInstruction mi) {
        this.microInstructionsMap.put(tag, mi);
    }

    @Override
    public IMicroInstruction getMicroInstruction(String tag) {
        return this.microInstructionsMap.get(tag);
    }

    @Override
    public Map<String, IMicroInstruction> getMicroInstructionMap() {
        return Collections.unmodifiableMap(this.microInstructionsMap);
    }

    @Override
    public SequenceFlowMetadata getSequenceFlowMetadata() {
        return this.sequenceFlowMetadata;
    }

    public boolean hasOutgoingSequenceFlows() {
        return this.getSequenceFlowMetadata().getOutgoingSequenceFlow() != null;
    }

    public void init(IWorkManager manager, IWorkPerformer performer) {
        this.mManager = manager;
        this.mPerformer = performer;
    }

    public void init(ICubeContext iCubeContext) throws CubeException {
        MIBPMNActivityWMP wmp = new MIBPMNActivityWMP(this);
        this.init((IWorkManager)wmp, (IWorkPerformer)wmp);
    }

    public void uninit(ICubeContext iCubeContext) throws CubeException {
    }

    @Override
    public T getFlowElement() {
        return this.flowElement;
    }

    public void finalize(IScope scope, ICubeContext ctx) throws Exception {
    }

    public String[] getExitTokens() {
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public void activate(IScope scope, ICubeContext ctx) throws Exception {
        HashMap<String, Object> token = BPMNTokenManager.consumeOpenToken(scope, ctx, this.getId());
        this.processConsumedToken(scope, ctx, token);
    }

    public boolean canActivate(IScope scope, ICubeContext ctx) throws Exception {
        return TokenManager.containsOpenToken((IScope)scope, (String)this.getId());
    }

    @Override
    public boolean isNonMainFlowEndElement() {
        return this.boundaryFlowEndElement;
    }

    @Override
    public void setNonMainFlowEndElement(boolean value) {
        this.boundaryFlowEndElement = value;
    }

    @Override
    public boolean isStartOfMainFlow() {
        return this.startOfMainFlow;
    }

    @Override
    public void setStartOfMainFlow(boolean value) {
        this.startOfMainFlow = value;
    }

    @Deprecated
    public Process getProcess() {
        return this.getFlowElement().getProcess();
    }

    protected String processConsumedToken(IScope scope, ICubeContext ctx, HashMap<String, Object> token) throws CubeException {
        ctx.addToEnvironment("__node_activation-context", token);
        boolean increaseThreadCount = BPMNTokenMetadataUtils.removeIncreaseCountThreadFromTokenMetadata(token);
        if (increaseThreadCount) {
            ThreadCountManager.increaseThreadCount((IScope)scope);
        }
        return BPMNTokenMetadataUtils.getActivationIdsFromTokenMetadata(token);
    }

    private void initSequenceFlowMetadata() {
        this.sequenceFlowMetadata = new SequenceFlowMetadataSupport();
    }
}

