/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime;

import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import java.util.List;
import oracle.bpm.bpmn.engine.model.nodes.AbstractGatewayNode;
import oracle.bpm.bpmn.engine.model.nodes.BaseBPMNActivityNode;
import oracle.bpm.bpmn.engine.model.runtime.BaseBPMNActivityWMP;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.IMicroInstruction;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenManager;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;

public class BaseBPMNGatewayWMP<T extends AbstractGatewayNode>
extends BaseBPMNActivityWMP<T> {
    public BaseBPMNGatewayWMP(T node) {
        super(node);
    }

    @Override
    protected void __executeStatements(IWorkItem wi, IScope sc, ICubeContext ctx) throws Throwable {
        String activationIds = BPMNTokenMetadataUtils.getActivationIdsFromTokenMetadata(wi.getNodeActivationContext());
        String key = BPMNTokenManager.getNodeScopeKey(sc, this.getCubeNode().getId(), "++node-activation-ids");
        ctx.addToEnvironment(key, (Object)activationIds);
        this.doExecuteStatements(wi, sc, ctx);
    }

    @Override
    protected void doExecuteStatements(IWorkItem wi, IScope sc, ICubeContext ctx) throws Throwable {
        List<IMicroInstruction> instructions = ((AbstractGatewayNode)this.getBPMNCubeNode()).getMicroInstructions();
        MicroInstructionContext context = new MicroInstructionContext(wi, ctx, (BaseBPMNActivityNode)this.getBPMNCubeNode());
        for (IMicroInstruction microInstruction : instructions) {
            microInstruction.execute(context);
            context.incrementMicroInstructionStep();
        }
    }
}

