/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.runtime;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextFactory;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.agents.AgentLogger;
import com.collaxa.cube.engine.dispatch.DispatchHelper;
import com.collaxa.cube.engine.dispatch.message.IMessage;
import com.collaxa.cube.engine.dispatch.message.instance.ExpirationMessage;
import com.collaxa.cube.persistence.dto.WorkItemKey;
import oracle.integration.platform.blocks.scheduler.SchedulerJob;
import oracle.integration.platform.blocks.scheduler.StringProperties;
import oracle.soa.management.ComponentDN;

public class BPMNWaitListener
implements SchedulerJob {
    private static final String WIKEY = "BPEL_wikey";
    private static final String PRIORITY = "BPEL_priority";
    public static final String INSTANCE_ID = "BPEL_instanceID";
    public static final String COMPONENT_DN = "BPEL_componentDN";

    public void execute(String compositeDN, String key, StringProperties opaqueProperties) {
        try {
            String wiKeyStr = key;
            WorkItemKey wiKey = new WorkItemKey(wiKeyStr);
            String priorityStr = opaqueProperties.get(PRIORITY);
            int priority = Integer.valueOf(priorityStr);
            String instanceIdStr = opaqueProperties.get(INSTANCE_ID);
            Long instanceId = Long.valueOf(instanceIdStr);
            String debugStr = "WiKey=" + wiKeyStr + ":componentDN=" + opaqueProperties.get(COMPONENT_DN) + ":InstanceID=" + instanceId + ":Priority=" + priority;
            AgentLogger.debug((String)"ExpirationAgent", (String)"Scheduled Job Completed", (Object)debugStr);
            ExpirationMessage em = new ExpirationMessage(new ComponentDN(opaqueProperties.get(COMPONENT_DN)), wiKey, priority, "bpmn");
            ICubeContext ctx = CubeContextFactory.newInstance().create("bpmn");
            DispatchHelper.scheduleLocal((IMessage)em, (ICubeContext)ctx);
        }
        catch (CubeException ce) {
            ce.printStackTrace();
        }
    }
}

