/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.nodes;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.model.nodes.BaseMultiInstanceNode;
import oracle.bpm.bpmn.engine.model.runtime.BaseBPMNActivityWMP;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.MultiInstance;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MultiInstanceInitNode
extends BaseMultiInstanceNode {
    public MultiInstanceInitNode(BPMNCubeMapBuilderContext context, String id, String name, Activity activity, MultiInstance multiInstance) {
        super(context, id, name, activity, multiInstance);
    }

    @Override
    protected BaseBPMNActivityWMP<BaseMultiInstanceNode> createWMP() {
        return new MultiInstanceInitWMP(this);
    }

    private static class MultiInstanceInitWMP
    extends BaseBPMNActivityWMP<BaseMultiInstanceNode> {
        private MultiInstanceInitWMP(MultiInstanceInitNode node) {
            super(node);
        }

        @Override
        protected void doExecuteStatements(IWorkItem iWorkItem, IScope iScope, ICubeContext iCubeContext) throws Throwable {
            int numberOfInstances = -1;
            Expression loopCardinalityExpression = ((MultiInstance)((BaseMultiInstanceNode)this.getBPMNCubeNode()).getRuntimeHelper().getCharacteristics()).getLoopCardinality();
            if (loopCardinalityExpression != null) {
                numberOfInstances = ((BaseMultiInstanceNode)this.getBPMNCubeNode()).getRuntimeHelper().evaluateLoopCardinality(iScope, iCubeContext);
            } else if (((MultiInstance)((BaseMultiInstanceNode)this.getBPMNCubeNode()).getRuntimeHelper().getCharacteristics()).getLoopDataInput() != null) {
                Element loopDataInputValue = ((BaseMultiInstanceNode)this.getBPMNCubeNode()).getRuntimeHelper().getLoopDataInputInstanceAttribute().getValue(iScope, iCubeContext).getValue();
                numberOfInstances = ((NodeList)((Object)loopDataInputValue)).getLength();
            }
            if (numberOfInstances <= -1) {
                throw new CubeException((Throwable)new IllegalArgumentException("Invalid value for numberOfInstances in " + ((BaseMultiInstanceNode)this.getBPMNCubeNode()).getRuntimeHelper().getFlowNode().getName()));
            }
            ((BaseMultiInstanceNode)this.getBPMNCubeNode()).getRuntimeHelper().getNumberOfInstancesInstanceAttribute().setValue(iScope, iCubeContext, numberOfInstances);
            ((BaseMultiInstanceNode)this.getBPMNCubeNode()).getRuntimeHelper().getNumberOfActiveInstancesInstanceAttribute().setValue(iScope, iCubeContext, numberOfInstances);
            iWorkItem.markAsComplete();
        }
    }
}

