/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.nodes;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.util.ThreadCountManager;
import com.collaxa.cube.engine.util.TokenManager;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.model.nodes.BasePairingGatewayNode;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.ComplexGatewayMicroInstruction;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.ComplexGatewayMicroInstructionMetadata;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenManager;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNUtility;
import oracle.bpm.bpmn.engine.runtime.BPMNExpression;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionDataElementContextType;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionLanguage;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionMetadata;
import oracle.bpm.bpmn.engine.runtime.InstanceAttributeType;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.PredefinedVariablesHelper;
import oracle.bpm.project.model.processes.ComplexGateway;
import oracle.soa.common.collections.Queue;

public class ComplexGatewayNode
extends BasePairingGatewayNode<ComplexGateway>
implements ComplexGatewayMicroInstructionMetadata {
    public ComplexGatewayNode(BPMNCubeMapBuilderContext context, String name, ComplexGateway complexGateway) {
        super(context, name, complexGateway);
        this.addMicroInstruction(new ComplexGatewayMicroInstruction(this));
    }

    @Override
    public boolean canActivate(IScope scope, ICubeContext ctx) throws Exception {
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"canActivate", (Object)"Start of canActivate of overwrite method");
        boolean activate = false;
        boolean ignoreToken = false;
        boolean conditionResult = false;
        Queue queue = BPMNTokenManager.getTokenObject(scope, this.getId());
        if (queue == null) {
            return activate;
        }
        Object o = queue.remove();
        if (this.canActivateAsSimpleNode(scope, ctx)) {
            if (queue.size() == 0) {
                TokenManager.consumeOpenToken((IScope)scope, (String)this.getId());
            }
            return true;
        }
        HashMap<String, Object> removedToken = BPMNTokenMetadataUtils.convertToToken(o);
        String activationIdsOfRemovedToken = BPMNTokenMetadataUtils.getActivationIdsFromTokenMetadata(removedToken);
        String[] activationIds = activationIdsOfRemovedToken.split(",");
        ArrayList<String> removedActivationIds = new ArrayList<String>();
        for (int i = 0; i < activationIds.length; ++i) {
            int activationId;
            if (activationIds[i].equals("") || (ignoreToken = this.ignoreToken(scope, ctx, activationId = Integer.parseInt(activationIds[i]))) || removedToken.get("DUMMY_TOKEN_FOR_MERGING_GATEWAY") != null) continue;
            this.setActivationCount(scope, ctx, activationId);
            this.setState(scope, ctx, activationId);
            conditionResult = this.evaluateCondition(scope, ctx);
            if (!conditionResult) continue;
            removedActivationIds.add("" + activationId);
            this.setActivationIdsFromRemovedToken(removedToken, activationIds, removedActivationIds);
            PredefinedVariablesHelper.getPredefinedVariablesForProjectObject(this.getFlowElement(), this.getFlowElement());
            String state = PredefinedVariablesHelper.STATE.getName();
            String keyName = ((ComplexGateway)this.getFlowElement()).getId() + "." + state + "." + activationId;
            scope.set(keyName, true);
            if (queue.size() == 0) {
                TokenManager.consumeOpenToken((IScope)scope, (String)this.getId());
            }
            this.processConsumedToken(scope, ctx, removedToken, removedActivationIds);
            String flowKeyPrefix = scope.getAbsoluteScopeId() + "." + this.getId() + ".";
            String flowKey = flowKeyPrefix + activationId;
            String flows = (String)scope.getAsObject(flowKey);
            if (flows == null) continue;
            int flow = Integer.parseInt(flows);
            for (int k = 0; k < flow; ++k) {
                ThreadCountManager.decreaseThreadCount((IScope)scope);
            }
        }
        if (!conditionResult) {
            activate = super.canActivateBasedOnTokens(scope, ctx, queue, o, ignoreToken);
            BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"canActivate", (Object)("Can activate of super method " + activate));
        }
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"canActivate", (Object)"End of canActivate of overwrite method");
        this.uniinitVariables(scope);
        if (ignoreToken) {
            return false;
        }
        return conditionResult || activate;
    }

    @Override
    protected void removeActivationIdDataFromScope(IScope scope, ICubeContext ctx, int activationId) throws CubeException {
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"removeActivationIdDataFromScope", (Object)("Start of removing activation id metadata for  = " + activationId));
        String activationObjectName = PredefinedVariablesHelper.ACTIVATION_COUNT.getName();
        String keyName = ((ComplexGateway)this.getFlowElement()).getId() + "." + activationObjectName + "." + activationId;
        scope.set(keyName, null);
        String stateObjectName = PredefinedVariablesHelper.STATE.getName();
        keyName = ((ComplexGateway)this.getFlowElement()).getId() + "." + stateObjectName + "." + activationId;
        scope.set(keyName, null);
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"removeActivationIdDataFromScope", (Object)("End of removing activation id metadata for  = " + activationId));
    }

    @Override
    protected void decrementThreadCount(IScope scope, boolean ignoreToken) throws CubeException {
        if (!ignoreToken) {
            ThreadCountManager.decreaseThreadCount((IScope)scope);
        }
    }

    private boolean ignoreToken(IScope scope, ICubeContext ctx, int activationId) throws CubeException {
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"ignoreToken", (Object)"Start of ignore token");
        String stateObjectName = PredefinedVariablesHelper.STATE.getName();
        String keyName = ((ComplexGateway)this.getFlowElement()).getId() + "." + stateObjectName + "." + activationId;
        boolean state = false;
        if (!scope.contains(keyName)) {
            scope.declareAndSet(keyName, state);
        } else {
            state = scope.getBoolean(keyName);
        }
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"ignoreToken", (Object)("End of ignore token = " + state));
        return state;
    }

    private void setActivationCount(IScope scope, ICubeContext ctx, int activationId) throws Exception {
        String counterObjectName = PredefinedVariablesHelper.ACTIVATION_COUNT.getName();
        String keyName = ((ComplexGateway)this.getFlowElement()).getId() + "." + counterObjectName + "." + activationId;
        int availableTokens = 0;
        if (!scope.contains(keyName)) {
            availableTokens = 1;
            scope.declareAndSet(keyName, availableTokens);
        } else {
            int availableToken = scope.getInt(keyName);
            availableTokens = availableToken + 1;
            scope.set(keyName, availableTokens);
        }
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"evaluateCondition", (Object)("Available token for key  =  " + keyName + " = " + availableTokens));
        this.setVariableValue(scope, PredefinedVariablesHelper.ACTIVATION_COUNT.getName(), availableTokens);
    }

    private void setState(IScope scope, ICubeContext ctx, int activationId) throws Exception {
        String stateName = PredefinedVariablesHelper.STATE.getName();
        String keyName = ((ComplexGateway)this.getFlowElement()).getId() + "." + stateName + "." + activationId;
        boolean state = false;
        if (!scope.contains(keyName)) {
            scope.declareAndSet(keyName, state);
        } else {
            state = scope.getBoolean(keyName);
        }
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"evaluateCondition", (Object)("Activation state of the gateway  =  " + keyName + " = " + state));
        scope.set(keyName, state);
        InstanceAttributeType.getVariableName(InstanceAttributeType.GATEWAY_INSTANCE_ATTRIBUTE, ((ComplexGateway)this.getFlowElement()).getName(), PredefinedVariablesHelper.STATE.getName());
        this.setVariableValue(scope, PredefinedVariablesHelper.STATE.getName(), state);
    }

    private void setVariableValue(IScope scope, String attrName, Object value) throws CubeException {
        String variableName = InstanceAttributeType.getVariableName(InstanceAttributeType.GATEWAY_INSTANCE_ATTRIBUTE, ((ComplexGateway)this.getFlowElement()).getName(), attrName);
        if (scope.contains(variableName)) {
            scope.set(variableName, value);
        } else {
            scope.declareAndSet(variableName, value);
        }
    }

    private void uniinitVariables(IScope scope) throws CubeException {
        String counterVar;
        String stateVariable = InstanceAttributeType.getVariableName(InstanceAttributeType.GATEWAY_INSTANCE_ATTRIBUTE, ((ComplexGateway)this.getFlowElement()).getName(), PredefinedVariablesHelper.STATE.getName());
        if (scope.contains(stateVariable)) {
            scope.set(stateVariable, null);
        }
        if (scope.contains(counterVar = InstanceAttributeType.getVariableName(InstanceAttributeType.GATEWAY_INSTANCE_ATTRIBUTE, ((ComplexGateway)this.getFlowElement()).getName(), PredefinedVariablesHelper.ACTIVATION_COUNT.getName()))) {
            scope.set(counterVar, null);
        }
    }

    private boolean evaluateCondition(IScope scope, ICubeContext ctx) throws CubeException {
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"evaluateCondition", (Object)"Start of evaluating the expression");
        Expression expression = ((ComplexGateway)this.getFlowElement()).getActivationCondition();
        if (expression == null || expression.getExpressionValue() == null || expression.getExpressionValue().equals("")) {
            throw new CubeException(75001, BPMNUtility.getObjects(scope.getCubeInstance(), this.getFlowElement()));
        }
        String strExpression = expression.getExpressionValue();
        BPMNExpressionMetadata forBPMNExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, null, strExpression, BPMNExpressionLanguage.XPATH, expression.getNamespaces());
        BPMNExpression forBPMNExpression = BPMNExpression.createBPMNExpression(this.getFlowElement(), forBPMNExpressionMetadata, scope);
        boolean condition = forBPMNExpression.evaluateBoolean(scope, ctx);
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"evaluateCondition", (Object)("Condition result for expression " + strExpression + " is " + condition));
        return condition;
    }
}

