/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.nodes;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkManager;
import com.collaxa.cube.engine.core.IWorkPerformer;
import com.collaxa.cube.engine.util.ThreadCountManager;
import com.collaxa.cube.engine.util.TokenManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.model.nodes.AbstractGatewayNode;
import oracle.bpm.bpmn.engine.model.runtime.BaseBPMNGatewayWMP;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenManager;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.GatewayDirection;
import oracle.soa.common.collections.Queue;

public abstract class BasePairingGatewayNode<T extends Gateway>
extends AbstractGatewayNode<T> {
    public BasePairingGatewayNode(BPMNCubeMapBuilderContext context, String name, T gateway) {
        super(context, name, gateway);
    }

    public void init(ICubeContext iCubeContext) throws CubeException {
        BaseBPMNGatewayWMP<BasePairingGatewayNode> wmp = new BaseBPMNGatewayWMP<BasePairingGatewayNode>(this);
        this.init((IWorkManager)wmp, (IWorkPerformer)wmp);
    }

    @Override
    public void activate(IScope scope, ICubeContext ctx) throws Exception {
    }

    public void uninit(ICubeContext ctx) throws CubeException {
    }

    protected boolean canActivateBasedOnTokens(IScope scope, ICubeContext ctx, Queue queue, Object o, boolean ignoreToken) throws Exception {
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"canActivate", (Object)("Token object = " + queue));
        HashMap<String, Object> removedToken = BPMNTokenMetadataUtils.convertToToken(o);
        String activationIdsOfRemovedToken = BPMNTokenMetadataUtils.getActivationIdsFromTokenMetadata(removedToken);
        boolean activate = false;
        ArrayList<String> removedActivationIds = new ArrayList<String>();
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"canActivate", (Object)("Removed token =" + activationIdsOfRemovedToken));
        String flowKeyPrefix = scope.getAbsoluteScopeId() + "." + this.getId() + ".";
        String[] activationIds = activationIdsOfRemovedToken.split(",");
        for (int i = 0; i < activationIds.length; ++i) {
            if (activationIds[i].equals("")) continue;
            int activationId = Integer.parseInt(activationIds[i]);
            String flowKey = flowKeyPrefix + activationId;
            if (!scope.contains(flowKey)) continue;
            String flows = (String)scope.getAsObject(flowKey);
            BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"canActivate", (Object)("No of flows for activation id " + activationId + " = " + flows));
            if (flows == null) continue;
            int flowInt = Integer.parseInt(flows);
            if (flowInt == 1) {
                if (scope.contains(flowKey)) {
                    scope.set(flowKey, null);
                }
                removedActivationIds.add("" + activationId);
                this.removeActivationIdDataFromScope(scope, ctx, activationId);
                BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"canActivate", (Object)("can activate for " + activationId + " = true"));
                activate = true;
            } else {
                scope.set(flowKey, (Object)Integer.toString(--flowInt));
            }
            if (removedToken.get("DUMMY_TOKEN_FOR_MERGING_GATEWAY") != null) continue;
            this.decrementThreadCount(scope, ignoreToken);
        }
        if (activate) {
            this.setActivationIdsFromRemovedToken(removedToken, activationIds, removedActivationIds);
        }
        if (queue.size() == 0) {
            TokenManager.consumeOpenToken((IScope)scope, (String)this.getId());
        }
        if (activate) {
            this.processConsumedToken(scope, ctx, removedToken, removedActivationIds);
        }
        return activate;
    }

    public boolean canActivateAsSimpleNode(IScope scope, ICubeContext ctx) throws Exception {
        GatewayDirection direction = ((Gateway)this.getFlowElement()).getDirection();
        if (direction != null && direction.equals((Object)GatewayDirection.DIVERGING)) {
            return TokenManager.containsOpenToken((IScope)scope, (String)this.getId());
        }
        return false;
    }

    @Override
    public boolean canActivate(IScope scope, ICubeContext ctx) throws Exception {
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"canActivate", (Object)this.getClass().getName(), (Object)"canActivate", (Object)"start");
        Queue queue = BPMNTokenManager.getTokenObject(scope, this.getId());
        if (queue == null) {
            return false;
        }
        Object o = queue.remove();
        if (this.canActivateAsSimpleNode(scope, ctx)) {
            if (queue.size() == 0) {
                TokenManager.consumeOpenToken((IScope)scope, (String)this.getId());
            }
            this.processConsumedToken(scope, ctx, BPMNTokenMetadataUtils.convertToToken(o));
            return true;
        }
        return this.canActivateBasedOnTokens(scope, ctx, queue, o, false);
    }

    public Gateway getMergingGateway() {
        return ((Gateway)this.getFlowElement()).getMergingGateway();
    }

    protected void setActivationIdsFromRemovedToken(HashMap<String, Object> removedToken, String[] activationIds, List removedActivationIds) {
        String moveActivationIds = "";
        for (int i = 0; i < activationIds.length; ++i) {
            if (removedActivationIds.contains(activationIds[i])) continue;
            moveActivationIds = moveActivationIds.equals("") ? activationIds[i] : moveActivationIds + "," + activationIds[i];
        }
        BPELExecutionLogger.debug((String)this.getClass().getName(), (String)"canActivate", (Object)("Moving activation ids " + moveActivationIds));
        BPMNTokenMetadataUtils.setActivationIdsToTokenMetadata(removedToken, moveActivationIds);
    }

    public boolean isForkingGateway() {
        GatewayDirection direction = ((Gateway)this.getFlowElement()).getDirection();
        return direction.equals((Object)GatewayDirection.DIVERGING) || direction.equals((Object)GatewayDirection.MIXED);
    }

    protected void decrementThreadCount(IScope scope, boolean ignoreToken) throws CubeException {
        ThreadCountManager.decreaseThreadCount((IScope)scope);
    }

    protected String processConsumedToken(IScope scope, ICubeContext ctx, HashMap<String, Object> token, List removedActivationIds) throws CubeException {
        if (!this.isForkingGateway()) {
            String activationId = (String)removedActivationIds.get(0);
            String stepKey = BPMNTokenMetadataUtils.getMergeGatewayStepKey(((Gateway)this.getFlowElement()).getId(), activationId);
            int step = scope.getInt(stepKey);
            scope.set(stepKey, null);
            String threadKey = BPMNTokenMetadataUtils.getMergeGatewayThreadey(((Gateway)this.getFlowElement()).getId(), activationId);
            int thread = scope.getInt(threadKey);
            scope.set(threadKey, null);
            String parentThreadKey = BPMNTokenMetadataUtils.getMergeGatewayParentThreadey(((Gateway)this.getFlowElement()).getId(), activationId);
            int parentThread = scope.getInt(parentThreadKey);
            scope.set(parentThreadKey, null);
            BPMNTokenMetadataUtils.setStepToTokenMetadata(token, step);
            BPMNTokenMetadataUtils.setThreadToTokenMetadata(token, thread);
            BPMNTokenMetadataUtils.setParentThreadInTokenMetadata(token, parentThread);
        }
        return super.processConsumedToken(scope, ctx, token);
    }

    protected void removeActivationIdDataFromScope(IScope scope, ICubeContext ctx, int activationId) throws CubeException {
    }
}

