/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.nodes;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkManager;
import com.collaxa.cube.engine.core.IWorkPerformer;
import com.collaxa.cube.engine.ext.bpel.common.BaseBPELCubeBlock;
import com.collaxa.cube.engine.ext.bpel.common.BaseBPELCubeNode;
import com.collaxa.cube.engine.util.ThreadCountManager;
import com.collaxa.cube.engine.util.TokenManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.common.SequenceFlowMetadata;
import oracle.bpm.bpmn.engine.model.common.SequenceFlowMetadataSupport;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.DecreaseEventCount;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.DecreaseThreadCount;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.GenerateTokenMicroInstruction;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.IMicroInstruction;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.IMicroInstructionMetadata;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.SetExitTokenMetadata;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.UnconditionalSequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenManager;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.util.ArrayUtils;

@Deprecated
public abstract class BaseBPMNActivityNode<T extends FlowNode>
extends BaseBPELCubeNode
implements BPMNCubeElement<T>,
IMicroInstructionMetadata {
    private boolean boundaryFlowEndElement = false;
    private T flowElement;
    private List<IMicroInstruction> microInstructionsList;
    private SequenceFlowMetadata sequenceFlowMetadata;
    private boolean startOfMainFlow = true;

    public BaseBPMNActivityNode(BPMNCubeMapBuilderContext context, String name, BpmnType type, T flowElement) {
        this(context, "", name, type, flowElement);
    }

    protected BaseBPMNActivityNode(BPMNCubeMapBuilderContext context, String idSuffix, String name, BpmnType type, T flowElement) {
        super.setId(context.getCubeElementId((FlowNode)flowElement, idSuffix));
        this.setName(name);
        this.setType(type.name());
        this.flowElement = flowElement;
        this.initSequenceFlowMetadata();
        this.microInstructionsList = new ArrayList<IMicroInstruction>();
    }

    @Override
    public final String getId() {
        return super.getId();
    }

    public final void setId(String id) {
        throw new UnsupportedOperationException();
    }

    public void addMicroInstruction(IMicroInstruction microInstruction, int index) {
        this.microInstructionsList.add(index, microInstruction);
    }

    public void addMicroInstruction(IMicroInstruction microInstruction) {
        this.microInstructionsList.add(microInstruction);
    }

    public List<IMicroInstruction> getMicroInstructions() {
        return Collections.unmodifiableList(this.microInstructionsList);
    }

    @Override
    public SequenceFlowMetadata getSequenceFlowMetadata() {
        return this.sequenceFlowMetadata;
    }

    public boolean hasOutgoingSequenceFlows() {
        return this.getSequenceFlowMetadata().getOutgoingSequenceFlow() != null;
    }

    public void init(IWorkManager manager, IWorkPerformer performer) {
        this.mManager = manager;
        this.mPerformer = performer;
        this.initGenerateNextTokenMicroInstructions();
    }

    @Override
    public T getFlowElement() {
        return this.flowElement;
    }

    public void finalize(IScope scope, ICubeContext ctx) throws Exception {
    }

    public String[] getExitTokens() {
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public void activate(IScope scope, ICubeContext ctx) throws Exception {
        HashMap<String, Object> token = BPMNTokenManager.consumeOpenToken(scope, ctx, this.getId());
        this.processConsumedToken(scope, ctx, token);
    }

    public boolean canActivate(IScope scope, ICubeContext ctx) throws Exception {
        return TokenManager.containsOpenToken((IScope)scope, (String)this.getId());
    }

    @Override
    public boolean isNonMainFlowEndElement() {
        return this.boundaryFlowEndElement;
    }

    @Override
    public void setNonMainFlowEndElement(boolean value) {
        this.boundaryFlowEndElement = value;
    }

    @Override
    public boolean isStartOfMainFlow() {
        return this.startOfMainFlow;
    }

    @Override
    public void setStartOfMainFlow(boolean value) {
        this.startOfMainFlow = value;
    }

    @Override
    public String getFlowElementId() {
        return this.getFlowElement().getId();
    }

    @Override
    public String getFlowElementName() {
        return this.getFlowElement().getName();
    }

    @Override
    public BpmnType getFlowElementType() {
        return this.getFlowElement().getBpmnType();
    }

    @Override
    public String getFlowElementDefaultLabel() {
        return this.getFlowElement().getDefaultLabel();
    }

    @Override
    public Process getProcess() {
        return this.getFlowElement().getProcess();
    }

    @Override
    public void addMicroInstruction(String tag, oracle.bpm.bpmn.engine.microkernel.IMicroInstruction mi) {
        throw new UnsupportedOperationException();
    }

    @Override
    public oracle.bpm.bpmn.engine.microkernel.IMicroInstruction getMicroInstruction(String tag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, oracle.bpm.bpmn.engine.microkernel.IMicroInstruction> getMicroInstructionMap() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BPMNCubeElement getCubeElement() {
        return this;
    }

    protected void initGenerateNextTokenMicroInstructions() {
        UnconditionalSequenceFlowInfo outgoingSequenceFlow = this.getSequenceFlowMetadata().getOutgoingSequenceFlow();
        String nextTokenId = outgoingSequenceFlow != null ? outgoingSequenceFlow.getTargetNodeId() : this.getParentBlockId();
        GenerateTokenMicroInstruction.Metadata metadata = this.createGenerateTokenMetadata(nextTokenId);
        if (nextTokenId.equals(this.getParentBlockId())) {
            if (this.isNonMainFlowEndElement()) {
                this.addMicroInstruction(new DecreaseEventCount(this));
            } else {
                if (ModelVisitorUtil.isInlineEventHandler(this.getFlowElement()) && ((BaseBPMNActivityBlock)this.getParentBlock()).isNonMainFlowEndElement()) {
                    this.addMicroInstruction(new DecreaseEventCount.DecreaseEventCountInParentScope(this));
                } else {
                    this.addMicroInstruction(new SetExitTokenMetadata(this));
                }
                this.addMicroInstruction(new DecreaseThreadCount(this));
            }
        } else if (((BaseBPELCubeBlock)this.getParentBlock()).containsChild(nextTokenId)) {
            this.addMicroInstruction(new GenerateTokenMicroInstruction.ToNextActivity(metadata));
        } else {
            this.addMicroInstruction(new GenerateTokenMicroInstruction.ToNextActivityInParentScope(metadata));
        }
    }

    protected GenerateTokenMicroInstruction.Metadata createGenerateTokenMetadata(String nextTokenId) {
        return new GenerateTokenMicroInstruction.Metadata(this, nextTokenId);
    }

    protected String processConsumedToken(IScope scope, ICubeContext ctx, HashMap<String, Object> token) throws CubeException {
        ctx.addToEnvironment("__node_activation-context", token);
        boolean increaseThreadCount = BPMNTokenMetadataUtils.removeIncreaseCountThreadFromTokenMetadata(token);
        if (increaseThreadCount) {
            ThreadCountManager.increaseThreadCount((IScope)scope);
        }
        return BPMNTokenMetadataUtils.getActivationIdsFromTokenMetadata(token);
    }

    private void initSequenceFlowMetadata() {
        this.sequenceFlowMetadata = new SequenceFlowMetadataSupport();
    }
}

