/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.deploy.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.repos.IPersistencyService;
import oracle.bpel.services.workflow.repos.PersistencyDriver;
import oracle.bpel.services.workflow.repos.Transaction;
import oracle.bpel.services.workflow.runtimeconfig.impl.RuntimeConfigUtil;
import oracle.bpel.services.workflow.runtimeconfig.model.AttributeLabel;
import oracle.bpel.services.workflow.runtimeconfig.model.AttributeLabelType;
import oracle.bpel.services.workflow.runtimeconfig.model.AttributeLabelUsages;
import oracle.bpel.services.workflow.runtimeconfig.model.LabelUsageType;
import oracle.bpel.services.workflow.runtimeconfig.model.ObjectFactory;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.InputDataAssociationEnabled;
import oracle.bpm.project.model.processes.OutputDataAssociationEnabled;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.fabric.composite.model.ComponentModel;

public final class FlexFieldAutoMapper {
    private Map<String, AttributeLabel> mAttributeLabelMap = null;
    private String mCompositeDN;
    private FlexfieldUsageTracker mFlexfieldUsageTracker = null;
    private String mProcessId;
    private Process mprocessModel;
    private String mProcessName;
    private static final String CLASS_NAME = "oracle.bpm.bpmn.engine.model.deploy.schema.FlexFieldAutoMapper";
    private static final String STRING_DATATYPE = "Text";
    private static final String NUMBER_DATATYPE = "Number";
    private static final String DATE_DATATYPE = "Date";
    private static final String PROTECTED_PREFIX = "Protected";
    private static final int NO_OF_TEXT_ATTRIBUTES = 20;
    private static final int NO_OF_NUMBER_ATTRIBUTES = 10;
    private static final int NO_OF_DATE_ATTRIBUTES = 10;
    private static final String PROTECTED_TEXT_ATTR = "ProtectedTextAttribute";
    private static final String PROTECTED_NUMBER_ATTR = "ProtectedNumberAttribute";
    private static final String PROTECTED_DATE_ATTR = "ProtectedDateAttribute";
    private static List<String> PROTECTED_TEXT_ATTRS;
    private static List<String> PROTECTED_NUMBER_ATTRS;
    private static List<String> PROTECTED_DATE_ATTRS;

    public FlexFieldAutoMapper(ComponentModel model, Process process) {
        this.mCompositeDN = model.getComposite().getDN();
        this.mProcessName = model.getName();
        this.mProcessId = this.mCompositeDN + "/" + this.mProcessName;
        this.mprocessModel = process;
    }

    public FlexFieldAutoMapper(String compositeDN, String processName, Process process) {
        this.mCompositeDN = compositeDN;
        this.mProcessName = processName;
        this.mProcessId = this.mCompositeDN + "/" + this.mProcessName;
        this.mprocessModel = process;
    }

    public static List<String> getFlexfieldAttributesForType(String type) {
        List<String> result = null;
        if (STRING_DATATYPE.equals(type)) {
            result = PROTECTED_TEXT_ATTRS;
        } else if (NUMBER_DATATYPE.equals(type)) {
            result = PROTECTED_NUMBER_ATTRS;
        } else if (DATE_DATATYPE.equals(type)) {
            result = PROTECTED_DATE_ATTRS;
        }
        return result;
    }

    public void populateFlexFields() throws Exception {
        String methodName = "populateFlexFields";
        Sequence activities = this.mprocessModel.getActivities();
        Collection coll = this.mprocessModel.getProject().getProjectDataObjects();
        HashMap<String, ProjectDataObject> externalVariables = new HashMap<String, ProjectDataObject>();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)methodName, (String)("Creating flexflield mappings for " + this.mProcessId + " Project data object size " + coll.size()));
        if (coll.size() > 0) {
            for (Activity a : activities) {
                Sequence dataRefs;
                Sequence associations;
                if (a instanceof OutputDataAssociationEnabled) {
                    OutputDataAssociationEnabled outputAssociation = (OutputDataAssociationEnabled)a;
                    if (outputAssociation.getOutputDataAssociationSet() == null) continue;
                    associations = outputAssociation.getOutputDataAssociationSet().getDataAssociations();
                    for (DataAssociation ass : associations) {
                        dataRefs = ass.getTarget().getRefs();
                        for (String ref : dataRefs) {
                            this.populateExternalVariables(coll, ref, externalVariables);
                        }
                    }
                    continue;
                }
                if (!(a instanceof InputDataAssociationEnabled)) continue;
                InputDataAssociationEnabled inputAssociation = (InputDataAssociationEnabled)a;
                associations = inputAssociation.getInputDataAssociationSet().getDataAssociations();
                for (DataAssociation ass : associations) {
                    dataRefs = ass.getTarget().getRefs();
                    for (String ref : dataRefs) {
                        this.populateExternalVariables(coll, ref, externalVariables);
                    }
                }
            }
            int numberOfVariables = externalVariables.size();
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)methodName, (String)("Total number of external variables used in process = " + numberOfVariables));
            if (numberOfVariables > 0) {
                this.generateFlexfieldMappings(externalVariables);
            }
        }
    }

    private static void initAttributeLists() {
        PROTECTED_TEXT_ATTRS = FlexFieldAutoMapper.getAttributeList(PROTECTED_TEXT_ATTR, 20);
        PROTECTED_NUMBER_ATTRS = FlexFieldAutoMapper.getAttributeList(PROTECTED_NUMBER_ATTR, 10);
        PROTECTED_DATE_ATTRS = FlexFieldAutoMapper.getAttributeList(PROTECTED_DATE_ATTR, 10);
    }

    private static List<String> getAttributeList(String attributeName, int numberOfAttributes) {
        ArrayList<String> attrList = new ArrayList<String>(numberOfAttributes);
        for (int i = 0; i < numberOfAttributes; ++i) {
            attrList.add(attributeName + (i + 1));
        }
        return attrList;
    }

    private void populateExternalVariables(Collection<ProjectDataObject> projectObjects, String dataObjectName, Map<String, ProjectDataObject> externalVariables) {
        String methodName = "populateExternalVariables";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)methodName, (String)("populateExternalVariables  for ref " + dataObjectName));
        for (ProjectDataObject projectObject : projectObjects) {
            boolean isSimpleType;
            String objectName = projectObject.getName();
            if (!objectName.equals(dataObjectName)) continue;
            CatalogType type = projectObject.getType();
            boolean bl = isSimpleType = type.isString() || type.isDecimal() || type.isNumber() || type.isInt() || type.isTime();
            if (isSimpleType) {
                externalVariables.put(objectName, projectObject);
                continue;
            }
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)methodName, (String)("project variable " + objectName + " is of type " + type.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFlexfieldMappings(Map<String, ProjectDataObject> externalVariableMap) throws Exception {
        this.populateAttributeLabelMaps();
        HashMap<String, AttributeLabel> attributeLabelUsageMap = new HashMap<String, AttributeLabel>(externalVariableMap.size());
        Collection<ProjectDataObject> externalVariables = externalVariableMap.values();
        Set<String> externalVariableNames = externalVariableMap.keySet();
        for (ProjectDataObject externalVariable : externalVariables) {
            AttributeLabel attributeLabel = this.getAttributeLabelForExternalVariable(externalVariable);
            attributeLabelUsageMap.put(externalVariable.getName(), attributeLabel);
        }
        boolean inTransaction = false;
        try {
            inTransaction = Transaction.inTransaction();
            if (!inTransaction) {
                Transaction.start();
            }
            for (String variableName : externalVariableNames) {
                AttributeLabel attributeLabel = (AttributeLabel)attributeLabelUsageMap.get(variableName);
                if (attributeLabel.getTaskAttribute() == null) {
                    attributeLabel = this.createNewAttributeLabel(attributeLabel);
                }
                this.createAttributeLabelUsage(variableName, attributeLabel);
            }
        }
        finally {
            if (!inTransaction) {
                Transaction.close();
            }
        }
    }

    private void populateAttributeLabelMaps() throws WorkflowException {
        List<AttributeLabel> attributeLabels = this.queryAttributeLabels();
        this.mAttributeLabelMap = new HashMap<String, AttributeLabel>();
        this.mFlexfieldUsageTracker = new FlexfieldUsageTracker();
        for (AttributeLabel attributeLabel : attributeLabels) {
            this.mAttributeLabelMap.put(attributeLabel.getLabelName(), attributeLabel);
            this.mFlexfieldUsageTracker.addUsage(attributeLabel.getTaskAttribute());
        }
    }

    private AttributeLabel getAttributeLabelForExternalVariable(ProjectDataObject externalVariable) {
        String variableName;
        String METHOD_NAME = "getAttributeLabelForExternalVariable";
        AttributeLabel result = null;
        String labelName = variableName = externalVariable.getName();
        AttributeLabel matchedLabel = this.mAttributeLabelMap.get(labelName);
        boolean isSuitable = false;
        int i = 1;
        while (!isSuitable && matchedLabel != null) {
            isSuitable = this.isAttributeLabelSuitable(matchedLabel, externalVariable);
            if (!isSuitable) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"getAttributeLabelForExternalVariable", (String)("Attribute label " + matchedLabel.getLabelName() + " was unsuitable for " + externalVariable.getName()));
                labelName = variableName + "." + i;
                matchedLabel = this.mAttributeLabelMap.get(labelName);
            }
            ++i;
        }
        if (matchedLabel != null) {
            this.mFlexfieldUsageTracker.makeUnavailable(matchedLabel.getTaskAttribute());
            result = matchedLabel;
        } else {
            result = this.createAttributeLabelForVariable(labelName, externalVariable);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"getAttributeLabelForExternalVariable", (String)("Using attribute label " + result.getLabelName() + " for " + externalVariable.getName()));
        return result;
    }

    private boolean isAttributeLabelSuitable(AttributeLabel label, ProjectDataObject externalVariable) {
        boolean result = false;
        String variableType = this.getExternalVariableType(externalVariable);
        result = variableType.equals(label.getDataType());
        if (result) {
            String flexfieldColumn = label.getTaskAttribute();
            result = this.mFlexfieldUsageTracker.isAvailable(flexfieldColumn);
        }
        return result;
    }

    private AttributeLabel createAttributeLabelForVariable(String labelName, ProjectDataObject externalVariable) {
        String METHOD_NAME = "createAttributeLabelForVariable";
        String type = this.getExternalVariableType(externalVariable);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"createAttributeLabelForVariable", (String)("Creating new attribute label " + labelName + " of type " + type + " for " + externalVariable.getName()));
        AttributeLabel label = RuntimeConfigUtil.getFactory().createAttributeLabel();
        label.setLabelName(labelName);
        label.setDataType(type);
        label.setDescription("Auto-generated for BPM Process");
        label.setWorkflowType("BPMN");
        label.setTaskAttribute(null);
        return label;
    }

    private String getExternalVariableType(ProjectDataObject externalVariable) {
        String result = "";
        CatalogType type = externalVariable.getType();
        if (type.isString()) {
            result = STRING_DATATYPE;
        } else if (type.isDecimal() || type.isReal() || type.isNumber()) {
            result = NUMBER_DATATYPE;
        } else if (type.isTime()) {
            result = DATE_DATATYPE;
        }
        return result;
    }

    private AttributeLabel createNewAttributeLabel(AttributeLabel label) throws WorkflowException {
        String METHOD_NAME = "createNewAttributeLabel";
        String type = label.getDataType();
        String flexfieldColumn = this.mFlexfieldUsageTracker.getNextAvailableFlexfield(type);
        if (flexfieldColumn == null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.WARNING, (String)CLASS_NAME, (String)"createNewAttributeLabel", (String)("Could not create new attribute label " + label.getLabelName() + " because there are no more available flexfield attributes of type " + type));
            return null;
        }
        label.setTaskAttribute(flexfieldColumn);
        this.mFlexfieldUsageTracker.makeUnavailable(flexfieldColumn);
        Transaction.getPersistencyService().insertAttributeLabel(label);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"createNewAttributeLabel", (String)("Created new attribute label " + label.getLabelName() + " for flexfield attribute " + flexfieldColumn));
        return label;
    }

    private AttributeLabelUsages createAttributeLabelUsage(String variableName, AttributeLabel label) throws WorkflowException {
        String METHOD_NAME = "createAttributeLabelUsage";
        if (label == null) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.WARNING, (String)CLASS_NAME, (String)"createAttributeLabelUsage", (String)("Could not create flexfield mapping for " + variableName + " because it was not possible to generate a suitable attribute label"));
            return null;
        }
        ObjectFactory factory = RuntimeConfigUtil.getFactory();
        AttributeLabelUsages usages = factory.createAttributeLabelUsages();
        LabelUsageType usageType = factory.createLabelUsageType();
        usages.setLabel((AttributeLabelType)label);
        usageType.setWorkflowId(this.mProcessId);
        usageType.setWorkflowName(this.mProcessName);
        usageType.setDescription("Auto generated mapping for process");
        usageType.setPayloadAttribute(variableName);
        usages.getUsage().add(usageType);
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.INFORMATION, (String)CLASS_NAME, (String)"createAttributeLabelUsage", (String)("Creating variable mapping for variable " + variableName + " using label " + label.getLabelName() + " with flexfield attr " + label.getTaskAttribute()));
        Transaction.getPersistencyService().insertAttributeLabelUsages(usages);
        return usages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AttributeLabel> queryAttributeLabels() throws WorkflowException {
        String METHOD_NAME = "queryAttributeLabels";
        IPersistencyService svc = null;
        List result = null;
        try {
            svc = PersistencyDriver.getInstance();
            result = svc.getAttributeLabel(null, null);
        }
        finally {
            if (svc != null) {
                svc.close();
            }
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_INSTANCE_MANAGEMENT_SERVICE, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)"queryAttributeLabels", (String)("There are a total of " + result.size() + " attribute labels currently defined in the system."));
        return result;
    }

    static {
        FlexFieldAutoMapper.initAttributeLists();
    }

    private class FlexfieldUsageTracker {
        private Map<String, Integer> mDateFlexfieldUsageMap = null;
        private Map<String, Integer> mNumberFlexfieldUsageMap = null;
        private Map<String, Integer> mTextFlexfieldUsageMap = null;

        public FlexfieldUsageTracker() {
            this.prePopulateUsageMaps();
        }

        public void addUsage(String flexfieldName) {
            Map<String, Integer> usageMap = this.getUsageMapForFlexfield(flexfieldName);
            Integer numberOfUsages = null;
            if (usageMap != null) {
                numberOfUsages = usageMap.get(flexfieldName);
            }
            if (numberOfUsages != null) {
                usageMap.put(flexfieldName, numberOfUsages + 1);
            }
        }

        public void makeUnavailable(String flexfieldName) {
            Map<String, Integer> usageMap = this.getUsageMapForFlexfield(flexfieldName);
            if (usageMap != null) {
                usageMap.remove(flexfieldName);
            }
        }

        public boolean isAvailable(String flexfieldName) {
            boolean result = false;
            Map<String, Integer> usageMap = this.getUsageMapForFlexfield(flexfieldName);
            if (usageMap != null) {
                result = usageMap.get(flexfieldName) != null;
            }
            return result;
        }

        public String getNextAvailableFlexfield(String flexfieldType) {
            return this.getNextAvailableFlexfieldFromMap(this.getUsageMapForType(flexfieldType), FlexFieldAutoMapper.getFlexfieldAttributesForType(flexfieldType));
        }

        private void prePopulateUsageMaps() {
            this.mTextFlexfieldUsageMap = new HashMap<String, Integer>(20);
            this.mNumberFlexfieldUsageMap = new HashMap<String, Integer>(10);
            this.mDateFlexfieldUsageMap = new HashMap<String, Integer>(10);
            this.initUsageMap(this.mTextFlexfieldUsageMap, PROTECTED_TEXT_ATTRS);
            this.initUsageMap(this.mNumberFlexfieldUsageMap, PROTECTED_NUMBER_ATTRS);
            this.initUsageMap(this.mDateFlexfieldUsageMap, PROTECTED_DATE_ATTRS);
        }

        private void initUsageMap(Map<String, Integer> usageMap, List<String> attributes) {
            for (String attribute : attributes) {
                usageMap.put(attribute, new Integer(0));
            }
        }

        private String getNextAvailableFlexfieldFromMap(Map<String, Integer> usageMap, List<String> flexfieldNames) {
            String nextFlexfield = null;
            int fewestUsages = -1;
            for (String flexfieldName : flexfieldNames) {
                Integer usages = usageMap.get(flexfieldName);
                if (usages == null) continue;
                int numberOfUsages = usages;
                if (nextFlexfield != null && numberOfUsages >= fewestUsages) continue;
                nextFlexfield = flexfieldName;
                fewestUsages = numberOfUsages;
                if (fewestUsages != 0) continue;
                break;
            }
            return nextFlexfield;
        }

        private Map<String, Integer> getUsageMapForFlexfield(String flexfieldName) {
            return this.getUsageMapForType(this.getTypeForFlexfieldName(flexfieldName));
        }

        private Map<String, Integer> getUsageMapForType(String flexfieldType) {
            Map<String, Integer> result = null;
            if (FlexFieldAutoMapper.STRING_DATATYPE.equals(flexfieldType)) {
                result = this.mTextFlexfieldUsageMap;
            } else if (FlexFieldAutoMapper.NUMBER_DATATYPE.equals(flexfieldType)) {
                result = this.mNumberFlexfieldUsageMap;
            } else if (FlexFieldAutoMapper.DATE_DATATYPE.equals(flexfieldType)) {
                result = this.mDateFlexfieldUsageMap;
            }
            return result;
        }

        private String getTypeForFlexfieldName(String flexfieldName) {
            int typeStartIdx = 0;
            int typeEndIdx = flexfieldName.indexOf("Attribute");
            if (flexfieldName.indexOf(FlexFieldAutoMapper.PROTECTED_PREFIX) == 0) {
                typeStartIdx = FlexFieldAutoMapper.PROTECTED_PREFIX.length();
            }
            return flexfieldName.substring(typeStartIdx, typeEndIdx);
        }
    }
}

