/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.blocks;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.ICubeInstanceObserver;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IScopeContext;
import com.collaxa.cube.engine.core.IScopeImpl;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import com.collaxa.cube.engine.types.bpel.CXTypeVariable;
import com.collaxa.cube.engine.util.ThreadLabelManager;
import com.collaxa.cube.engine.util.TokenManager;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.blocks.ForEachBlock;
import oracle.bpm.bpmn.engine.model.common.CompensationHandler;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.soa.common.util.CXStringUtils;

public class ScopeBlock<T extends FlowNode>
extends BaseBPMNActivityBlock<T> {
    private CompensationHandler compensationHandler = null;
    private ForEachBlock forEachBlock;
    protected static final QName XSD_INT_QN = new QName("http://www.w3.org/2001/XMLSchema", "int");

    protected ScopeBlock(BPMNCubeMapBuilderContext context, String idSuffix, String name, T flowelement) {
        super(context, idSuffix, name, "SCOPE", flowelement);
    }

    public void setCompensationHandler(CompensationHandler compensationHandler) {
        this.compensationHandler = compensationHandler;
    }

    public CompensationHandler getCompensationHandler() {
        return this.compensationHandler;
    }

    public boolean hasCompensationHandler() {
        return this.compensationHandler != null;
    }

    public void setParentBlock(ICubeBlock block) {
        if (block instanceof ForEachBlock) {
            this.forEachBlock = (ForEachBlock)block;
        }
        super.setParentBlock(block);
    }

    @Override
    public IScopeImpl[] activate(IScopeContext scCtx, IScopeImpl pScope, ICubeContext ctx) throws Exception {
        if (this.isInForEach() && !pScope.containsLocally("++start-counter-value")) {
            int startCounterValue = this.forEachBlock.calculateStartCounterValueNumber(pScope, ctx);
            pScope.declareAndSet("++start-counter-value", startCounterValue);
            int finalCounterValue = this.forEachBlock.calculateFinalCounterValueNumber(pScope, ctx);
            pScope.declareAndSet("++final-counter-value", finalCounterValue);
            if (!this.forEachBlock.isParallel()) {
                pScope.declareAndSet("++current-counter-value", startCounterValue);
            }
        }
        if (scCtx.hasBlockScopes(this.getId()) && !CXStringUtils.isEmpty((String)pScope.getChildCompensableScope())) {
            IScopeImpl completedScope = scCtx.getScope(pScope.getChildCompensableScope());
            if (completedScope != null && completedScope.isCompleted() && completedScope.isCompensateAction()) {
                TokenManager.consumeOpenToken((IScope)pScope, (String)this.getId());
                completedScope.setState(3);
                ICubeInstanceObserver obs = pScope.getCubeInstanceImpl().getObserver();
                obs.onActivityCompensate(this.getName(), this.getLineNumber(), (IScope)pScope, ctx);
                if (this.hasCompensationHandler()) {
                    IScopeImpl thHolderScope = completedScope;
                    IScopeImpl tkHolderScope = completedScope;
                }
            }
            return new IScopeImpl[]{completedScope};
        }
        return super.activate(scCtx, pScope, ctx);
    }

    protected void __initScope(int index, IScope sc, ICubeContext ctx) throws Exception {
        super.__initScope(sc, ctx);
        if (this.isInForEach()) {
            this.initCounterVariable(index, sc);
            ThreadLabelManager.setLabel((IScope)sc, (String)(this.getCounterName() + "=" + index));
        }
    }

    @Override
    protected void generateExitTokens(IScope scope) throws CubeException {
        if (this.isInForEach() && !this.forEachBlock.isParallel()) {
            int currentCounterValue = scope.getInt("++current-counter-value");
            int finalCounterValue = scope.getInt("++final-counter-value");
            if (finalCounterValue > currentCounterValue) {
                scope.getParentScope().set("++current-counter-value", currentCounterValue + 1);
                TokenManager.generateOpenToken((IScope)scope.getParentScope(), (String)this.getId());
                return;
            }
        }
        super.generateExitTokens(scope);
    }

    protected int getStartCounterValue(IScope scope, ICubeContext ctx) throws CubeException {
        if (this.isInForEach()) {
            if (this.forEachBlock.isParallel()) {
                return scope.getInt("++start-counter-value");
            }
            return scope.getInt("++current-counter-value");
        }
        return 1;
    }

    protected int getFinalCounterValue(IScope scope, ICubeContext ctx) throws CubeException {
        if (this.isInForEach()) {
            if (this.forEachBlock.isParallel()) {
                return scope.getInt("++final-counter-value");
            }
            return scope.getInt("++current-counter-value");
        }
        return 1;
    }

    protected String getCounterName() {
        if (this.isInForEach()) {
            return this.forEachBlock.getCounterVariableName();
        }
        return null;
    }

    protected void initCounterVariable(int index, IScope sc) throws CubeException {
        CXTypeVariable var = new CXTypeVariable();
        var.setType(XSD_INT_QN);
        var.setValue((Object)index);
        sc.declareAndSet(this.getCounterName(), (Object)var);
    }

    private boolean isInForEach() {
        return this.forEachBlock != null;
    }
}

