/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.blocks;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.model.blocks.TryBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.project.model.processes.FlowNode;

public class ProcessTryBlock<T extends FlowNode>
extends TryBlock<T> {
    private Map<BPMNCubeElement, Set<FlowNode>> conditionalInitiateElement;

    protected ProcessTryBlock(BPMNCubeMapBuilderContext context, String idSuffix, String name, T flowElement) {
        super(context, idSuffix, name, flowElement);
    }

    public void setConditionalInitiateElements(Map<BPMNCubeElement, Set<FlowNode>> conditionalInitiateElement) {
        this.conditionalInitiateElement = conditionalInitiateElement;
    }

    @Override
    protected void activateEntryElement(HashMap<String, Object> token, IScope scope, BPMNCubeElement element, ICubeContext ctx) throws CubeException {
        boolean activate = true;
        if (this.conditionalInitiateElement.containsKey(element)) {
            activate = false;
            String activitySourceId = (String)BPMNTokenMetadataUtils.getPropertyFromTokenMetadata(token, "SOURCE_ACTIVITY_ID");
            Set<FlowNode> nodeSet = this.conditionalInitiateElement.get(element);
            for (FlowNode flowNode : nodeSet) {
                activate = flowNode.getId().equals(activitySourceId) || activate;
            }
        }
        if (activate) {
            super.activateEntryElement(token, scope, element, ctx);
        }
    }
}

