/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.blocks;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IScopeContext;
import com.collaxa.cube.engine.core.IScopeImpl;
import com.collaxa.cube.engine.util.ThreadCountManager;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.runtime.common.BPMNRuntimeConstants;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenManager;
import oracle.bpm.bpmn.engine.runtime.features.ManualInitiatorStartFeature;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.project.model.processes.SignalEventDefinition;
import oracle.bpm.project.model.processes.StartEvent;

public abstract class EventBasedGatewayBlock<T extends EventBasedGateway>
extends BaseBPMNActivityBlock<T> {
    public EventBasedGatewayBlock(BPMNCubeMapBuilderContext context, String idSuffix, String name, T gateway) {
        super(context, idSuffix, name, "EventBasedGatewayBlock", gateway);
    }

    protected static String getElementInitiateId(FlowNode element) {
        String result = null;
        if (element.getBpmnType() == BpmnType.RECEIVE_TASK) {
            ReceiveTask receiveTask = (ReceiveTask)element.asAnyNode(ReceiveTask.class);
            result = receiveTask.getOperationRef().getName();
        } else {
            CatchEvent event = (CatchEvent)element.asAnyNode(CatchEvent.class);
            if (event != null) {
                if (event.getEventTriggerType() == EventTriggerType.MESSAGE) {
                    ConversationEnabled conversationalElement = (ConversationEnabled)element;
                    result = conversationalElement.getOperationRef().getName();
                } else if (event.getEventTriggerType() == EventTriggerType.TIMER) {
                    result = element.getId();
                } else if (event.getEventTriggerType() == EventTriggerType.SIGNAL) {
                    result = ((SignalEventDefinition)event.getEventDefinition().as(SignalEventDefinition.class)).getSignal().getEventQName().toString();
                } else if (event.getEventTriggerType() == EventTriggerType.NONE) {
                    result = event.isStart() && ManualInitiatorStartFeature.isUserInitiator((StartEvent)event.asAnyNode(StartEvent.class)) ? "START_EVENT_USER_INITIATE" : "";
                }
            }
        }
        return result;
    }

    protected static String getInstanceInitiateId(ICubeContext ctx) {
        String result = (String)ctx.getFromEnvironment("__call-operation-name");
        if (result.equals(BPMNRuntimeConstants.CREATE_COMPONENT_INSTANCE_EVENT_QNAME.toString())) {
            result = (String)((Map)ctx.getFromEnvironment("__call-properties")).get("START_EVENT_ID_PROPERTY");
        }
        return result;
    }

    @Override
    protected void activateEntryElement(HashMap<String, Object> token, IScope scope, BPMNCubeElement element, ICubeContext ctx) throws CubeException {
        BPMNTokenManager.generateOpenToken(scope, this, element.getId(), token);
    }

    @Override
    protected IScopeImpl[] doActivate(IScopeContext sc, IScopeImpl pScope, ICubeContext ctx) throws Exception {
        IScopeImpl[] iScopes;
        for (IScopeImpl scope : iScopes = super.doActivate(sc, pScope, ctx)) {
            ThreadCountManager.increaseThreadCount((IScope)scope);
        }
        return iScopes;
    }

    @Override
    protected void generateExitTokens(IScope scope) throws CubeException {
    }

    public static class NonInitiateEventBasedGatewayBlock<T extends EventBasedGateway>
    extends EventBasedGatewayBlock<T> {
        public NonInitiateEventBasedGatewayBlock(BPMNCubeMapBuilderContext context, String idSuffix, String name, T gateway) {
            super(context, idSuffix, name, gateway);
        }
    }

    public static class InitiateEventBasedGatewayBlock<T extends EventBasedGateway>
    extends EventBasedGatewayBlock<T> {
        private static final String TOKEN_SET = "TOKEN_SET";

        public InitiateEventBasedGatewayBlock(BPMNCubeMapBuilderContext context, String idSuffix, String name, T gateway) {
            super(context, idSuffix, name, gateway);
        }

        @Override
        protected void activateEntryElement(HashMap<String, Object> token, IScope scope, BPMNCubeElement element, ICubeContext ctx) throws CubeException {
            boolean tokenAlreadySetted = scope.containsLocally(TOKEN_SET);
            if (!tokenAlreadySetted) {
                String initiateId = InitiateEventBasedGatewayBlock.getInstanceInitiateId(ctx);
                String elementInitiateId = InitiateEventBasedGatewayBlock.getElementInitiateId(element.getFlowElement());
                if (initiateId != null && initiateId.equals(elementInitiateId)) {
                    super.activateEntryElement(token, scope, element, ctx);
                    scope.declareAndSet(TOKEN_SET, true);
                }
            }
        }
    }
}

