/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.blocks;

import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.model.blocks.BPMNCallableProcessBlock;
import oracle.bpm.bpmn.engine.model.blocks.BPMNLoopBlock;
import oracle.bpm.bpmn.engine.model.blocks.BPMNMultiInstanceBlock;
import oracle.bpm.bpmn.engine.model.blocks.BPMNSubProcessBlock;
import oracle.bpm.bpmn.engine.model.blocks.DummyBlock;
import oracle.bpm.bpmn.engine.model.blocks.EventBasedGatewayBlock;
import oracle.bpm.bpmn.engine.model.blocks.MultiStartBlock;
import oracle.bpm.bpmn.engine.model.blocks.ProcessTryBlock;
import oracle.bpm.bpmn.engine.model.blocks.ScopeBlock;
import oracle.bpm.bpmn.engine.model.blocks.TryBlock;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Loop;
import oracle.bpm.project.model.processes.MultiInstance;
import oracle.bpm.project.model.processes.Subprocess;

public class BlockFactory {
    public static <T extends FlowNode> ScopeBlock createScopeBlock(BPMNCubeMapBuilderContext context, String name, T element) {
        return new ScopeBlock<T>(context, "_scope", name, element);
    }

    public static BPMNSubProcessBlock createSubProcessBlock(BPMNCubeMapBuilderContext context, String name, Subprocess element) {
        String suffix = element.isTriggeredByEvent() ? "_inline" : "_subprocess";
        return new BPMNSubProcessBlock(context, suffix, name, element);
    }

    public static BPMNCallableProcessBlock createCallableProcessBlock(BPMNCubeMapBuilderContext context, String name, CallActivity element) {
        return new BPMNCallableProcessBlock(context, "_process", name, element);
    }

    public static <T extends FlowNode> DummyBlock createDummyBlock(BPMNCubeMapBuilderContext context, String name, T element) {
        return new DummyBlock<T>(context, "_dummy", name, element);
    }

    public static <T extends FlowNode> TryBlock createTryBlock(BPMNCubeMapBuilderContext context, String name, T element) {
        return BlockFactory.createTryBlock(context, "_try", name, element);
    }

    public static <T extends FlowNode> TryBlock createTryBlock(BPMNCubeMapBuilderContext context, String suffix, String name, T element) {
        return new TryBlock<T>(context, suffix, name, element);
    }

    public static <T extends FlowNode> ProcessTryBlock createProcessTryBlock(BPMNCubeMapBuilderContext context, String name, T element) {
        return BlockFactory.createProcessTryBlock(context, "_try", name, element);
    }

    public static <T extends FlowNode> ProcessTryBlock createProcessTryBlock(BPMNCubeMapBuilderContext context, String suffix, String name, T element) {
        return new ProcessTryBlock<T>(context, suffix, name, element);
    }

    public static <T extends EventBasedGateway> EventBasedGatewayBlock<T> createEventBasedGatewayBlock(BPMNCubeMapBuilderContext context, String name, T element) {
        if (element.isInstantiate()) {
            return new EventBasedGatewayBlock.InitiateEventBasedGatewayBlock<T>(context, "_ebg", name, element);
        }
        return new EventBasedGatewayBlock.NonInitiateEventBasedGatewayBlock<T>(context, "_ebg", name, element);
    }

    public static BPMNLoopBlock createLoopBlock(BPMNCubeMapBuilderContext context, String blockId, String blockName, Activity activity, Loop loop) {
        return new BPMNLoopBlock(context, blockId, blockName, activity, loop);
    }

    public static BPMNMultiInstanceBlock createMultiInstanceBlock(BPMNCubeMapBuilderContext context, String blockId, String blockName, Activity activity, MultiInstance multiInstance) {
        return new BPMNMultiInstanceBlock(context, blockId, blockName, activity, multiInstance);
    }

    public static MultiStartBlock createMultiStartBlock(BPMNCubeMapBuilderContext context, String name, FlowNode element) {
        return new MultiStartBlock<FlowNode>(context, "_multistart", name, element);
    }
}

