/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.blocks;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IScopeImpl;
import com.collaxa.cube.engine.ext.bpel.common.BaseBPELCubeBlock;
import com.collaxa.cube.engine.util.ThreadCountManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.model.blocks.BlockSequenceFlowMetadata;
import oracle.bpm.bpmn.engine.model.blocks.BlockSequenceFlowMetadataSupport;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenManager;

public class BaseBPMNBlock
extends BaseBPELCubeBlock {
    private Map<String, IMicroInstruction> microInstructionsMap = new HashMap<String, IMicroInstruction>();
    private BlockSequenceFlowMetadata sequenceFlowMetadata = new BlockSequenceFlowMetadataSupport();
    private static final String ACTIVATION_TOKEN = "ACTIVATION_TOKEN";

    public BlockSequenceFlowMetadata getSequenceFlowMetadata() {
        return this.sequenceFlowMetadata;
    }

    public String[] getEntryTokens() {
        if (this.getSequenceFlowMetadata().getEntryElements().isEmpty()) {
            return super.getEntryTokens();
        }
        return BaseBPMNBlock.convertToEntryTokensArray(this.getSequenceFlowMetadata().getEntryElements());
    }

    public void addMicroInstruction(String tag, IMicroInstruction mi) {
        this.microInstructionsMap.put(tag, mi);
    }

    public IMicroInstruction getMicroInstruction(String tag) {
        return this.microInstructionsMap.get(tag);
    }

    public Map<String, IMicroInstruction> getMicroInstructionMap() {
        return Collections.unmodifiableMap(this.microInstructionsMap);
    }

    protected void doActivateScope(HashMap<String, Object> token, IScopeImpl scope, ICubeContext ctx) throws CubeException {
        this.saveActivationToken(token, (IScope)scope);
        for (BPMNCubeElement element : this.getSequenceFlowMetadata().getEntryElements()) {
            this.activateEntryElement(token, (IScope)scope, element, ctx);
        }
    }

    protected void activateEntryElement(HashMap<String, Object> token, IScope scope, BPMNCubeElement element, ICubeContext ctx) throws CubeException {
        if (element.isStartOfMainFlow()) {
            ThreadCountManager.increaseThreadCount((IScope)scope);
        }
        this.generateOpenToken(token, scope, element);
    }

    protected void generateOpenToken(HashMap<String, Object> token, IScope scope, BPMNCubeElement element) throws CubeException {
        BPMNTokenManager.generateOpenToken(scope, null, element.getId(), token);
    }

    protected void saveActivationToken(HashMap<String, Object> token, IScope scope) throws CubeException {
        scope.declareAndSet(ACTIVATION_TOKEN, token);
    }

    protected HashMap<String, Object> getActivationToken(IScope scope) throws CubeException {
        return (HashMap)scope.getAsObject(ACTIVATION_TOKEN);
    }

    private static String[] convertToEntryTokensArray(List<BPMNCubeElement> list) {
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (BPMNCubeElement element : list) {
            result.add(element.getId());
        }
        return result.toArray(new String[list.size()]);
    }
}

