/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.blocks;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IScopeContext;
import com.collaxa.cube.engine.core.IScopeImpl;
import com.collaxa.cube.engine.core.map.ICubeNode;
import com.collaxa.cube.engine.ext.bpel.v1.nodes.BPELDPEWMP;
import com.collaxa.cube.engine.util.EventCountManager;
import com.collaxa.cube.engine.util.ThreadCountManager;
import com.collaxa.cube.engine.util.TokenManager;
import java.util.HashMap;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.microkernel.MINop;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.UnconditionalSequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenManager;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.soa.common.collections.Queue;

public abstract class BaseBPMNActivityBlock<T extends FlowNode>
extends BaseBPMNBlock
implements BPMNCubeElement<T> {
    private boolean boundaryFlowEndElement = false;
    private String[] exitTokens;
    private T flowElement;
    private boolean startOfMainFlow = true;
    protected static final String BLOCK_ACTIVATE = "BLOCK_ACTIVATE";
    protected static final String BLOCK_COMPLETE = "BLOCK_COMPLETE";
    protected static final String BLOCK_EXCEPTION = "BLOCK_EXCEPTION";

    public BaseBPMNActivityBlock(BPMNCubeMapBuilderContext context, String name, String type, T flowElement) {
        this(context, "", name, type, flowElement);
    }

    public BaseBPMNActivityBlock(BPMNCubeMapBuilderContext context, String idSuffix, String name, String type, T flowElement) {
        super.setId(flowElement == null ? name + idSuffix : context.getCubeElementId((FlowNode)flowElement, idSuffix));
        this.setName(name);
        this.setType(type);
        this.flowElement = flowElement;
        this.initMicroInstructions(context);
    }

    public final String getId() {
        return super.getId();
    }

    public final void setId(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T getFlowElement() {
        return this.flowElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getExitTokens() {
        BaseBPMNActivityBlock baseBPMNActivityBlock = this;
        synchronized (baseBPMNActivityBlock) {
            if (this.exitTokens == null) {
                this.exitTokens = new String[]{this.getExitToken()};
            }
        }
        return this.exitTokens;
    }

    public IScopeImpl[] activate(IScopeContext sc, IScopeImpl pScope, ICubeContext ctx) throws Exception {
        IScopeImpl[] iScopes = this.doActivate(sc, pScope, ctx);
        this.initScopes((IScope[])iScopes);
        return iScopes;
    }

    @Override
    public boolean isNonMainFlowEndElement() {
        return this.boundaryFlowEndElement;
    }

    @Override
    public void setNonMainFlowEndElement(boolean value) {
        this.boundaryFlowEndElement = value;
    }

    @Override
    public boolean isStartOfMainFlow() {
        return this.startOfMainFlow;
    }

    @Override
    public void setStartOfMainFlow(boolean value) {
        this.startOfMainFlow = value;
    }

    public boolean until(IScope scope, ICubeContext ctx) throws Throwable {
        if (EventCountManager.getEventCount((IScope)scope) == 0) {
            boolean result = super.until(scope, ctx);
            return result;
        }
        return false;
    }

    public void onComplete(IScopeImpl scope, ICubeContext ctx) {
        this.executeProcedureControlledWithoutException((IScope)scope, ctx, BLOCK_COMPLETE, null, null);
        super.onComplete(scope, ctx);
    }

    public boolean handleException(IScope scope, Throwable exception, ICubeContext ctx) throws Exception {
        this.executeProcedureControlledWithoutException(scope, ctx, BLOCK_EXCEPTION, null, exception);
        return super.handleException(scope, exception, ctx);
    }

    @Override
    protected void generateOpenToken(HashMap<String, Object> token, IScope scope, BPMNCubeElement element) throws CubeException {
        BPMNTokenManager.generateOpenToken(scope, this, element.getId(), token);
    }

    protected IScopeImpl[] doActivate(IScopeContext sc, IScopeImpl pScope, ICubeContext ctx) throws Exception {
        Queue tokenQueue = BPMNTokenManager.getTokenObject((IScope)pScope, this.getId());
        HashMap<String, Object> token = BPMNTokenMetadataUtils.convertToToken(tokenQueue.peek(0));
        IScopeImpl[] scs = this.activate(sc, pScope, false, ctx);
        boolean joinSuccessFul = this.evaluateJoinCondition((IScope)pScope, ctx);
        for (IScopeImpl scope : scs) {
            if (joinSuccessFul) {
                this.doActivateScope(token, scope, ctx);
                continue;
            }
            for (ICubeNode node : this.getChildNodes()) {
                if (!(node instanceof BPELDPEWMP)) continue;
                ThreadCountManager.increaseThreadCount((IScope)scope);
                TokenManager.generateOpenToken((IScope)scope, (String)node.getId());
            }
        }
        return scs;
    }

    protected void generateOpenTokens(IScopeImpl[] scs, IScopeContext sc, IScopeImpl pScope, ICubeContext ctx) throws Exception {
    }

    protected void generateExitTokens(IScope scope) throws CubeException {
        IScope parentScope = scope.getParentScope();
        if (!scope.getBoolean("++exit-block-with-exception")) {
            for (String exitToken : this.getExitTokens()) {
                HashMap<String, Object> tokenMetadata = this.getExitTokenMetadata(scope);
                if (exitToken.equals(this.getParentBlockId())) {
                    this.decreaseThreadCount(parentScope);
                    this.propagetExitTokenMetadata(parentScope, tokenMetadata);
                    continue;
                }
                BPMNTokenManager.generateOpenToken(parentScope, this, exitToken, tokenMetadata);
            }
        }
    }

    protected HashMap<String, Object> getExitTokenMetadata(IScope scope) throws CubeException {
        return (HashMap)scope.getAsObject("EXIT_TOKEN_METADATA");
    }

    protected void propagetExitTokenMetadata(IScope parentScope, HashMap<String, Object> tokenMetadata) throws CubeException {
        if (tokenMetadata != null) {
            parentScope.declareAndSet("EXIT_TOKEN_METADATA", tokenMetadata);
        }
    }

    protected void decreaseThreadCount(IScope scope) throws CubeException {
        if (this.isNonMainFlowEndElement()) {
            EventCountManager.decreaseEventCount((IScope)scope);
        } else {
            ThreadCountManager.decreaseThreadCount((IScope)scope);
        }
    }

    protected void __initScope(IScope scope, ICubeContext ctx) throws Exception {
        super.__initScope(scope, ctx);
        EventCountManager.initEventCount((IScope)scope);
    }

    protected MicroInstructionContext createMicroInstructionContext(IScope scope, ICubeContext ctx) throws CubeException {
        HashMap<String, Object> nodeActivationContext = this.getActivationToken(scope);
        return new MicroInstructionContext(ctx, scope, (BPMNCubeElement)this, nodeActivationContext);
    }

    protected Object executeProcedureControlledWithoutException(IScope scope, ICubeContext ctx, String procedure, String procedure_exception, Throwable exception) {
        MicroInstructionContext context;
        try {
            context = this.createMicroInstructionContext(scope, ctx);
        }
        catch (CubeException e) {
            throw new RuntimeException(e);
        }
        context.setLastException(exception);
        return context.executeProcedureControlledWithoutException(procedure, procedure_exception);
    }

    @Override
    protected void doActivateScope(HashMap<String, Object> token, IScopeImpl scope, ICubeContext ctx) throws CubeException {
        super.doActivateScope(token, scope, ctx);
        this.executeProcedureControlledWithoutException((IScope)scope, ctx, BLOCK_ACTIVATE, null, null);
    }

    protected void initMicroInstructions(BPMNCubeMapBuilderContext context) {
        this.addMicroInstruction(BLOCK_ACTIVATE, new MINop());
        this.addMicroInstruction(BLOCK_COMPLETE, new MINop());
        this.addMicroInstruction(BLOCK_EXCEPTION, new MINop());
    }

    private String getExitToken() {
        UnconditionalSequenceFlowInfo flowInfo = this.getSequenceFlowMetadata().getOutgoingSequenceFlow();
        String token = flowInfo != null ? flowInfo.getTargetNodeId() : this.getParentBlock().getId();
        return token;
    }

    private void initScopes(IScope[] scopes) throws CubeException {
        for (IScope scope : scopes) {
            scope.declareAndSet("++exit-block-with-exception", false);
        }
    }
}

