/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.blocks;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ConfigurationHelper;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.CubeEngineLogger;
import com.collaxa.cube.engine.EngineException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.CubeInstanceImpl;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IScopeContext;
import com.collaxa.cube.engine.core.IScopeImpl;
import com.collaxa.cube.engine.types.bpel.CXPartnerLink;
import com.collaxa.cube.engine.util.ThreadCountManager;
import com.collaxa.cube.lang.compiler.bpel.BPELDefs;
import com.oracle.bpel.client.BPELFault;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.ServiceLink;
import oracle.bpm.bpmn.engine.microkernel.MINop;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNBlock;
import oracle.bpm.bpmn.engine.model.runtime.common.BPMNRuntimeConstants;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMRuntimeLogger;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.processes.DataElementScope;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.util.Locales;
import oracle.fabric.composite.model.PropertyModel;
import oracle.soa.common.util.NonSyncStringBuffer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BPMNProcessBlock
extends BaseBPMNBlock {
    private Process model;
    private final Set<ServiceLink> serviceLinks;
    protected static final String BLOCK_ACTIVATE = "BLOCK_ACTIVATE";
    protected static final String BLOCK_COMPLETE = "BLOCK_COMPLETE";
    private static final String logClassName = BPMNProcessBlock.class.getName();

    public BPMNProcessBlock(String id, Process model, Set<ServiceLink> serviceLinks) {
        this.setId(id);
        this.setName(model.getLabel(Locales.getDefaultLocale()));
        this.setType("process");
        this.model = model;
        this.bIsMethodBlock = true;
        this.serviceLinks = serviceLinks;
        this.initMicroInstructions(null);
    }

    public Process getModel() {
        return this.model;
    }

    public IScopeImpl[] activate(IScopeContext sc, IScopeImpl pScope, ICubeContext ctx) throws Exception {
        ICubeInstanceImpl ci = sc.getCubeInstance();
        if (ci.getTitle() == null) {
            NonSyncStringBuffer sb = new NonSyncStringBuffer(128);
            sb.append("Instance #").append(ci.getId()).append(" of ").append(ci.getProcessClass().getScaComponent().getName());
            ci.setTitle(sb.toString());
        }
        CubeEngineLogger.debug((Object)("BPMNProcessBlock activated for instance " + ci.getTitle()));
        ci.setStatus("initiated");
        pScope.declareAndSet("++default-status", true);
        pScope.declareAndSet("++active-sync-call", null);
        List headers = (List)ctx.getFromEnvironment("__call-headers");
        if (Boolean.getBoolean("oracle.bpm.runtime.tests.enabled")) {
            for (int i = 0; i < headers.size(); ++i) {
                Element element = (Element)headers.get(i);
                this.lookForLogKey(pScope, element);
            }
        }
        IScopeImpl scImpl = this.__activate(sc, pScope, ctx);
        HashMap<String, Object> token = BPMNTokenMetadataUtils.createNewTokenMetadata((IScope)pScope);
        this.doActivateScope(token, scImpl, ctx);
        return new IScopeImpl[]{scImpl};
    }

    public boolean until(IScope scope, ICubeContext ctx) throws Throwable {
        if (ThreadCountManager.getThreadCount((IScope)scope) == 0) {
            CubeEngineLogger.debug((String)"ProcessBlock", (String)"until", (Object)"ProcessBlock '", (Object)this.getId(), (Object)"' until() true");
            if (!scope.getBoolean("++default-status")) {
                scope.getCubeInstance().setStatus("completed");
            }
            return true;
        }
        return false;
    }

    public boolean handleException(IScope scope, Throwable exception, ICubeContext ctx) throws Exception {
        BPELFault bf;
        if (exception instanceof BPELFault && BPELDefs.QN_ROLLBACK.equals((bf = (BPELFault)exception).getFaultName())) {
            CubeEngineLogger.error((String)"BPELScopeBlock", (String)"__handleException", (Object)"Caught rollbackFault ... throwing exception");
            throw new EngineException(2180);
        }
        return false;
    }

    public String getInitialTrackingLevel(ICubeContext ctx) throws CubeException {
        ICubeInstanceImpl ci = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        String level = ConfigurationHelper.getPropertyFromInstance((ICubeInstanceImpl)ci, (String)"auditLevel");
        if (level != null) {
            return level;
        }
        PropertyModel prop = CubeContextHelper.getCubeInstance((ICubeContext)ctx).getProcessClass().getScaComponent().getComposite().getProperty("auditLevel");
        if (prop != null) {
            level = prop.getValue();
        }
        if (level != null) {
            return level;
        }
        level = CubeContextHelper.getServerManager((ICubeContext)ctx).getCubeServiceEngine().getSoaInfraConfig().getAuditConfig().getLevel();
        return level;
    }

    public Set<ServiceLink> getServiceLinks() {
        return Collections.unmodifiableSet(this.serviceLinks);
    }

    protected void __initScope(IScope sc, ICubeContext ctx) throws Exception {
        super.__initScope(sc, ctx);
        DataHandlingUtils.declareDataObjects(sc, ctx, (DataElementScope)this.getModel());
        for (ProjectDataObject dataObject : this.getModel().getProject().getProjectDataObjects()) {
            if (DataHandlingUtils.declareAndSet((DataDeclaration)dataObject, sc, ctx)) continue;
            BPMRuntimeLogger.log(Level.SEVERE, BPMNProcessBlock.class.toString(), "__initScope", "Failed to declare project dataObject " + dataObject.getName() + " in scope " + sc.getScopeId() + " with type " + dataObject.getType().getText());
        }
        for (ServiceLink serviceLink : this.getServiceLinks()) {
            CXPartnerLink cxPartnerLink = new CXPartnerLink();
            cxPartnerLink.setName(serviceLink.getName());
            if (serviceLink.isReference()) {
                cxPartnerLink.getMyRole().setPortType(serviceLink.getCallbackInterfacePortType());
                cxPartnerLink.getPartnerRole().setPortType(serviceLink.getInterfacePortType());
            } else {
                cxPartnerLink.getMyRole().setPortType(serviceLink.getInterfacePortType());
                cxPartnerLink.getPartnerRole().setPortType(serviceLink.getCallbackInterfacePortType());
            }
            sc.declareAndSet(cxPartnerLink.getName(), (Object)cxPartnerLink);
        }
        this.__initScopeBPEL(sc, ctx);
    }

    protected IScopeImpl __activate(IScopeContext sc, IScopeImpl pScope, ICubeContext ctx) throws Exception {
        IScopeImpl ms = sc.createScope(this.getId(), pScope, sc.getNextScopeId(), true, false, ctx);
        String sId = ms.getAbsoluteScopeId();
        CubeEngineLogger.debug((String)"MethodCubeBlock", (String)"activate", (Object)"Create method scope '", (Object)sId, (Object)"' in block '", (Object)this.getId(), (Object)"'");
        this.__initScope((IScope)ms, ctx);
        String methodName = "process";
        ms.declareAndSet("_$$method-map", (Object)methodName);
        return ms;
    }

    protected void initMicroInstructions(BPMNCubeMapBuilderContext context) {
        this.addMicroInstruction(BLOCK_ACTIVATE, new MINop());
        this.addMicroInstruction(BLOCK_COMPLETE, new MINop());
    }

    private void lookForLogKey(IScopeImpl pScope, Element element) throws CubeException {
        if (BPMNRuntimeConstants.LOGKEY_HEADER.getNamespaceURI().equals(element.getNamespaceURI()) && BPMNRuntimeConstants.LOGKEY_HEADER.getLocalPart().equals(element.getLocalName())) {
            Node firstChild = element.getFirstChild();
            if (firstChild != null) {
                String logKey = firstChild.getNodeValue();
                if (!logKey.endsWith("-")) {
                    logKey = logKey + "-";
                }
                pScope.declareAndSet("LOG_EXECUTION_PATH_KEY", (Object)logKey);
            }
        } else {
            NodeList childNodes = element.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(0);
                if (!(node instanceof Element)) continue;
                this.lookForLogKey(pScope, (Element)node);
            }
        }
    }

    private void __initScopeBPEL(IScope sc, ICubeContext ctx) throws CubeException {
        Map instProps = sc.getProperties();
        Map props = (Map)ctx.getFromEnvironment("__call-properties");
        if (props != null) {
            instProps.putAll(props);
        }
        List instHeaders = sc.getHeaders();
        List headers = (List)ctx.getFromEnvironment("__call-headers");
        if (headers != null) {
            for (int i = 0; i < headers.size(); ++i) {
                Element header = (Element)headers.get(i);
                instHeaders.add(header);
            }
        }
        CubeInstanceImpl ci = (CubeInstanceImpl)sc.getCubeInstance();
        ci.setParentRefId((String)sc.getProperties().get("tracking.parentReferenceId"));
        Object obj = instProps.get("priority");
        try {
            if (obj != null) {
                ci.setPriority(Integer.parseInt(String.valueOf(obj)));
            }
        }
        catch (Exception e) {
            CubeEngineLogger.debug((String)"ProcessBlock", (String)"initializeHeader", (Object)"For instance '", (Object)this.getId(), (Object)"' cannot set priority to '", obj, (Object)"'");
        }
    }
}

