/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.CubeEngineLogger;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.xml.schema.XMLSchemaUtils;
import java.net.URI;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import oracle.bpm.bpmn.engine.model.TimerStartEventListener;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNNamespaceContext;
import oracle.bpm.bpmn.engine.runtime.xpath.BPMNXPathFunctionResolver;
import oracle.bpm.bpmn.engine.runtime.xpath.BPMNXPathUtil;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.model.features.TimerFeature;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.integration.platform.blocks.scheduler.FabricSchedulerFactory;
import oracle.integration.platform.blocks.scheduler.FabricSchedulerService;
import oracle.integration.platform.blocks.scheduler.StringProperties;
import org.jetbrains.annotations.Nullable;

public class TimerStartEventScheduler {
    public static void schedule(ICubeContext ctx, String compositeDN, String componentName, Collection<CatchEvent> timerEvents) {
        for (CatchEvent timerEvent : timerEvents) {
            String timerStartEventId = timerEvent.getId();
            StringProperties props = new StringProperties();
            props.put((Object)"COMPONENT_NAME", (Object)componentName);
            props.put((Object)"START_TIMER_ID", (Object)timerStartEventId);
            Expression cycleExpression = ((TimerFeature)timerEvent.getFeature(TimerFeature.class)).getTimeCycleExpression();
            Expression timeDateExpression = ((TimerFeature)timerEvent.getFeature(TimerFeature.class)).getTimeDateExpression();
            TimerStartEventScheduler.schedule(ctx, compositeDN, componentName, timerStartEventId, props, cycleExpression, timeDateExpression);
        }
    }

    public static void schedule(ICubeContext ctx, String compositeDN, String componentName, String timerStartEventId, StringProperties props, Expression cycleExpression, Expression timeDateExpression) {
        Date expDate = TimerStartEventScheduler.getExpirationDate(ctx, props, cycleExpression, timeDateExpression);
        if (expDate != null) {
            CubeEngineLogger.debug((Object)("schedule " + compositeDN + " for " + expDate));
            Calendar start = Calendar.getInstance();
            start.setTime(expDate);
            FabricSchedulerService schd = FabricSchedulerFactory.getInstance().getSchedulerService();
            schd.scheduleJob(compositeDN, TimerStartEventScheduler.buildKey(componentName, timerStartEventId), props, start, TimerStartEventListener.class);
        }
    }

    private static String buildKey(String componentName, String timerStartEventId) {
        return componentName + "." + timerStartEventId;
    }

    @Nullable
    private static Date getExpirationDate(ICubeContext ctx, StringProperties props, Expression cycleExpression, Expression timeDateExpression) {
        Expression xpathExpression = cycleExpression != null ? cycleExpression : timeDateExpression;
        String expressionResult = null;
        try {
            expressionResult = TimerStartEventScheduler.evalXPath(ctx, xpathExpression);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        catch (CubeException e) {
            e.printStackTrace();
        }
        Date expDate = null;
        if (expressionResult != null) {
            if (cycleExpression != null) {
                long duration = XMLSchemaUtils.parseDuration((String)expressionResult);
                expDate = new Date(System.currentTimeMillis() + duration);
                props.put((Object)"CYCLE_EXPRESSION_PROPERTY", (Object)cycleExpression.getExpressionValue());
                for (Map.Entry entry : cycleExpression.getNamespaces().entrySet()) {
                    props.put((Object)("xmlns:" + (String)entry.getKey()), (Object)((URI)entry.getValue()).toString());
                }
            } else if (timeDateExpression != null) {
                expDate = XMLSchemaUtils.parseDateTime((String)expressionResult).getTime();
            }
        }
        return expDate;
    }

    private static String evalXPath(ICubeContext ctx, Expression expression) throws XPathExpressionException, CubeException {
        XPath xpath = BPMNXPathUtil.getXPath((NamespaceContext)new BPMNNamespaceContext(expression.getNamespaces()));
        xpath.setXPathFunctionResolver((XPathFunctionResolver)((Object)TimerStartEventScheduler.getFunctionResolver(ctx)));
        return (String)BPMNXPathUtil.evaluate(expression.getExpressionValue(), xpath, ctx, XPathConstants.STRING, null);
    }

    private static BPMNXPathFunctionResolver getFunctionResolver(ICubeContext ctx) throws CubeException {
        return ((BPMNServiceEngine)CubeContextHelper.getServerManager((ICubeContext)ctx).getCubeServiceEngine()).getBPMNXPathFunctionResolver();
    }
}

